/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.client.writer;

import com.atomgraph.client.util.DataManager;
import com.atomgraph.client.writer.XSLTWriterBase;
import jakarta.inject.Singleton;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.xml.transform.TransformerException;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XsltExecutable;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ResultSetXSLTWriter
extends XSLTWriterBase
implements MessageBodyWriter<ResultSet> {
    private static final Logger log = LoggerFactory.getLogger(ResultSetXSLTWriter.class);

    public ResultSetXSLTWriter(XsltExecutable xsltExec, OntModelSpec ontModelSpec, DataManager dataManager) {
        super(xsltExec, ontModelSpec, dataManager);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ResultSet.class.isAssignableFrom(type);
    }

    public long getSize(ResultSet results, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(ResultSet results, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headerMap, OutputStream entityStream) throws IOException, WebApplicationException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ResultSetFormatter.outputAsXML((OutputStream)baos, (ResultSet)results);
            this.transform(baos, mediaType, headerMap, entityStream);
        }
        catch (TransformerException | SaxonApiException ex) {
            if (log.isErrorEnabled()) {
                log.error("XSLT transformation failed", ex);
            }
            throw new InternalServerErrorException(ex);
        }
    }
}

