/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.client;

import com.atomgraph.client.MediaTypes;
import com.atomgraph.client.locator.PrefixMapper;
import com.atomgraph.client.mapper.ClientErrorExceptionMapper;
import com.atomgraph.client.mapper.NotFoundExceptionMapper;
import com.atomgraph.client.mapper.RiotExceptionMapper;
import com.atomgraph.client.model.impl.ProxyResourceBase;
import com.atomgraph.client.util.DataManager;
import com.atomgraph.client.util.DataManagerImpl;
import com.atomgraph.client.util.XsltResolver;
import com.atomgraph.client.vocabulary.AC;
import com.atomgraph.client.writer.ModelXSLTWriter;
import com.atomgraph.client.writer.ResultSetXSLTWriter;
import com.atomgraph.client.writer.function.Construct;
import com.atomgraph.client.writer.function.ConstructForClass;
import com.atomgraph.client.writer.function.UUID;
import com.atomgraph.core.client.LinkedDataClient;
import com.atomgraph.core.io.DatasetProvider;
import com.atomgraph.core.io.ModelProvider;
import com.atomgraph.core.io.QueryProvider;
import com.atomgraph.core.io.ResultSetProvider;
import com.atomgraph.core.io.UpdateRequestProvider;
import com.atomgraph.core.mapper.BadGatewayExceptionMapper;
import com.atomgraph.core.provider.QueryParamProvider;
import com.atomgraph.core.riot.RDFLanguages;
import com.atomgraph.core.riot.lang.RDFPostReaderFactory;
import com.atomgraph.core.vocabulary.A;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.ExtensionFunction;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import org.apache.jena.ontology.OntDocumentManager;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.util.FileManager;
import org.apache.jena.util.LocationMapper;
import org.apache.jena.vocabulary.ReasonerVocabulary;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.HttpMethodOverrideFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Application
extends ResourceConfig {
    private static final Logger log = LoggerFactory.getLogger(Application.class);
    private final MediaTypes mediaTypes;
    private final Client client;
    private final DataManager dataManager;
    private final Source stylesheet;
    private final Boolean cacheStylesheet;
    private final OntModelSpec ontModelSpec;
    private final Processor xsltProc = new Processor(false);
    private final XsltExecutable xsltExec;

    public Application(@Context ServletConfig servletConfig) throws URISyntaxException, IOException {
        this(new MediaTypes(), Application.getClient((ClientConfig)new ClientConfig()), servletConfig.getServletContext().getInitParameter(A.maxGetRequestSize.getURI()) != null ? Integer.valueOf(servletConfig.getServletContext().getInitParameter(A.maxGetRequestSize.getURI())) : null, servletConfig.getServletContext().getInitParameter(A.preemptiveAuth.getURI()) != null ? Boolean.parseBoolean(servletConfig.getServletContext().getInitParameter(A.preemptiveAuth.getURI())) : false, Application.getDataManager((LocationMapper)new PrefixMapper(servletConfig.getServletContext().getInitParameter(AC.prefixMapping.getURI()) != null ? servletConfig.getServletContext().getInitParameter(AC.prefixMapping.getURI()) : null), (Client)Application.getClient((ClientConfig)new ClientConfig()), (MediaTypes)new MediaTypes(), (boolean)(servletConfig.getServletContext().getInitParameter(A.cacheModelLoads.getURI()) != null ? Boolean.parseBoolean(servletConfig.getServletContext().getInitParameter(A.cacheModelLoads.getURI())) : false), (boolean)(servletConfig.getServletContext().getInitParameter(A.preemptiveAuth.getURI()) != null ? Boolean.parseBoolean(servletConfig.getServletContext().getInitParameter(A.preemptiveAuth.getURI())) : false), (boolean)(servletConfig.getServletContext().getInitParameter(AC.resolvingUncached.getURI()) != null ? Boolean.parseBoolean(servletConfig.getServletContext().getInitParameter(AC.resolvingUncached.getURI())) : false)), Application.getSource((ServletContext)servletConfig.getServletContext(), servletConfig.getServletContext().getInitParameter(AC.stylesheet.getURI()) != null ? servletConfig.getServletContext().getInitParameter(AC.stylesheet.getURI()) : null), servletConfig.getServletContext().getInitParameter(AC.cacheStylesheet.getURI()) != null ? Boolean.parseBoolean(servletConfig.getServletContext().getInitParameter(AC.cacheStylesheet.getURI())) : false, (servletConfig.getServletContext().getInitParameter(AC.resolvingUncached.getURI()) != null ? Boolean.valueOf(Boolean.parseBoolean(servletConfig.getServletContext().getInitParameter(AC.resolvingUncached.getURI()))) : null).booleanValue());
    }

    public Application(MediaTypes mediaTypes, Client client, Integer maxGetRequestSize, boolean preemptiveAuth, DataManager dataManager, Source stylesheet, boolean cacheStylesheet, boolean resolvingUncached) {
        this.mediaTypes = mediaTypes;
        this.client = client;
        this.stylesheet = stylesheet;
        this.cacheStylesheet = cacheStylesheet;
        this.dataManager = dataManager;
        OntDocumentManager.getInstance().setFileManager((FileManager)dataManager);
        if (log.isDebugEnabled()) {
            log.debug("OntDocumentManager.getInstance().getFileManager(): {}", (Object)OntDocumentManager.getInstance().getFileManager());
        }
        OntModelSpec rdfsReasonerSpec = new OntModelSpec(OntModelSpec.OWL_MEM);
        Resource reasonerConfig = ModelFactory.createDefaultModel().createResource().addProperty(ReasonerVocabulary.PROPsetRDFSLevel, "simple");
        Reasoner reasoner = RDFSRuleReasonerFactory.theInstance().create(reasonerConfig);
        rdfsReasonerSpec.setReasoner(reasoner);
        this.ontModelSpec = rdfsReasonerSpec;
        RDFLanguages.register((Lang)RDFLanguages.RDFPOST);
        RDFParserRegistry.registerLangTriples((Lang)RDFLanguages.RDFPOST, (ReaderRIOTFactory)new RDFPostReaderFactory());
        RDFWriterRegistry.register((Lang)Lang.RDFXML, (RDFFormat)RDFFormat.RDFXML_PLAIN);
        this.xsltProc.registerExtensionFunction((ExtensionFunction)new UUID());
        this.xsltProc.registerExtensionFunction((ExtensionFunction)new Construct(this.xsltProc));
        this.xsltProc.registerExtensionFunction((ExtensionFunction)new ConstructForClass(this.xsltProc, OntDocumentManager.getInstance()));
        try {
            XsltCompiler xsltComp = this.xsltProc.newXsltCompiler();
            xsltComp.setURIResolver((URIResolver)new XsltResolver(LocationMapper.get(), new HashMap(), LinkedDataClient.create((Client)client, (com.atomgraph.core.MediaTypes)mediaTypes), false, false, true));
            this.xsltExec = xsltComp.compile(stylesheet);
        }
        catch (SaxonApiException ex) {
            if (log.isErrorEnabled()) {
                log.error("System XSLT stylesheet error: {}", (Throwable)ex);
            }
            throw new WebApplicationException((Throwable)ex);
        }
    }

    @PostConstruct
    public void init() {
        this.register(ProxyResourceBase.class);
        this.register((Object)new HttpMethodOverrideFilter(new HttpMethodOverrideFilter.Source[0]));
        this.register((Object)new ModelProvider());
        this.register((Object)new ResultSetProvider());
        this.register((Object)new QueryParamProvider());
        this.register((Object)new UpdateRequestProvider());
        this.register(NotFoundExceptionMapper.class);
        this.register(RiotExceptionMapper.class);
        this.register(ClientErrorExceptionMapper.class);
        this.register(BadGatewayExceptionMapper.class);
        this.register((Object)new ModelXSLTWriter(this.getXsltExecutable(), this.getOntModelSpec(), this.getDataManager()));
        this.register((Object)new ResultSetXSLTWriter(this.getXsltExecutable(), this.getOntModelSpec(), this.getDataManager()));
        this.register((Object)new /* Unavailable Anonymous Inner Class!! */);
        this.register((Object)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static Source getSource(ServletContext servletContext, String path) throws URISyntaxException, IOException {
        URL xsltUrl;
        if (servletContext == null) {
            throw new IllegalArgumentException("servletContext name cannot be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("XML file name cannot be null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Resource paths used to load Source: {} from filename: {}", (Object)servletContext.getResourcePaths("/"), (Object)path);
        }
        if ((xsltUrl = servletContext.getResource(path)) == null) {
            throw new FileNotFoundException("File '" + path + "' not found");
        }
        String xsltUri = xsltUrl.toURI().toString();
        if (log.isDebugEnabled()) {
            log.debug("XSLT stylesheet URI: {}", (Object)xsltUri);
        }
        return new StreamSource(xsltUri);
    }

    public static Client getClient(ClientConfig clientConfig) {
        clientConfig.property("jersey.config.client.followRedirects", (Object)Boolean.TRUE);
        clientConfig.register((Object)new ModelProvider());
        clientConfig.register((Object)new DatasetProvider());
        clientConfig.register((Object)new ResultSetProvider());
        clientConfig.register((Object)new QueryProvider());
        clientConfig.register((Object)new UpdateRequestProvider());
        Client client = ClientBuilder.newClient((Configuration)clientConfig);
        return client;
    }

    public static DataManager getDataManager(LocationMapper mapper, Client client, MediaTypes mediaTypes, boolean cacheModelLoads, boolean preemptiveAuth, boolean resolvingUncached) {
        return new DataManagerImpl(mapper, new HashMap(), LinkedDataClient.create((Client)client, (com.atomgraph.core.MediaTypes)mediaTypes), cacheModelLoads, preemptiveAuth, resolvingUncached);
    }

    public MediaTypes getMediaTypes() {
        return this.mediaTypes;
    }

    public Client getClient() {
        return this.client;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public Source getStylesheet() {
        return this.stylesheet;
    }

    public Boolean isCacheStylesheet() {
        return this.cacheStylesheet;
    }

    public OntModelSpec getOntModelSpec() {
        return this.ontModelSpec;
    }

    public XsltExecutable getXsltExecutable() {
        return this.xsltExec;
    }
}

