/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.client.writer.function;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.ExtensionFunction;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.OccurrenceIndicator;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SequenceType;
import net.sf.saxon.s9api.XdmValue;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.RDFLanguages;

public class Construct
implements ExtensionFunction {
    private final Processor processor;

    public Construct(Processor processor) {
        this.processor = processor;
    }

    public QName getName() {
        return new QName("https://w3id.org/atomgraph/client#", "construct");
    }

    public SequenceType getResultType() {
        return SequenceType.makeSequenceType((ItemType)ItemType.DOCUMENT_NODE, (OccurrenceIndicator)OccurrenceIndicator.ZERO_OR_MORE);
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.makeSequenceType((ItemType)ItemType.STRING, (OccurrenceIndicator)OccurrenceIndicator.ONE)};
    }

    public XdmValue call(XdmValue[] arguments) throws SaxonApiException {
        try {
            return this.getProcessor().newDocumentBuilder().build((Source)this.getSource(this.getConstructedInstances(QueryFactory.create((String)arguments[0].itemAt(0).getStringValue()))));
        }
        catch (IOException | URISyntaxException ex) {
            throw new SaxonApiException((Throwable)ex);
        }
    }

    public Model getConstructedInstances(Query constructor) throws URISyntaxException, IOException {
        try (QueryExecution qex = QueryExecution.create().query(constructor).build();){
            Model model = qex.execConstruct();
            return model;
        }
    }

    public StreamSource getSource(Model model) throws IOException {
        if (model == null) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            model.write((OutputStream)stream, RDFLanguages.RDFXML.getName(), null);
            StreamSource streamSource = new StreamSource(new ByteArrayInputStream(stream.toByteArray()));
            return streamSource;
        }
    }

    public Processor getProcessor() {
        return this.processor;
    }
}

