/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.client.locator;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.JenaException;
import org.apache.jena.util.FileManager;
import org.apache.jena.util.FileUtils;
import org.apache.jena.util.LocationMapper;
import org.apache.jena.vocabulary.LocationMappingVocab;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixMapper
extends LocationMapper {
    private static final Logger log = LoggerFactory.getLogger(PrefixMapper.class);
    private final Map<String, String> altPrefixLocations = new HashMap();

    public PrefixMapper() {
        if (log.isDebugEnabled()) {
            log.debug("PrefixMapper()");
        }
    }

    public PrefixMapper(String config) {
        this.initFromPath(config, true);
    }

    public PrefixMapper(LocationMapper locMapper) {
        super(locMapper);
    }

    public PrefixMapper(PrefixMapper prefixMapper) {
        super((LocationMapper)prefixMapper);
        this.altPrefixLocations.putAll(prefixMapper.altPrefixLocations);
    }

    public void addAltPrefixEntry(String uriPrefix, String alt) {
        if (log.isDebugEnabled()) {
            log.debug("PrefixMapper.addAltPrefixEntry({}, {})", (Object)uriPrefix, (Object)alt);
        }
        this.altPrefixLocations.put(uriPrefix, alt);
    }

    public String getPrefixAltEntry(String uriPrefix) {
        return (String)this.altPrefixLocations.get(uriPrefix);
    }

    public Iterator<String> listAltPrefixEntries() {
        return this.altPrefixLocations.keySet().iterator();
    }

    public String getPrefix(String uri) {
        String prefix = null;
        Iterator iter = this.listAltPrefixEntries();
        while (iter.hasNext()) {
            String candPrefix = (String)iter.next();
            if (!uri.startsWith(candPrefix) || prefix != null && candPrefix.length() <= prefix.length()) continue;
            prefix = candPrefix;
        }
        return prefix;
    }

    public String altMapping(String uri, String otherwise) {
        String altEntry;
        if (log.isDebugEnabled()) {
            log.debug("PrefixMapper.altMapping({}, {})", (Object)uri, (Object)otherwise);
        }
        if ((altEntry = this.getAltEntry(uri)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Returning existing altName mapping: {} for URI: {}", (Object)altEntry, (Object)uri);
            }
            return altEntry;
        }
        String prefix = this.getPrefix(uri);
        String prefixAltEntry = this.getPrefixAltEntry(prefix);
        if (prefix != null && prefixAltEntry != null) {
            if (log.isDebugEnabled()) {
                log.debug("Returning existing altName mapping: {} for prefix: {}", (Object)prefixAltEntry, (Object)prefix);
            }
            return this.getPrefixAltEntry(prefix);
        }
        return super.altMapping(uri, otherwise);
    }

    public void toModel(Model model) {
        String v;
        String k;
        Resource e;
        Resource r;
        Iterator iter = this.listAltEntries();
        while (iter.hasNext()) {
            r = model.createResource();
            e = model.createResource();
            model.add(r, LocationMappingVocab.mapping, (RDFNode)e);
            k = (String)iter.next();
            v = this.getAltEntry(k);
            model.add(e, LocationMappingVocab.name, k);
            model.add(e, LocationMappingVocab.altName, v);
        }
        iter = this.listAltPrefixes();
        while (iter.hasNext()) {
            r = model.createResource();
            e = model.createResource();
            model.add(r, LocationMappingVocab.mapping, (RDFNode)e);
            k = (String)iter.next();
            v = this.getAltPrefix(k);
            model.add(e, LocationMappingVocab.prefix, k);
            model.add(e, LocationMappingVocab.altPrefix, v);
        }
        iter = this.listAltPrefixEntries();
        while (iter.hasNext()) {
            r = model.createResource();
            e = model.createResource();
            model.add(r, LocationMappingVocab.mapping, (RDFNode)e);
            k = (String)iter.next();
            v = this.getPrefixAltEntry(k);
            model.add(e, LocationMappingVocab.prefix, k);
            model.add(e, LocationMappingVocab.altName, v);
        }
    }

    public void processConfig(Model m) {
        StmtIterator mappings = m.listStatements(null, LocationMappingVocab.mapping, (RDFNode)null);
        while (mappings.hasNext()) {
            String altName;
            Statement s = mappings.nextStatement();
            Resource mapping = s.getResource();
            if (mapping.hasProperty(LocationMappingVocab.name)) {
                try {
                    String name = mapping.getRequiredProperty(LocationMappingVocab.name).getString();
                    altName = mapping.getRequiredProperty(LocationMappingVocab.altName).getString();
                    this.addAltEntry(name, altName);
                    if (log.isDebugEnabled()) {
                        log.debug("Mapping: " + name + " => " + altName);
                    }
                }
                catch (JenaException ex) {
                    if (log.isWarnEnabled()) {
                        log.warn("Error processing name mapping: " + ex.getMessage());
                    }
                    return;
                }
            }
            if (!mapping.hasProperty(LocationMappingVocab.prefix)) continue;
            try {
                String prefix = mapping.getRequiredProperty(LocationMappingVocab.prefix).getString();
                if (mapping.hasProperty(LocationMappingVocab.altPrefix)) {
                    String altPrefix = mapping.getRequiredProperty(LocationMappingVocab.altPrefix).getString();
                    this.addAltPrefix(prefix, altPrefix);
                    if (log.isDebugEnabled()) {
                        log.debug("Prefix mapping: " + prefix + " => " + altPrefix);
                    }
                }
                if (!mapping.hasProperty(LocationMappingVocab.altName)) continue;
                altName = mapping.getRequiredProperty(LocationMappingVocab.altName).getString();
                this.addAltPrefixEntry(prefix, altName);
                log.debug("Prefix/name mapping: " + prefix + " => " + altName);
            }
            catch (JenaException ex) {
                if (log.isWarnEnabled()) {
                    log.warn("Error processing prefix mapping: " + ex.getMessage());
                }
                return;
            }
        }
    }

    private void initFromPath(String configPath, boolean configMustExist) {
        if (configPath == null || configPath.length() == 0) {
            if (log.isWarnEnabled()) {
                log.warn("Null configuration");
            }
            return;
        }
        FileManager fm = FileManager.create();
        fm.addLocatorFile();
        fm.addLocatorClassLoader(fm.getClass().getClassLoader());
        try {
            String uri;
            String uriConfig = null;
            InputStream in = null;
            StringTokenizer pathElems = new StringTokenizer(configPath, ";");
            while (pathElems.hasMoreTokens() && (uri = pathElems.nextToken()) != null && uri.length() != 0) {
                in = fm.openNoMap(uri);
                if (in == null) continue;
                uriConfig = uri;
                break;
            }
            if (in == null) {
                if (!configMustExist && log.isDebugEnabled()) {
                    log.debug("Failed to find configuration: " + configPath);
                }
                return;
            }
            String syntax = FileUtils.guessLang(uriConfig);
            Model model = ModelFactory.createDefaultModel();
            model.read(in, uriConfig, syntax);
            this.processConfig(model);
            in.close();
        }
        catch (JenaException ex) {
            LoggerFactory.getLogger(LocationMapper.class).warn("Error in configuration file: " + ex.getMessage());
        }
        catch (IOException ex) {
            LoggerFactory.getLogger(LocationMapper.class).warn("Error reading configuration: " + ex.getMessage());
        }
    }

    public String toString() {
        Object s = super.toString();
        Iterator iter = this.listAltPrefixEntries();
        while (iter.hasNext()) {
            String k = (String)iter.next();
            String v = this.getPrefixAltEntry(k);
            s = (String)s + "(Prefix:" + k + "=>" + v + ") ";
        }
        return s;
    }
}

