/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.client.model.impl;

import com.atomgraph.client.MediaTypes;
import com.atomgraph.core.MediaType;
import com.atomgraph.core.exception.BadGatewayException;
import com.atomgraph.core.io.ResultSetProvider;
import com.atomgraph.core.model.Resource;
import com.atomgraph.core.util.ModelUtils;
import com.atomgraph.core.util.ResultSetUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.QueryParam;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class ProxyResourceBase
implements Resource {
    private static final Logger log = LoggerFactory.getLogger(ProxyResourceBase.class);
    private final Request request;
    private final HttpHeaders httpHeaders;
    private final MediaTypes mediaTypes;
    private final javax.ws.rs.core.MediaType accept;
    private final javax.ws.rs.core.MediaType[] readableMediaTypes;
    private final Client client;
    private final WebTarget webTarget;
    private final HttpServletRequest httpServletRequest;

    @Inject
    public ProxyResourceBase(@Context UriInfo uriInfo, @Context Request request, @Context HttpHeaders httpHeaders, MediaTypes mediaTypes, @QueryParam(value="uri") URI uri, @QueryParam(value="endpoint") URI endpoint, @QueryParam(value="accept") javax.ws.rs.core.MediaType accept, @QueryParam(value="mode") URI mode, Client client, @Context HttpServletRequest httpServletRequest) {
        this.request = request;
        this.httpHeaders = httpHeaders;
        this.mediaTypes = mediaTypes;
        this.accept = accept;
        this.client = client;
        ArrayList readableMediaTypesList = new ArrayList();
        readableMediaTypesList.addAll(mediaTypes.getReadable(Model.class));
        this.readableMediaTypes = (javax.ws.rs.core.MediaType[])readableMediaTypesList.toArray(javax.ws.rs.core.MediaType[]::new);
        if (uri != null) {
            if (uri.getFragment() != null) {
                try {
                    uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), uri.getQuery(), null);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            this.webTarget = client.target(uri);
        } else {
            this.webTarget = null;
        }
        this.httpServletRequest = httpServletRequest;
    }

    public URI getURI() {
        return this.getWebTarget().getUri();
    }

    public javax.ws.rs.core.MediaType[] getReadableMediaTypes() {
        return this.readableMediaTypes;
    }

    public List<javax.ws.rs.core.MediaType> getWritableMediaTypes(Class clazz) {
        if (this.getAcceptMediaType() != null) {
            return Arrays.asList(this.getAcceptMediaType());
        }
        return this.getMediaTypes().getWritable(clazz);
    }

    @GET
    public Response get() {
        return this.get(this.getWebTarget());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response get(WebTarget target) {
        if (target == null) {
            throw new NotFoundException("Resource URI not supplied");
        }
        try (Response cr = target.request(this.getReadableMediaTypes()).get();){
            if ((cr.getStatusInfo().toEnum().equals((Object)Response.Status.SEE_OTHER) || cr.getStatusInfo().toEnum().equals((Object)Response.Status.MOVED_PERMANENTLY)) && (target.getUri().getScheme().equals("http") && cr.getLocation().getScheme().equals("https") || target.getUri().getScheme().equals("https") && cr.getLocation().getScheme().equals("http"))) {
                Response response2 = this.get(this.getClient().target(cr.getLocation()));
                return response2;
            }
            cr.getHeaders().putSingle((Object)"X-Request-URI", (Object)this.webTarget.getUri().toString());
            if (log.isDebugEnabled()) {
                log.debug("GETing Model from URI: {}", (Object)this.webTarget.getUri());
            }
            Response response3 = this.getResponse(cr);
            List linkValues = (List)cr.getHeaders().get((Object)"Link");
            if (linkValues != null) {
                this.setLinks(linkValues, response3);
            }
            Response response = response3;
            return response;
        }
        catch (ProcessingException ex) {
            if (!log.isErrorEnabled()) throw new BadGatewayException((Throwable)ex);
            log.debug("Could not dereference URI: {}", (Object)this.webTarget.getUri());
            throw new BadGatewayException((Throwable)ex);
        }
    }

    public Response getResponse(Response clientResponse) {
        if (ResultSetProvider.isResultSetType((javax.ws.rs.core.MediaType)clientResponse.getMediaType())) {
            ResultSetRewindable results = (ResultSetRewindable)clientResponse.readEntity(ResultSetRewindable.class);
            return this.getResponse(results);
        }
        Model description = (Model)clientResponse.readEntity(Model.class);
        return this.getResponse(description);
    }

    public Response getResponse(Model model) {
        List variants = com.atomgraph.core.model.impl.Response.getVariantListBuilder((List)this.getWritableMediaTypes(Model.class), (List)this.getLanguages(), (List)this.getEncodings()).add().build();
        return new com.atomgraph.core.model.impl.Response(this.getRequest(), (Object)model, null, new EntityTag(Long.toHexString(ModelUtils.hashModel((Model)model))), variants).getResponseBuilder().build();
    }

    public Response getResponse(ResultSetRewindable resultSet) {
        long hash = ResultSetUtils.hashResultSet((ResultSet)resultSet);
        resultSet.reset();
        List variants = com.atomgraph.core.model.impl.Response.getVariantListBuilder((List)this.getWritableMediaTypes(ResultSet.class), (List)this.getLanguages(), (List)this.getEncodings()).add().build();
        return new com.atomgraph.core.model.impl.Response(this.getRequest(), (Object)resultSet, null, new EntityTag(Long.toHexString(hash)), variants).getResponseBuilder().build();
    }

    protected Response setLinks(List<Object> linkValues, Response response) {
        linkValues.forEach(linkValue -> response.getHeaders().add((Object)"Link", linkValue));
        return response;
    }

    @POST
    public Response post(Model model) {
        if (this.getWebTarget() == null) {
            throw new NotFoundException("Resource URI not supplied");
        }
        if (log.isDebugEnabled()) {
            log.debug("POSTing Dataset to URI: {}", (Object)this.getWebTarget().getUri());
        }
        return this.getWebTarget().request().accept((javax.ws.rs.core.MediaType[])this.getMediaTypes().getReadable(Model.class).toArray(javax.ws.rs.core.MediaType[]::new)).post(Entity.entity((Object)model, (javax.ws.rs.core.MediaType)MediaType.APPLICATION_NTRIPLES_TYPE));
    }

    @PUT
    public Response put(Model model) {
        if (this.getWebTarget() == null) {
            throw new NotFoundException("Resource URI not supplied");
        }
        if (log.isDebugEnabled()) {
            log.debug("PUTting Dataset to URI: {}", (Object)this.getWebTarget().getUri());
        }
        return this.getWebTarget().request().accept((javax.ws.rs.core.MediaType[])this.getMediaTypes().getReadable(Model.class).toArray(javax.ws.rs.core.MediaType[]::new)).put(Entity.entity((Object)model, (javax.ws.rs.core.MediaType)MediaType.APPLICATION_NTRIPLES_TYPE));
    }

    @DELETE
    public Response delete() {
        if (this.getWebTarget() == null) {
            throw new NotFoundException("Resource URI not supplied");
        }
        if (log.isDebugEnabled()) {
            log.debug("DELETEing Dataset from URI: {}", (Object)this.getWebTarget().getUri());
        }
        return (Response)this.getWebTarget().request().accept((javax.ws.rs.core.MediaType[])this.getMediaTypes().getReadable(Model.class).toArray(javax.ws.rs.core.MediaType[]::new)).delete(Response.class);
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public javax.ws.rs.core.MediaType getAcceptMediaType() {
        return this.accept;
    }

    public Client getClient() {
        return this.client;
    }

    public final WebTarget getWebTarget() {
        return this.webTarget;
    }

    public Request getRequest() {
        return this.request;
    }

    public MediaTypes getMediaTypes() {
        return this.mediaTypes;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public List<Locale> getLanguages() {
        return new ArrayList<Locale>();
    }

    public List<String> getEncodings() {
        return new ArrayList<String>();
    }
}

