/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.client.util;

import com.atomgraph.client.util.DataManager;
import com.atomgraph.core.MediaType;
import com.atomgraph.core.client.LinkedDataClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.trans.XPathException;
import org.apache.commons.io.IOUtils;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.util.LocationMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataManagerImpl
extends com.atomgraph.core.util.jena.DataManagerImpl
implements DataManager {
    private static final Logger log = LoggerFactory.getLogger(DataManagerImpl.class);
    private final javax.ws.rs.core.MediaType[] acceptedTypes;
    private final javax.ws.rs.core.MediaType[] acceptedXMLMediaTypes;
    private final boolean resolvingUncached;
    private final boolean resolvingMapped = true;

    public DataManagerImpl(LocationMapper mapper, Map<String, Model> modelCache, LinkedDataClient ldc, boolean cacheModelLoads, boolean preemptiveAuth, boolean resolvingUncached) {
        super(mapper, modelCache, ldc, cacheModelLoads, preemptiveAuth);
        this.resolvingUncached = resolvingUncached;
        ArrayList acceptedTypeList = new ArrayList();
        acceptedTypeList.addAll(ldc.getMediaTypes().getReadable(Model.class));
        acceptedTypeList.addAll(ldc.getMediaTypes().getReadable(ResultSet.class));
        this.acceptedTypes = (javax.ws.rs.core.MediaType[])acceptedTypeList.toArray(javax.ws.rs.core.MediaType[]::new);
        ArrayList<javax.ws.rs.core.MediaType> acceptableXMLMediaTypeList = new ArrayList<javax.ws.rs.core.MediaType>();
        HashMap<String, String> q1 = new HashMap<String, String>();
        q1.put("q", "1.0");
        acceptableXMLMediaTypeList.add(new javax.ws.rs.core.MediaType(MediaType.APPLICATION_SPARQL_RESULTS_XML_TYPE.getType(), MediaType.APPLICATION_SPARQL_RESULTS_XML_TYPE.getSubtype(), q1));
        HashMap<String, String> q09 = new HashMap<String, String>();
        q09.put("q", "0.9");
        acceptableXMLMediaTypeList.add(new javax.ws.rs.core.MediaType(MediaType.APPLICATION_RDF_XML_TYPE.getType(), MediaType.APPLICATION_RDF_XML_TYPE.getSubtype(), q09));
        HashMap<String, String> q05 = new HashMap<String, String>();
        q05.put("q", "0.5");
        acceptableXMLMediaTypeList.add(new javax.ws.rs.core.MediaType(javax.ws.rs.core.MediaType.APPLICATION_XML_TYPE.getType(), javax.ws.rs.core.MediaType.APPLICATION_XML_TYPE.getSubtype(), q05));
        HashMap<String, String> q04 = new HashMap<String, String>();
        q04.put("q", "0.4");
        acceptableXMLMediaTypeList.add(new javax.ws.rs.core.MediaType(javax.ws.rs.core.MediaType.TEXT_XML_TYPE.getType(), javax.ws.rs.core.MediaType.TEXT_XML_TYPE.getSubtype(), q04));
        this.acceptedXMLMediaTypes = (javax.ws.rs.core.MediaType[])acceptableXMLMediaTypeList.toArray(javax.ws.rs.core.MediaType[]::new);
    }

    public Response load(String filenameOrURI) {
        return this.get(filenameOrURI, this.getAcceptedMediaTypes());
    }

    public boolean isMapped(String filenameOrURI) {
        String mappedURI = this.mapURI(filenameOrURI);
        return !mappedURI.equals(filenameOrURI) && !mappedURI.startsWith("http:");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Source resolve(String href, String base) throws TransformerException {
        URI uri;
        URI baseURI = URI.create(base);
        URI uRI = uri = href.isEmpty() ? baseURI : baseURI.resolve(href);
        if (this.hasCachedModel(uri.toString()) || this.isResolvingMapped() && this.isMapped(uri.toString())) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace("hasCachedModel({}): {}", (Object)uri, (Object)this.hasCachedModel(uri.toString()));
                }
                if (log.isTraceEnabled()) {
                    log.trace("isMapped({}): {}", (Object)uri, (Object)this.isMapped(uri.toString()));
                }
                return this.getSource(this.loadModel(uri.toString()), uri.toString());
            }
            catch (IOException ex) {
                if (log.isWarnEnabled()) {
                    log.warn("Could not read Model from mapped URI: {}", (Object)uri);
                }
                throw new TransformerException(ex);
            }
        }
        if (uri.getScheme().equals("http") || uri.getScheme().equals("https")) {
            if (log.isDebugEnabled()) {
                log.debug("Resolving URI: {} against base URI: {}", (Object)href, (Object)base);
            }
            try {
                if (!this.resolvingUncached(uri.toString())) {
                    if (log.isDebugEnabled()) {
                        log.debug("Dereferencing uncached URIs is disabled - returning empty document for URI: {}", (Object)uri);
                    }
                    return this.getSource(ModelFactory.createDefaultModel(), uri.toString());
                }
                try (Response cr = this.get(uri.toString(), this.getAcceptedXMLMediaTypes());){
                    StreamSource streamSource;
                    block27: {
                        if (!cr.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                            throw new IOException("XML document could not be successfully loaded over HTTP. Status code: " + cr.getStatus());
                        }
                        if (!this.isAcceptedMediaType(cr.getMediaType(), this.getAcceptedXMLMediaTypes())) {
                            throw new IOException("MediaType '" + cr.getMediaType() + "' is not accepted");
                        }
                        InputStream is = (InputStream)cr.readEntity(InputStream.class);
                        try {
                            byte[] bytes = IOUtils.toByteArray((InputStream)is);
                            streamSource = new StreamSource(new ByteArrayInputStream(bytes), uri.toString());
                            if (is == null) break block27;
                        }
                        catch (Throwable throwable) {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        is.close();
                    }
                    return streamSource;
                }
            }
            catch (IOException ex) {
                if (log.isWarnEnabled()) {
                    log.warn("Could not read XML document from URI: {}", (Object)uri);
                }
                throw new TransformerException(ex);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Reader resolve(URI uri, String encoding, Configuration config) throws XPathException {
        try (Response cr = this.getLinkedDataClient().getClient().target(uri).request().get();){
            InputStreamReader inputStreamReader;
            block19: {
                byte[] bytes;
                InputStream is;
                block17: {
                    InputStreamReader inputStreamReader2;
                    block18: {
                        if (!cr.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                            throw new IOException("Unparsed text could not be successfully loaded over HTTP");
                        }
                        is = (InputStream)cr.readEntity(InputStream.class);
                        try {
                            bytes = IOUtils.toByteArray((InputStream)is);
                            if (cr.getMediaType() == null || !cr.getMediaType().getParameters().containsKey("charset")) break block17;
                            inputStreamReader2 = new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), (String)cr.getMediaType().getParameters().get("charset"));
                            if (is == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        is.close();
                    }
                    return inputStreamReader2;
                }
                inputStreamReader = new InputStreamReader(new ByteArrayInputStream(bytes));
                if (is == null) break block19;
                is.close();
            }
            return inputStreamReader;
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public Source getSource(Model model, String systemId) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("Number of Model stmts read: {}", (Object)model.size());
        }
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            model.write((OutputStream)stream);
            if (log.isTraceEnabled()) {
                log.trace("RDF/XML bytes written: {}", (Object)stream.toByteArray().length);
            }
            StreamSource streamSource = new StreamSource(new ByteArrayInputStream(stream.toByteArray()), systemId);
            return streamSource;
        }
    }

    public Source getSource(ResultSet results, String systemId) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("ResultVars: {}", (Object)results.getResultVars());
        }
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            ResultSetFormatter.outputAsXML((OutputStream)stream, (ResultSet)results);
            if (log.isDebugEnabled()) {
                log.debug("SPARQL XML result bytes written: {}", (Object)stream.toByteArray().length);
            }
            StreamSource streamSource = new StreamSource(new ByteArrayInputStream(stream.toByteArray()), systemId);
            return streamSource;
        }
    }

    public boolean isAcceptedMediaType(javax.ws.rs.core.MediaType mediaType, javax.ws.rs.core.MediaType[] mediaTypes) {
        for (javax.ws.rs.core.MediaType accepted : mediaTypes) {
            if (!accepted.isCompatible(mediaType)) continue;
            return true;
        }
        return false;
    }

    public javax.ws.rs.core.MediaType[] getAcceptedMediaTypes() {
        return this.acceptedTypes;
    }

    public boolean resolvingUncached(String filenameOrURI) {
        return this.resolvingUncached;
    }

    public boolean isResolvingMapped() {
        return true;
    }

    public javax.ws.rs.core.MediaType[] getAcceptedXMLMediaTypes() {
        return this.acceptedXMLMediaTypes;
    }
}

