/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.client.util;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@Deprecated
public class XSLTBuilder {
    private static final Logger log = LoggerFactory.getLogger(XSLTBuilder.class);
    private final SAXTransformerFactory factory;
    private final Map<String, Object> parameters = new HashMap();
    private final Map<String, String> outputProperties = new HashMap();
    private Templates templates = null;
    private URIResolver uriResolver = null;
    private Source source = null;
    private Result result = null;

    protected XSLTBuilder(SAXTransformerFactory factory) {
        if (factory == null) {
            throw new IllegalStateException("SAXTransformerFactory cannot be null");
        }
        this.factory = factory;
    }

    public static XSLTBuilder newInstance(SAXTransformerFactory factory) {
        return new XSLTBuilder(factory);
    }

    public XSLTBuilder document(Source doc) {
        if (log.isTraceEnabled()) {
            log.trace("Loading document Source with system ID: {}", (Object)doc.getSystemId());
        }
        this.source = doc;
        return this;
    }

    public XSLTBuilder document(Node n) {
        this.document((Source)new DOMSource(n));
        return this;
    }

    public XSLTBuilder document(Node n, String systemId) {
        this.document((Source)new DOMSource(n, systemId));
        return this;
    }

    public XSLTBuilder document(File file) {
        this.document((Source)new StreamSource(file));
        return this;
    }

    public XSLTBuilder document(InputStream is) {
        this.document((Source)new StreamSource(is));
        return this;
    }

    public XSLTBuilder document(InputStream is, String systemId) {
        this.document((Source)new StreamSource(is, systemId));
        return this;
    }

    public XSLTBuilder document(Reader reader) {
        this.document((Source)new StreamSource(reader));
        return this;
    }

    public XSLTBuilder document(Reader reader, String systemId) {
        this.document((Source)new StreamSource(reader, systemId));
        return this;
    }

    public XSLTBuilder document(String systemId) {
        this.document((Source)new StreamSource(systemId));
        return this;
    }

    public XSLTBuilder stylesheet(File stylesheet) throws TransformerConfigurationException {
        return this.stylesheet((Source)new StreamSource(stylesheet));
    }

    public XSLTBuilder stylesheet(Source stylesheet) throws TransformerConfigurationException {
        return this.stylesheet(this.factory.newTemplates(stylesheet));
    }

    public XSLTBuilder stylesheet(Templates templates) throws TransformerConfigurationException {
        this.templates = templates;
        return this;
    }

    public XSLTBuilder parameter(String name, Object value) {
        if (log.isTraceEnabled()) {
            log.trace("Setting transformer parameter {} with value {}", (Object)name, value);
        }
        this.parameters.put(name, value);
        return this;
    }

    public XSLTBuilder resolver(URIResolver uriResolver) {
        if (log.isTraceEnabled()) {
            log.trace("Setting URIResolver: {}", (Object)uriResolver);
        }
        this.uriResolver = uriResolver;
        return this;
    }

    public XSLTBuilder outputProperty(String name, String value) {
        if (log.isTraceEnabled()) {
            log.trace("Setting transformer OutputProperty {} with value {}", (Object)name, (Object)value);
        }
        this.outputProperties.put(name, value);
        return this;
    }

    protected Transformer getTransformer(Templates templates, Result result, URIResolver uriResolver, Map<String, Object> parameters, Map<String, String> outputProperties) throws TransformerConfigurationException {
        TransformerHandler handler = this.getSAXTransformerFactory().newTransformerHandler(templates);
        handler.setResult(result);
        Transformer transformer = handler.getTransformer();
        transformer.setURIResolver(uriResolver);
        for (Map.Entry<String, Object> param : parameters.entrySet()) {
            transformer.setParameter(param.getKey(), param.getValue());
        }
        for (Map.Entry<String, String> outputProperty : outputProperties.entrySet()) {
            transformer.setOutputProperty(outputProperty.getKey(), outputProperty.getValue());
        }
        return transformer;
    }

    protected Transformer getTransformer() throws TransformerConfigurationException {
        return this.getTransformer(this.getTemplates(), this.getResult(), this.getURIResolver(), this.getParameters(), this.getOutputProperties());
    }

    public void transform() throws TransformerException {
        this.getTransformer().transform(this.getSource(), this.getResult());
    }

    public XSLTBuilder result(Result result) throws TransformerConfigurationException {
        this.result = result;
        return this;
    }

    protected SAXTransformerFactory getSAXTransformerFactory() {
        return this.factory;
    }

    protected Templates getTemplates() {
        return this.templates;
    }

    protected Result getResult() {
        return this.result;
    }

    protected URIResolver getURIResolver() {
        return this.uriResolver;
    }

    protected Map<String, Object> getParameters() {
        return this.parameters;
    }

    protected Map<String, String> getOutputProperties() {
        return this.outputProperties;
    }

    protected Source getSource() {
        return this.source;
    }
}

