/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.client.writer;

import com.atomgraph.client.util.DataManager;
import com.atomgraph.client.vocabulary.AC;
import com.atomgraph.client.vocabulary.LDT;
import com.atomgraph.core.util.Link;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.value.DateTimeValue;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.ontology.ObjectProperty;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdfxml.xmloutput.impl.Basic;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.system.Checker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModelXSLTWriterBase {
    private static final Logger log = LoggerFactory.getLogger(ModelXSLTWriterBase.class);
    private static final Set<String> NAMESPACES = new HashSet();
    private final XsltExecutable xsltExec;
    private final OntModelSpec ontModelSpec;
    private final DataManager dataManager;
    @Context
    private UriInfo uriInfo;
    @Context
    private Request request;
    @Context
    private HttpHeaders httpHeaders;
    @Context
    private HttpServletRequest httpServletRequest;

    public ModelXSLTWriterBase(XsltExecutable xsltExec, OntModelSpec ontModelSpec, DataManager dataManager) {
        if (xsltExec == null) {
            throw new IllegalArgumentException("XsltExecutable cannot be null");
        }
        if (ontModelSpec == null) {
            throw new IllegalArgumentException("OntModelSpec cannot be null");
        }
        if (dataManager == null) {
            throw new IllegalArgumentException("DataManager cannot be null");
        }
        this.xsltExec = xsltExec;
        this.ontModelSpec = ontModelSpec;
        this.dataManager = dataManager;
    }

    public void writeTo(Model model, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headerMap, OutputStream entityStream) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("Writing Model with HTTP headers: {} MediaType: {}", headerMap, (Object)mediaType);
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Basic writer = new Basic();
            writer.setProperty("allowBadURIs", (Object)true);
            writer.write(model, (OutputStream)baos, null);
            Xslt30Transformer xsltTrans = this.getXsltExecutable().load30();
            Serializer out = xsltTrans.newSerializer();
            out.setOutputStream(entityStream);
            out.setOutputProperty(Serializer.Property.ENCODING, StandardCharsets.UTF_8.name());
            if (mediaType.isCompatible(MediaType.TEXT_HTML_TYPE)) {
                out.setOutputProperty(Serializer.Property.METHOD, "html");
                out.setOutputProperty(Serializer.Property.MEDIA_TYPE, "text/html");
                out.setOutputProperty(Serializer.Property.DOCTYPE_SYSTEM, "http://www.w3.org/TR/html4/strict.dtd");
                out.setOutputProperty(Serializer.Property.DOCTYPE_PUBLIC, "-//W3C//DTD HTML 4.01//EN");
            }
            if (mediaType.isCompatible(MediaType.APPLICATION_XHTML_XML_TYPE)) {
                out.setOutputProperty(Serializer.Property.METHOD, "xhtml");
                out.setOutputProperty(Serializer.Property.MEDIA_TYPE, "application/xhtml+xml");
                out.setOutputProperty(Serializer.Property.DOCTYPE_SYSTEM, "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd");
                out.setOutputProperty(Serializer.Property.DOCTYPE_PUBLIC, "-//W3C//DTD XHTML 1.0 Strict//EN");
            }
            xsltTrans.setURIResolver((URIResolver)this.getDataManager());
            xsltTrans.getUnderlyingController().setUnparsedTextURIResolver((UnparsedTextURIResolver)this.getDataManager());
            xsltTrans.getUnderlyingController().setCurrentDateTime(DateTimeValue.fromZonedDateTime((ZonedDateTime)ZonedDateTime.now()));
            xsltTrans.setStylesheetParameters(this.getParameters(headerMap));
            xsltTrans.transform((Source)new StreamSource(new ByteArrayInputStream(baos.toByteArray())), (Destination)out);
        }
        catch (TransformerException | SaxonApiException ex) {
            if (log.isErrorEnabled()) {
                log.error("XSLT transformation failed", ex);
            }
            throw new WebApplicationException(ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public <T extends XdmValue> Map<QName, XdmValue> getParameters(MultivaluedMap<String, Object> headerMap) throws TransformerException {
        if (headerMap == null) {
            throw new IllegalArgumentException("MultivaluedMap cannot be null");
        }
        HashMap<QName, XdmValue> params = new HashMap<QName, XdmValue>();
        params.put(new QName("ac", AC.httpHeaders.getNameSpace(), AC.httpHeaders.getLocalName()), (XdmValue)new XdmAtomicValue(headerMap.toString()));
        params.put(new QName("ac", AC.method.getNameSpace(), AC.method.getLocalName()), (XdmValue)new XdmAtomicValue(this.getRequest().getMethod()));
        params.put(new QName("ac", AC.contextUri.getNameSpace(), AC.contextUri.getLocalName()), (XdmValue)new XdmAtomicValue(this.getContextURI()));
        try {
            Locale locale;
            String forClassURI;
            URI baseURI;
            URI ontologyURI;
            List modes;
            if (this.getURI() != null) {
                params.put(new QName("ac", AC.uri.getNameSpace(), AC.uri.getLocalName()), (XdmValue)new XdmAtomicValue(this.getURI()));
            }
            if (this.getEndpointURI() != null) {
                params.put(new QName("ac", AC.endpoint.getNameSpace(), AC.endpoint.getLocalName()), (XdmValue)new XdmAtomicValue(this.getEndpointURI()));
            }
            if (this.getQuery() != null) {
                params.put(new QName("ac", AC.query.getNameSpace(), AC.query.getLocalName()), (XdmValue)new XdmAtomicValue(this.getQuery()));
            }
            if (!(modes = this.getModes(this.getSupportedNamespaces())).isEmpty()) {
                params.put(new QName("ac", AC.mode.getNameSpace(), AC.mode.getLocalName()), XdmValue.makeSequence((Iterable)modes));
            }
            if ((ontologyURI = this.getLinkURI(headerMap, LDT.ontology)) != null) {
                params.put(new QName("ldt", LDT.ontology.getNameSpace(), LDT.ontology.getLocalName()), (XdmValue)new XdmAtomicValue(ontologyURI));
            }
            if ((baseURI = this.getLinkURI(headerMap, LDT.base)) != null) {
                params.put(new QName("ldt", LDT.base.getNameSpace(), LDT.base.getLocalName()), (XdmValue)new XdmAtomicValue(baseURI));
            }
            if ((forClassURI = (String)this.getUriInfo().getQueryParameters().getFirst((Object)AC.forClass.getLocalName())) != null) {
                params.put(new QName("ac", AC.forClass.getNameSpace(), AC.forClass.getLocalName()), (XdmValue)new XdmAtomicValue(URI.create(forClassURI)));
            }
            if ((locale = (Locale)headerMap.getFirst((Object)"Content-Language")) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Writing Model using language: {}", (Object)locale.toLanguageTag());
                }
                params.put(new QName("ldt", LDT.lang.getNameSpace(), LDT.lang.getLocalName()), (XdmValue)new XdmAtomicValue(locale.toLanguageTag()));
            }
            return params;
        }
        catch (URISyntaxException ex) {
            if (log.isErrorEnabled()) {
                log.error("URI syntax exception: {}", (Object)ex.getMessage());
            }
            throw new TransformerException(ex);
        }
    }

    public URI getAbsolutePath() {
        return this.getUriInfo().getAbsolutePath();
    }

    public URI getRequestURI() {
        return this.getUriInfo().getRequestUri();
    }

    public URI getURIParam(UriInfo uriInfo, String name) throws URISyntaxException {
        if (uriInfo == null) {
            throw new IllegalArgumentException("UriInfo cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("String cannot be null");
        }
        if (uriInfo.getQueryParameters().containsKey((Object)name)) {
            return new URI((String)uriInfo.getQueryParameters().getFirst((Object)name));
        }
        return null;
    }

    public URI getURI() throws URISyntaxException {
        return this.getURIParam(this.getUriInfo(), AC.uri.getLocalName());
    }

    public URI getEndpointURI() throws URISyntaxException {
        return this.getURIParam(this.getUriInfo(), AC.endpoint.getLocalName());
    }

    public String getQuery() {
        if (this.getUriInfo().getQueryParameters().containsKey((Object)AC.query.getLocalName())) {
            return (String)this.getUriInfo().getQueryParameters().getFirst((Object)AC.query.getLocalName());
        }
        return null;
    }

    public static StreamSource getSource(Model model) throws IOException {
        if (model == null) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Number of Model stmts read: {}", (Object)model.size());
        }
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            model.write((OutputStream)stream, RDFLanguages.RDFXML.getName(), null);
            if (log.isDebugEnabled()) {
                log.debug("RDF/XML bytes written: {}", (Object)stream.toByteArray().length);
            }
            StreamSource streamSource = new StreamSource(new ByteArrayInputStream(stream.toByteArray()));
            return streamSource;
        }
    }

    public URI getContextURI() {
        return URI.create(this.getHttpServletRequest().getRequestURL().toString()).resolve(this.getHttpServletRequest().getContextPath() + "/");
    }

    public Set<String> getSupportedNamespaces() {
        return NAMESPACES;
    }

    public List<URI> getModes(Set<String> namespaces) {
        return this.getModes(this.getUriInfo(), namespaces);
    }

    public List<URI> getModes(UriInfo uriInfo, Set<String> namespaces) {
        if (uriInfo == null) {
            throw new IllegalArgumentException("UriInfo cannot be null");
        }
        if (namespaces == null) {
            throw new IllegalArgumentException("Namespace Set cannot be null");
        }
        ArrayList<URI> modes = new ArrayList<URI>();
        if (uriInfo.getQueryParameters().containsKey((Object)AC.mode.getLocalName())) {
            List modeParamValues = (List)uriInfo.getQueryParameters().get((Object)AC.mode.getLocalName());
            for (String modeParamValue : modeParamValues) {
                Resource paramMode = ResourceFactory.createResource((String)modeParamValue);
                if (!namespaces.contains(paramMode.getNameSpace())) continue;
                modes.add(URI.create(modeParamValue));
            }
        }
        return modes;
    }

    public static IRI checkURI(String classIRIStr) {
        if (classIRIStr == null) {
            throw new IllegalArgumentException("URI String cannot be null");
        }
        IRI classIRI = IRIFactory.iriImplementation().create(classIRIStr);
        Checker.iriViolations((IRI)classIRI);
        return classIRI;
    }

    public URI getLinkURI(MultivaluedMap<String, Object> headerMap, ObjectProperty property) {
        if (headerMap.get((Object)"Link") == null) {
            return null;
        }
        List baseLinks = ((List)headerMap.get((Object)"Link")).stream().map(header -> {
            try {
                return Link.valueOf((String)header.toString());
            }
            catch (URISyntaxException ex) {
                if (log.isWarnEnabled()) {
                    log.warn("Could not parse Link URI", (Throwable)ex);
                }
                return null;
            }
        }).filter(link -> link != null && link.getRel().equals(property.getURI())).map(link -> link.getHref()).collect(Collectors.toList());
        if (!baseLinks.isEmpty()) {
            return (URI)baseLinks.get(0);
        }
        return null;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public Request getRequest() {
        return this.request;
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public OntModelSpec getOntModelSpec() {
        return this.ontModelSpec;
    }

    public XsltExecutable getXsltExecutable() {
        return this.xsltExec;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    static {
        NAMESPACES.add("https://w3id.org/atomgraph/client#");
    }
}

