/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.client.writer;

import com.atomgraph.client.util.XSLTBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ResultSetXSLTWriter
implements MessageBodyWriter<ResultSet> {
    private static final Logger log = LoggerFactory.getLogger(ResultSetXSLTWriter.class);
    private Source stylesheet = null;
    private URIResolver resolver = null;

    public ResultSetXSLTWriter(Source stylesheet, URIResolver resolver) throws TransformerConfigurationException {
        if (stylesheet == null) {
            throw new IllegalArgumentException("XSLT stylesheet Source cannot be null");
        }
        if (resolver == null) {
            throw new IllegalArgumentException("URIResolver cannot be null");
        }
        this.stylesheet = stylesheet;
        this.resolver = resolver;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ResultSet.class.isAssignableFrom(type);
    }

    public long getSize(ResultSet results, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(ResultSet results, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headerMap, OutputStream entityStream) throws IOException, WebApplicationException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ResultSetFormatter.outputAsXML((OutputStream)baos, (ResultSet)results);
            this.getXSLTBuilder((InputStream)new ByteArrayInputStream(baos.toByteArray()), headerMap, entityStream).transform();
        }
        catch (TransformerException ex) {
            log.error("XSLT transformation failed", (Throwable)ex);
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public SAXTransformerFactory getTransformerFactory() {
        return (SAXTransformerFactory)TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
    }

    public URIResolver getURIResolver() {
        return this.resolver;
    }

    public Source getStylesheet() {
        return this.stylesheet;
    }

    public XSLTBuilder getXSLTBuilder(InputStream is, MultivaluedMap<String, Object> headerMap, OutputStream os) throws TransformerConfigurationException {
        return XSLTBuilder.newInstance((SAXTransformerFactory)this.getTransformerFactory()).stylesheet(this.getStylesheet()).resolver(this.getURIResolver()).document(is).result((Result)new StreamResult(os));
    }
}

