/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.client.writer.function;

import com.atomgraph.client.util.Constructor;
import com.atomgraph.client.writer.ModelXSLTWriter;
import java.io.IOException;
import javax.xml.transform.Source;
import net.sf.saxon.s9api.ExtensionFunction;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.OccurrenceIndicator;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SequenceType;
import net.sf.saxon.s9api.XdmValue;
import org.apache.jena.ontology.OntDocumentManager;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;

public class ConstructForClass
implements ExtensionFunction {
    private final Processor processor;
    private final OntDocumentManager odm;

    public ConstructForClass(Processor processor, OntDocumentManager odm) {
        this.processor = processor;
        this.odm = odm;
    }

    public QName getName() {
        return new QName("https://w3id.org/atomgraph/client#", "construct");
    }

    public SequenceType getResultType() {
        return SequenceType.makeSequenceType((ItemType)ItemType.DOCUMENT_NODE, (OccurrenceIndicator)OccurrenceIndicator.ZERO_OR_MORE);
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.makeSequenceType((ItemType)ItemType.ANY_URI, (OccurrenceIndicator)OccurrenceIndicator.ONE), SequenceType.makeSequenceType((ItemType)ItemType.ANY_URI, (OccurrenceIndicator)OccurrenceIndicator.ZERO_OR_MORE), SequenceType.makeSequenceType((ItemType)ItemType.ANY_URI, (OccurrenceIndicator)OccurrenceIndicator.ONE)};
    }

    public XdmValue call(XdmValue[] arguments) throws SaxonApiException {
        try {
            String ontology = arguments[0].itemAt(0).getStringValue();
            String base = arguments[2].itemAt(0).getStringValue();
            Model instances = ModelFactory.createDefaultModel();
            OntModel ontModel = this.getOntDocumentManager().getOntology(ontology, OntModelSpec.OWL_MEM);
            arguments[1].stream().map(forClass -> ontModel.getOntClass(ModelXSLTWriter.checkURI((String)forClass.getStringValue()).toString())).filter(forClass -> forClass != null).forEach(forClass -> new Constructor().construct(forClass, instances, base));
            return this.getProcessor().newDocumentBuilder().build((Source)ModelXSLTWriter.getSource((Model)instances));
        }
        catch (IOException ex) {
            throw new SaxonApiException((Throwable)ex);
        }
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public OntDocumentManager getOntDocumentManager() {
        return this.odm;
    }
}

