/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub;

import com.atomgraph.client.MediaTypes;
import com.atomgraph.client.locator.PrefixMapper;
import com.atomgraph.client.mapper.ClientErrorExceptionMapper;
import com.atomgraph.client.util.DataManager;
import com.atomgraph.client.util.DataManagerImpl;
import com.atomgraph.client.util.XsltResolver;
import com.atomgraph.client.vocabulary.AC;
import com.atomgraph.client.writer.function.UUID;
import com.atomgraph.core.client.LinkedDataClient;
import com.atomgraph.core.exception.ConfigurationException;
import com.atomgraph.core.io.DatasetProvider;
import com.atomgraph.core.io.ModelProvider;
import com.atomgraph.core.io.QueryProvider;
import com.atomgraph.core.io.ResultSetProvider;
import com.atomgraph.core.io.UpdateRequestProvider;
import com.atomgraph.core.mapper.BadGatewayExceptionMapper;
import com.atomgraph.core.provider.QueryParamProvider;
import com.atomgraph.core.riot.RDFLanguages;
import com.atomgraph.core.riot.lang.RDFPostReaderFactory;
import com.atomgraph.core.vocabulary.A;
import com.atomgraph.linkeddatahub.Application;
import com.atomgraph.linkeddatahub.apps.model.AdminApplication;
import com.atomgraph.linkeddatahub.apps.model.Dataset;
import com.atomgraph.linkeddatahub.apps.model.EndUserApplication;
import com.atomgraph.linkeddatahub.apps.model.end_user.impl.ApplicationImplementation;
import com.atomgraph.linkeddatahub.apps.model.impl.DatasetImplementation;
import com.atomgraph.linkeddatahub.client.filter.ClientUriRewriteFilter;
import com.atomgraph.linkeddatahub.imports.ImportExecutor;
import com.atomgraph.linkeddatahub.io.HtmlJsonLDReaderFactory;
import com.atomgraph.linkeddatahub.io.JsonLDReader;
import com.atomgraph.linkeddatahub.listener.EMailListener;
import com.atomgraph.linkeddatahub.model.CSVImport;
import com.atomgraph.linkeddatahub.model.File;
import com.atomgraph.linkeddatahub.model.Import;
import com.atomgraph.linkeddatahub.model.RDFImport;
import com.atomgraph.linkeddatahub.model.Service;
import com.atomgraph.linkeddatahub.model.UserAccount;
import com.atomgraph.linkeddatahub.model.auth.Agent;
import com.atomgraph.linkeddatahub.model.auth.Authorization;
import com.atomgraph.linkeddatahub.model.auth.impl.AgentImpl;
import com.atomgraph.linkeddatahub.model.auth.impl.AuthorizationImpl;
import com.atomgraph.linkeddatahub.model.impl.CSVImportImpl;
import com.atomgraph.linkeddatahub.model.impl.FileImpl;
import com.atomgraph.linkeddatahub.model.impl.ImportImpl;
import com.atomgraph.linkeddatahub.model.impl.RDFImportImpl;
import com.atomgraph.linkeddatahub.model.impl.ServiceImplementation;
import com.atomgraph.linkeddatahub.model.impl.UserAccountImpl;
import com.atomgraph.linkeddatahub.server.event.AuthorizationCreated;
import com.atomgraph.linkeddatahub.server.event.SignUp;
import com.atomgraph.linkeddatahub.server.filter.request.ApplicationFilter;
import com.atomgraph.linkeddatahub.server.filter.request.AuthorizationFilter;
import com.atomgraph.linkeddatahub.server.filter.request.ContentLengthLimitFilter;
import com.atomgraph.linkeddatahub.server.filter.request.MultipartRDFPostCleanupFilter;
import com.atomgraph.linkeddatahub.server.filter.request.OntologyFilter;
import com.atomgraph.linkeddatahub.server.filter.request.auth.IDTokenFilter;
import com.atomgraph.linkeddatahub.server.filter.request.auth.ProxiedWebIDFilter;
import com.atomgraph.linkeddatahub.server.filter.request.auth.WebIDFilter;
import com.atomgraph.linkeddatahub.server.filter.response.BackendInvalidationFilter;
import com.atomgraph.linkeddatahub.server.filter.response.ResponseHeaderFilter;
import com.atomgraph.linkeddatahub.server.filter.response.XsltExecutableFilter;
import com.atomgraph.linkeddatahub.server.interceptor.RDFPostCleanupInterceptor;
import com.atomgraph.linkeddatahub.server.interceptor.UpdateRequestCleanupInterceptor;
import com.atomgraph.linkeddatahub.server.io.ValidatingModelProvider;
import com.atomgraph.linkeddatahub.server.mapper.HttpHostConnectExceptionMapper;
import com.atomgraph.linkeddatahub.server.mapper.MessagingExceptionMapper;
import com.atomgraph.linkeddatahub.server.mapper.ModelExceptionMapper;
import com.atomgraph.linkeddatahub.server.mapper.OntClassNotFoundExceptionMapper;
import com.atomgraph.linkeddatahub.server.mapper.ResourceExistsExceptionMapper;
import com.atomgraph.linkeddatahub.server.mapper.auth.AuthenticationExceptionMapper;
import com.atomgraph.linkeddatahub.server.mapper.auth.AuthorizationExceptionMapper;
import com.atomgraph.linkeddatahub.server.mapper.auth.oauth2.TokenExpiredExceptionMapper;
import com.atomgraph.linkeddatahub.server.mapper.auth.webid.InvalidWebIDPublicKeyExceptionMapper;
import com.atomgraph.linkeddatahub.server.mapper.auth.webid.InvalidWebIDURIExceptionMapper;
import com.atomgraph.linkeddatahub.server.mapper.auth.webid.WebIDCertificateExceptionMapper;
import com.atomgraph.linkeddatahub.server.mapper.auth.webid.WebIDDelegationExceptionMapper;
import com.atomgraph.linkeddatahub.server.mapper.auth.webid.WebIDLoadingExceptionMapper;
import com.atomgraph.linkeddatahub.server.mapper.jena.QueryExecExceptionMapper;
import com.atomgraph.linkeddatahub.server.mapper.jena.RiotParseExceptionMapper;
import com.atomgraph.linkeddatahub.server.model.impl.Dispatcher;
import com.atomgraph.linkeddatahub.server.model.impl.GraphStoreImpl;
import com.atomgraph.linkeddatahub.server.util.MessageBuilder;
import com.atomgraph.linkeddatahub.vocabulary.ACL;
import com.atomgraph.linkeddatahub.vocabulary.FOAF;
import com.atomgraph.linkeddatahub.vocabulary.Google;
import com.atomgraph.linkeddatahub.vocabulary.LAPP;
import com.atomgraph.linkeddatahub.vocabulary.LDH;
import com.atomgraph.linkeddatahub.vocabulary.LDHC;
import com.atomgraph.linkeddatahub.writer.ModelXSLTWriter;
import com.atomgraph.linkeddatahub.writer.function.Construct;
import com.atomgraph.linkeddatahub.writer.function.DecodeURI;
import com.atomgraph.processor.vocabulary.AP;
import com.atomgraph.processor.vocabulary.LDT;
import com.atomgraph.server.mapper.ConfigurationExceptionMapper;
import com.atomgraph.server.mapper.NotFoundExceptionMapper;
import com.atomgraph.server.mapper.OntologyExceptionMapper;
import com.atomgraph.server.mapper.ParameterExceptionMapper;
import com.atomgraph.server.mapper.SHACLConstraintViolationExceptionMapper;
import com.atomgraph.server.mapper.SPINConstraintViolationExceptionMapper;
import com.atomgraph.server.mapper.jena.DatatypeFormatExceptionMapper;
import com.atomgraph.server.mapper.jena.QueryParseExceptionMapper;
import com.atomgraph.server.mapper.jena.RiotExceptionMapper;
import com.atomgraph.spinrdf.vocabulary.SP;
import com.github.jsonldjava.core.DocumentLoader;
import com.github.jsonldjava.core.JsonLdOptions;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.jodah.expiringmap.ExpiringMap;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.s9api.ExtensionFunction;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.jena.enhanced.BuiltinPersonalities;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.enhanced.Personality;
import org.apache.jena.graph.Graph;
import org.apache.jena.ontology.OntDocumentManager;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.ModelGetter;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.sparql.graph.GraphReadOnly;
import org.apache.jena.util.FileManager;
import org.apache.jena.util.LocationMapper;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.LocationMappingVocab;
import org.apache.jena.vocabulary.RDF;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.HttpMethodOverrideFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Application
extends ResourceConfig {
    private static final Logger log = LoggerFactory.getLogger(Application.class);
    private final ExecutorService importThreadPool;
    private final ServletConfig servletConfig;
    private final EventBus eventBus;
    private final DataManager dataManager;
    private final Map<String, OntModelSpec> endUserOntModelSpecs;
    private final MediaTypes mediaTypes;
    private final Client client;
    private final Client importClient;
    private final Client noCertClient;
    private final Query authQuery;
    private final Query ownerAuthQuery;
    private final Query webIDQuery;
    private final Query agentQuery;
    private final Query userAccountQuery;
    private final Query ontologyQuery;
    private final Integer maxGetRequestSize;
    private final boolean preemptiveAuth;
    private final Processor xsltProc;
    private final XsltCompiler xsltComp;
    private final XsltExecutable xsltExec;
    private final OntModelSpec ontModelSpec;
    private final boolean cacheStylesheet;
    private final boolean resolvingUncached;
    private final URI baseURI;
    private final URI uploadRoot;
    private final boolean invalidateCache;
    private final Integer cookieMaxAge;
    private final boolean enableLinkedDataProxy;
    private final Integer maxContentLength;
    private final Address notificationAddress;
    private final Authenticator authenticator;
    private final Properties emailProperties;
    private final KeyStore keyStore;
    private final KeyStore trustStore;
    private final URI secretaryWebIDURI;
    private final List<Locale> supportedLanguages;
    private final ExpiringMap<URI, Model> webIDmodelCache;
    private final ExpiringMap<String, Model> oidcModelCache;
    private final Map<URI, XsltExecutable> xsltExecutableCache;
    private final MessageDigest messageDigest;
    private final boolean enableWebIDSignUp;
    private final String oidcRefreshTokensPropertiesPath;
    private final Properties oidcRefreshTokens;
    private org.apache.jena.query.Dataset contextDataset;

    public Application(@Context ServletConfig servletConfig) throws URISyntaxException, MalformedURLException, IOException {
        this(servletConfig, new MediaTypes(), servletConfig.getServletContext().getInitParameter(A.maxGetRequestSize.getURI()) != null ? Integer.valueOf(servletConfig.getServletContext().getInitParameter(A.maxGetRequestSize.getURI())) : null, servletConfig.getServletContext().getInitParameter(A.cacheModelLoads.getURI()) != null ? Boolean.parseBoolean(servletConfig.getServletContext().getInitParameter(A.cacheModelLoads.getURI())) : true, servletConfig.getServletContext().getInitParameter(A.preemptiveAuth.getURI()) != null ? Boolean.parseBoolean(servletConfig.getServletContext().getInitParameter(A.preemptiveAuth.getURI())) : false, servletConfig.getServletContext().getInitParameter(AP.cacheSitemap.getURI()) != null ? Boolean.valueOf(servletConfig.getServletContext().getInitParameter(AP.cacheSitemap.getURI())) : true, (LocationMapper)new PrefixMapper(servletConfig.getServletContext().getInitParameter(AC.prefixMapping.getURI()) != null ? servletConfig.getServletContext().getInitParameter(AC.prefixMapping.getURI()) : null), com.atomgraph.client.Application.getSource((ServletContext)servletConfig.getServletContext(), servletConfig.getServletContext().getInitParameter(AC.stylesheet.getURI()) != null ? servletConfig.getServletContext().getInitParameter(AC.stylesheet.getURI()) : null), servletConfig.getServletContext().getInitParameter(AC.cacheStylesheet.getURI()) != null ? Boolean.parseBoolean(servletConfig.getServletContext().getInitParameter(AC.cacheStylesheet.getURI())) : false, servletConfig.getServletContext().getInitParameter(AC.resolvingUncached.getURI()) != null ? Boolean.parseBoolean(servletConfig.getServletContext().getInitParameter(AC.resolvingUncached.getURI())) : true, servletConfig.getServletContext().getInitParameter(LDHC.clientKeyStore.getURI()) != null ? servletConfig.getServletContext().getInitParameter(LDHC.clientKeyStore.getURI()) : null, servletConfig.getServletContext().getInitParameter(LDHC.clientKeyStorePassword.getURI()) != null ? servletConfig.getServletContext().getInitParameter(LDHC.clientKeyStorePassword.getURI()) : null, servletConfig.getServletContext().getInitParameter(LDHC.secretaryCertAlias.getURI()) != null ? servletConfig.getServletContext().getInitParameter(LDHC.secretaryCertAlias.getURI()) : null, servletConfig.getServletContext().getInitParameter(LDHC.clientTrustStore.getURI()) != null ? servletConfig.getServletContext().getInitParameter(LDHC.clientTrustStore.getURI()) : null, servletConfig.getServletContext().getInitParameter(LDHC.clientTrustStorePassword.getURI()) != null ? servletConfig.getServletContext().getInitParameter(LDHC.clientTrustStorePassword.getURI()) : null, servletConfig.getServletContext().getInitParameter(LDHC.authQuery.getURI()) != null ? servletConfig.getServletContext().getInitParameter(LDHC.authQuery.getURI()) : null, servletConfig.getServletContext().getInitParameter(LDHC.ownerAuthQuery.getURI()) != null ? servletConfig.getServletContext().getInitParameter(LDHC.ownerAuthQuery.getURI()) : null, servletConfig.getServletContext().getInitParameter(LDHC.webIDQuery.getURI()) != null ? servletConfig.getServletContext().getInitParameter(LDHC.webIDQuery.getURI()) : null, servletConfig.getServletContext().getInitParameter(LDHC.agentQuery.getURI()) != null ? servletConfig.getServletContext().getInitParameter(LDHC.agentQuery.getURI()) : null, servletConfig.getServletContext().getInitParameter(LDHC.userAccountQuery.getURI()) != null ? servletConfig.getServletContext().getInitParameter(LDHC.userAccountQuery.getURI()) : null, servletConfig.getServletContext().getInitParameter(LDHC.ontologyQuery.getURI()) != null ? servletConfig.getServletContext().getInitParameter(LDHC.ontologyQuery.getURI()) : null, servletConfig.getServletContext().getInitParameter(LDHC.baseUri.getURI()) != null ? servletConfig.getServletContext().getInitParameter(LDHC.baseUri.getURI()) : null, servletConfig.getServletContext().getInitParameter(LDHC.proxyScheme.getURI()) != null ? servletConfig.getServletContext().getInitParameter(LDHC.proxyScheme.getURI()) : null, servletConfig.getServletContext().getInitParameter(LDHC.proxyHost.getURI()) != null ? servletConfig.getServletContext().getInitParameter(LDHC.proxyHost.getURI()) : null, servletConfig.getServletContext().getInitParameter(LDHC.proxyPort.getURI()) != null ? Integer.valueOf(servletConfig.getServletContext().getInitParameter(LDHC.proxyPort.getURI())) : null, servletConfig.getServletContext().getInitParameter(LDHC.uploadRoot.getURI()) != null ? servletConfig.getServletContext().getInitParameter(LDHC.uploadRoot.getURI()) : null, servletConfig.getServletContext().getInitParameter(LDHC.invalidateCache.getURI()) != null ? Boolean.parseBoolean(servletConfig.getServletContext().getInitParameter(LDHC.invalidateCache.getURI())) : false, servletConfig.getServletContext().getInitParameter(LDHC.cookieMaxAge.getURI()) != null ? Integer.valueOf(servletConfig.getServletContext().getInitParameter(LDHC.cookieMaxAge.getURI())) : null, servletConfig.getServletContext().getInitParameter(LDHC.enableLinkedDataProxy.getURI()) != null ? Boolean.parseBoolean(servletConfig.getServletContext().getInitParameter(LDHC.enableLinkedDataProxy.getURI())) : true, servletConfig.getServletContext().getInitParameter(LDHC.maxContentLength.getURI()) != null ? Integer.valueOf(servletConfig.getServletContext().getInitParameter(LDHC.maxContentLength.getURI())) : null, servletConfig.getServletContext().getInitParameter(LDHC.maxConnPerRoute.getURI()) != null ? Integer.valueOf(servletConfig.getServletContext().getInitParameter(LDHC.maxConnPerRoute.getURI())) : null, servletConfig.getServletContext().getInitParameter(LDHC.maxTotalConn.getURI()) != null ? Integer.valueOf(servletConfig.getServletContext().getInitParameter(LDHC.maxTotalConn.getURI())) : null, servletConfig.getServletContext().getInitParameter(LDHC.importKeepAlive.getURI()) != null ? (response, context) -> Integer.valueOf(servletConfig.getServletContext().getInitParameter(LDHC.importKeepAlive.getURI())).intValue() : null, servletConfig.getServletContext().getInitParameter(LDHC.maxImportThreads.getURI()) != null ? Integer.valueOf(servletConfig.getServletContext().getInitParameter(LDHC.maxImportThreads.getURI())) : null, servletConfig.getServletContext().getInitParameter(LDHC.notificationAddress.getURI()) != null ? servletConfig.getServletContext().getInitParameter(LDHC.notificationAddress.getURI()) : null, servletConfig.getServletContext().getInitParameter(LDHC.supportedLanguages.getURI()) != null ? servletConfig.getServletContext().getInitParameter(LDHC.supportedLanguages.getURI()) : null, servletConfig.getServletContext().getInitParameter(LDHC.enableWebIDSignUp.getURI()) != null ? Boolean.parseBoolean(servletConfig.getServletContext().getInitParameter(LDHC.enableWebIDSignUp.getURI())) : true, servletConfig.getServletContext().getInitParameter(LDHC.oidcRefreshTokens.getURI()), servletConfig.getServletContext().getInitParameter("mail.user") != null ? servletConfig.getServletContext().getInitParameter("mail.user") : null, servletConfig.getServletContext().getInitParameter("mail.password") != null ? servletConfig.getServletContext().getInitParameter("mail.password") : null, servletConfig.getServletContext().getInitParameter("mail.smtp.host") != null ? servletConfig.getServletContext().getInitParameter("mail.smtp.host") : null, servletConfig.getServletContext().getInitParameter("mail.smtp.port") != null ? servletConfig.getServletContext().getInitParameter("mail.smtp.port") : null, servletConfig.getServletContext().getInitParameter(Google.clientID.getURI()) != null ? servletConfig.getServletContext().getInitParameter(Google.clientID.getURI()) : null, servletConfig.getServletContext().getInitParameter(Google.clientSecret.getURI()) != null ? servletConfig.getServletContext().getInitParameter(Google.clientSecret.getURI()) : null);
        URI contextDatasetURI;
        URI uRI = contextDatasetURI = servletConfig.getServletContext().getInitParameter(LDHC.contextDataset.getURI()) != null ? new URI(servletConfig.getServletContext().getInitParameter(LDHC.contextDataset.getURI())) : null;
        if (contextDatasetURI == null) {
            if (log.isErrorEnabled()) {
                log.error("Context dataset URI '{}' not configured", (Object)LDHC.contextDataset.getURI());
            }
            throw new ConfigurationException((Property)LDHC.contextDataset);
        }
        this.contextDataset = Application.getDataset((ServletContext)servletConfig.getServletContext(), (URI)contextDatasetURI);
    }

    public Application(ServletConfig servletConfig, MediaTypes mediaTypes, Integer maxGetRequestSize, boolean cacheModelLoads, boolean preemptiveAuth, boolean cacheSitemap, LocationMapper locationMapper, Source stylesheet, boolean cacheStylesheet, boolean resolvingUncached, String clientKeyStoreURIString, String clientKeyStorePassword, String secretaryCertAlias, String clientTrustStoreURIString, String clientTrustStorePassword, String authQueryString, String ownerAuthQueryString, String webIDQueryString, String agentQueryString, String userAccountQueryString, String ontologyQueryString, String baseURIString, String proxyScheme, String proxyHostname, Integer proxyPort, String uploadRootString, boolean invalidateCache, Integer cookieMaxAge, boolean enableLinkedDataProxy, Integer maxContentLength, Integer maxConnPerRoute, Integer maxTotalConn, ConnectionKeepAliveStrategy importKeepAliveStrategy, Integer maxImportThreads, String notificationAddressString, String supportedLanguageCodes, boolean enableWebIDSignUp, String oidcRefreshTokensPropertiesPath, String mailUser, String mailPassword, String smtpHost, String smtpPort, String googleClientID, String googleClientSecret) {
        block104: {
            this.eventBus = new EventBus();
            this.xsltProc = new Processor(false);
            this.emailProperties = new Properties();
            this.webIDmodelCache = ExpiringMap.builder().expiration(1L, TimeUnit.DAYS).build();
            this.oidcModelCache = ExpiringMap.builder().variableExpiration().build();
            this.xsltExecutableCache = new HashMap();
            if (clientKeyStoreURIString == null) {
                if (log.isErrorEnabled()) {
                    log.error("Client key store ({}) not configured", (Object)LDHC.clientKeyStore.getURI());
                }
                throw new ConfigurationException((Property)LDHC.clientKeyStore);
            }
            if (secretaryCertAlias == null) {
                if (log.isErrorEnabled()) {
                    log.error("Secretary client certificate alias ({}) not configured", (Object)LDHC.secretaryCertAlias.getURI());
                }
                throw new ConfigurationException((Property)LDHC.secretaryCertAlias);
            }
            if (clientTrustStoreURIString == null) {
                if (log.isErrorEnabled()) {
                    log.error("Client truststore store ({}) not configured", (Object)LDHC.clientTrustStore.getURI());
                }
                throw new ConfigurationException((Property)LDHC.clientTrustStore);
            }
            if (authQueryString == null) {
                if (log.isErrorEnabled()) {
                    log.error("Authentication SPARQL query is not configured properly");
                }
                throw new ConfigurationException((Property)LDHC.authQuery);
            }
            this.authQuery = QueryFactory.create((String)authQueryString);
            if (ownerAuthQueryString == null) {
                if (log.isErrorEnabled()) {
                    log.error("Owner authorization SPARQL query is not configured properly");
                }
                throw new ConfigurationException((Property)LDHC.ownerAuthQuery);
            }
            this.ownerAuthQuery = QueryFactory.create((String)ownerAuthQueryString);
            if (webIDQueryString == null) {
                if (log.isErrorEnabled()) {
                    log.error("WebID SPARQL query is not configured properly");
                }
                throw new ConfigurationException((Property)LDHC.webIDQuery);
            }
            this.webIDQuery = QueryFactory.create((String)webIDQueryString);
            if (agentQueryString == null) {
                if (log.isErrorEnabled()) {
                    log.error("Agent SPARQL query is not configured properly");
                }
                throw new ConfigurationException((Property)LDHC.agentQuery);
            }
            this.agentQuery = QueryFactory.create((String)agentQueryString);
            if (userAccountQueryString == null) {
                if (log.isErrorEnabled()) {
                    log.error("UserAccount SPARQL query is not configured properly");
                }
                throw new ConfigurationException((Property)LDHC.userAccountQuery);
            }
            this.userAccountQuery = QueryFactory.create((String)userAccountQueryString);
            if (ontologyQueryString == null) {
                if (log.isErrorEnabled()) {
                    log.error("Ontology SPARQL query is not configured properly");
                }
                throw new ConfigurationException((Property)LDHC.ontologyQuery);
            }
            this.ontologyQuery = QueryFactory.create((String)ontologyQueryString);
            if (baseURIString == null) {
                if (log.isErrorEnabled()) {
                    log.error("Base URI property '{}' not configured", (Object)LDHC.baseUri.getURI());
                }
                throw new ConfigurationException((Property)LDHC.baseUri);
            }
            this.baseURI = URI.create(baseURIString);
            if (uploadRootString == null) {
                if (log.isErrorEnabled()) {
                    log.error("Upload root ({}) not configured", (Object)LDHC.uploadRoot.getURI());
                }
                throw new ConfigurationException((Property)LDHC.uploadRoot);
            }
            if (cookieMaxAge == null) {
                if (log.isErrorEnabled()) {
                    log.error("JWT cookie max age property '{}' not configured", (Object)LDHC.cookieMaxAge.getURI());
                }
                throw new ConfigurationException((Property)LDHC.cookieMaxAge);
            }
            this.cookieMaxAge = cookieMaxAge;
            if (maxImportThreads == null) {
                if (log.isErrorEnabled()) {
                    log.error("Max import thread count property '{}' not configured", (Object)LDHC.maxImportThreads.getURI());
                }
                throw new ConfigurationException((Property)LDHC.maxImportThreads);
            }
            this.importThreadPool = Executors.newFixedThreadPool(maxImportThreads);
            servletConfig.getServletContext().setAttribute(LDHC.maxImportThreads.getURI(), (Object)this.importThreadPool);
            if (supportedLanguageCodes == null) {
                if (log.isErrorEnabled()) {
                    log.error("Supported languages ({}) not configured", (Object)LDHC.supportedLanguages.getURI());
                }
                throw new ConfigurationException((Property)LDHC.supportedLanguages);
            }
            this.supportedLanguages = Arrays.asList(supportedLanguageCodes.split(",")).stream().map(code -> Locale.forLanguageTag(code)).collect(Collectors.toList());
            this.servletConfig = servletConfig;
            this.mediaTypes = mediaTypes;
            this.maxGetRequestSize = maxGetRequestSize;
            this.preemptiveAuth = preemptiveAuth;
            this.cacheStylesheet = cacheStylesheet;
            this.resolvingUncached = resolvingUncached;
            this.enableLinkedDataProxy = enableLinkedDataProxy;
            this.maxContentLength = maxContentLength;
            this.invalidateCache = invalidateCache;
            this.enableWebIDSignUp = enableWebIDSignUp;
            this.oidcRefreshTokensPropertiesPath = oidcRefreshTokensPropertiesPath;
            this.oidcRefreshTokens = new Properties();
            if (googleClientID != null) {
                this.property(Google.clientID.getURI(), (Object)googleClientID);
            }
            if (googleClientSecret != null) {
                this.property(Google.clientSecret.getURI(), (Object)googleClientSecret);
            }
            try {
                this.uploadRoot = new URI(uploadRootString);
            }
            catch (URISyntaxException ex) {
                if (log.isErrorEnabled()) {
                    log.error("Upload root URI syntax error: {}", (Throwable)ex);
                }
                throw new IllegalStateException(ex);
            }
            if (googleClientID != null && oidcRefreshTokensPropertiesPath == null) {
                if (log.isErrorEnabled()) {
                    log.error("Google OIDC signup is enabled (clientID client is provided) but refresh token cache is not configured (ldhc:oidcRefreshTokens)");
                }
                throw new IllegalStateException("Google OIDC signup is enabled (clientID client is provided) but refresh token cache is not configured (ldhc:oidcRefreshTokens)");
            }
            if (oidcRefreshTokensPropertiesPath != null) {
                try (FileInputStream propertiesStream = new FileInputStream(oidcRefreshTokensPropertiesPath);){
                    if (propertiesStream == null) {
                        if (log.isErrorEnabled()) {
                            log.error(".properties file with OIDC refresh tokens not found (ldhc:oidcRefreshTokens)");
                        }
                        throw new IllegalStateException(".properties file with OIDC refresh tokens not found (ldhc:oidcRefreshTokens)");
                    }
                    this.oidcRefreshTokens.load(propertiesStream);
                }
                catch (IOException ex) {
                    if (log.isErrorEnabled()) {
                        log.error("Cannot read .properties file with OIDC refresh tokens: {}", (Throwable)ex);
                    }
                    throw new IllegalStateException(ex);
                }
            }
            if (notificationAddressString != null) {
                try {
                    InternetAddress[] notificationAddresses = InternetAddress.parse((String)notificationAddressString);
                    this.notificationAddress = notificationAddresses[0];
                }
                catch (AddressException ex) {
                    throw new IllegalStateException(ex);
                }
            } else {
                this.notificationAddress = null;
            }
            RDFLanguages.register((Lang)RDFLanguages.RDFPOST);
            RDFParserRegistry.registerLangTriples((Lang)RDFLanguages.RDFPOST, (ReaderRIOTFactory)new RDFPostReaderFactory());
            DocumentLoader documentLoader = new DocumentLoader();
            JsonLdOptions jsonLdOptions = new JsonLdOptions();
            try (InputStream contextStream = servletConfig.getServletContext().getResourceAsStream("/WEB-INF/classes/com/atomgraph/linkeddatahub/schema.org.jsonldcontext.json");){
                String jsonContext = new String(contextStream.readAllBytes(), StandardCharsets.UTF_8);
                documentLoader.addInjectedDoc("http://schema.org", jsonContext);
                documentLoader.addInjectedDoc("https://schema.org", jsonContext);
                jsonLdOptions.setDocumentLoader(documentLoader);
                ParserProfile profile = RiotLib.profile((Lang)HtmlJsonLDReaderFactory.HTML, null, (ErrorHandler)ErrorHandlerFactory.getDefaultErrorHandler());
                RDFLanguages.register((Lang)HtmlJsonLDReaderFactory.HTML);
                RDFParserRegistry.registerLangTriples((Lang)HtmlJsonLDReaderFactory.HTML, (ReaderRIOTFactory)new HtmlJsonLDReaderFactory(new JsonLDReader(Lang.JSONLD, profile, profile.getErrorHandler()), jsonLdOptions));
            }
            catch (IOException ex) {
                if (!log.isErrorEnabled()) break block104;
                log.error("schema.org @context not found", (Throwable)ex);
            }
        }
        RDFWriterRegistry.register((Lang)Lang.RDFXML, (RDFFormat)RDFFormat.RDFXML_PLAIN);
        LocationMapper.setGlobalLocationMapper((LocationMapper)locationMapper);
        if (log.isTraceEnabled()) {
            log.trace("LocationMapper.get(): {}", (Object)locationMapper);
        }
        try {
            Certificate secretaryCert;
            this.keyStore = KeyStore.getInstance("PKCS12");
            this.keyStore.load(new FileInputStream(new java.io.File(new URI(clientKeyStoreURIString))), clientKeyStorePassword.toCharArray());
            this.trustStore = KeyStore.getInstance("JKS");
            this.trustStore.load(new FileInputStream(new java.io.File(new URI(clientTrustStoreURIString))), clientTrustStorePassword.toCharArray());
            this.client = Application.getClient((KeyStore)this.keyStore, (String)clientKeyStorePassword, (KeyStore)this.trustStore, (Integer)maxConnPerRoute, (Integer)maxTotalConn, null);
            this.importClient = Application.getClient((KeyStore)this.keyStore, (String)clientKeyStorePassword, (KeyStore)this.trustStore, (Integer)maxConnPerRoute, (Integer)maxTotalConn, (ConnectionKeepAliveStrategy)importKeepAliveStrategy);
            this.noCertClient = Application.getNoCertClient((KeyStore)this.trustStore, (Integer)maxConnPerRoute, (Integer)maxTotalConn);
            if (proxyHostname != null) {
                ClientUriRewriteFilter rewriteFilter = new ClientUriRewriteFilter(this.baseURI, proxyScheme, proxyHostname, proxyPort);
                this.client.register((Object)rewriteFilter);
                this.importClient.register((Object)rewriteFilter);
                this.noCertClient.register((Object)rewriteFilter);
            }
            if ((secretaryCert = this.keyStore.getCertificate(secretaryCertAlias)) == null) {
                if (log.isErrorEnabled()) {
                    log.error("Secretary certificate with alias {} does not exist in client keystore {}", (Object)secretaryCertAlias, (Object)clientKeyStoreURIString);
                }
                throw new IllegalStateException(new CertificateException("Secretary certificate with alias '" + secretaryCertAlias + "' does not exist in client keystore '" + clientKeyStoreURIString + "'"));
            }
            if (!(secretaryCert instanceof X509Certificate)) {
                if (log.isErrorEnabled()) {
                    log.error("Secretary certificate with alias {} is not a X509Certificate", (Object)secretaryCertAlias);
                }
                throw new IllegalStateException(new CertificateException("Secretary certificate with alias " + secretaryCertAlias + " is not a X509Certificate"));
            }
            X509Certificate secretaryX509Cert = (X509Certificate)secretaryCert;
            secretaryX509Cert.checkValidity();
            this.secretaryWebIDURI = WebIDFilter.getWebIDURI((X509Certificate)secretaryX509Cert);
            if (this.secretaryWebIDURI == null) {
                if (log.isErrorEnabled()) {
                    log.error("Secretary certificate with alias {} is not a valid WebID sertificate (SNA URI is missing)", (Object)secretaryCertAlias);
                }
                throw new IllegalStateException(new CertificateException("Secretary certificate with alias " + secretaryCertAlias + " not a valid WebID sertificate (SNA URI is missing)"));
            }
            SP.init((Personality)BuiltinPersonalities.model);
            BuiltinPersonalities.model.add(Authorization.class, AuthorizationImpl.factory);
            BuiltinPersonalities.model.add(Agent.class, AgentImpl.factory);
            BuiltinPersonalities.model.add(UserAccount.class, UserAccountImpl.factory);
            BuiltinPersonalities.model.add(AdminApplication.class, (Implementation)new com.atomgraph.linkeddatahub.apps.model.admin.impl.ApplicationImplementation());
            BuiltinPersonalities.model.add(EndUserApplication.class, (Implementation)new ApplicationImplementation());
            BuiltinPersonalities.model.add(com.atomgraph.linkeddatahub.apps.model.Application.class, (Implementation)new com.atomgraph.linkeddatahub.apps.model.impl.ApplicationImplementation());
            BuiltinPersonalities.model.add(Dataset.class, (Implementation)new DatasetImplementation());
            BuiltinPersonalities.model.add(Service.class, (Implementation)new ServiceImplementation(this.noCertClient, (com.atomgraph.core.MediaTypes)mediaTypes, maxGetRequestSize));
            BuiltinPersonalities.model.add(Import.class, ImportImpl.factory);
            BuiltinPersonalities.model.add(RDFImport.class, RDFImportImpl.factory);
            BuiltinPersonalities.model.add(CSVImport.class, CSVImportImpl.factory);
            BuiltinPersonalities.model.add(File.class, FileImpl.factory);
            this.endUserOntModelSpecs = new HashMap();
            this.dataManager = new DataManagerImpl(locationMapper, new HashMap(), LinkedDataClient.create((Client)this.client, (com.atomgraph.core.MediaTypes)mediaTypes), cacheModelLoads, preemptiveAuth, resolvingUncached);
            this.ontModelSpec = OntModelSpec.OWL_MEM_RDFS_INF;
            this.ontModelSpec.setImportModelGetter((ModelGetter)this.dataManager);
            OntDocumentManager.getInstance().setFileManager((FileManager)this.dataManager);
            OntDocumentManager.getInstance().setCacheModels(cacheSitemap);
            this.ontModelSpec.setDocumentManager(OntDocumentManager.getInstance());
            if (mailUser != null && mailPassword != null) {
                this.emailProperties.put("mail.smtp.auth", "true");
                this.emailProperties.put("mail.smtp.starttls.enable", "true");
                this.authenticator = new /* Unavailable Anonymous Inner Class!! */;
            } else {
                this.authenticator = null;
            }
            if (smtpHost == null) {
                throw new IllegalStateException(new IllegalStateException("Cannot initialize email service: SMTP host not configured"));
            }
            if (smtpPort == null) {
                throw new IllegalStateException(new IllegalStateException("Cannot initialize email service: SMTP port not configured"));
            }
            this.emailProperties.put("mail.smtp.host", smtpHost);
            this.emailProperties.put("mail.smtp.port", Integer.valueOf(smtpPort));
            try {
                this.messageDigest = MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException ex) {
                if (log.isErrorEnabled()) {
                    log.error("SHA1 algorithm not found", (Throwable)ex);
                }
                throw new InternalServerErrorException((Throwable)ex);
            }
            this.xsltProc.registerExtensionFunction((ExtensionFunction)new UUID());
            this.xsltProc.registerExtensionFunction((ExtensionFunction)new DecodeURI());
            this.xsltProc.registerExtensionFunction((ExtensionFunction)new Construct(this.xsltProc));
            Model mappingModel = locationMapper.toModel();
            try (ResIterator prefixedMappings = mappingModel.listResourcesWithProperty(LocationMappingVocab.prefix);){
                while (prefixedMappings.hasNext()) {
                    Resource prefixMapping = (Resource)prefixedMappings.next();
                    String prefix = prefixMapping.getRequiredProperty(LocationMappingVocab.prefix).getString();
                    TreeInfo doc = this.xsltProc.getUnderlyingConfiguration().buildDocumentTree(this.dataManager.resolve("", prefix));
                    this.xsltProc.getUnderlyingConfiguration().getGlobalDocumentPool().add(doc, prefix);
                }
                try (InputStream translations = servletConfig.getServletContext().getResourceAsStream("static/com/atomgraph/linkeddatahub/xsl/bootstrap/2.3.2/translations.rdf");){
                    TreeInfo doc = this.xsltProc.getUnderlyingConfiguration().buildDocumentTree((Source)new StreamSource(translations));
                    this.xsltProc.getUnderlyingConfiguration().getGlobalDocumentPool().add(doc, this.baseURI.resolve("static/com/atomgraph/linkeddatahub/xsl/bootstrap/2.3.2/translations.rdf").toString());
                }
            }
            this.xsltComp = this.xsltProc.newXsltCompiler();
            this.xsltComp.setParameter(new QName("ldh", LDH.base.getNameSpace(), LDH.base.getLocalName()), (XdmValue)new XdmAtomicValue(this.baseURI));
            this.xsltComp.setURIResolver((URIResolver)new XsltResolver(LocationMapper.get(), new HashMap(), LinkedDataClient.create((Client)this.client, (com.atomgraph.core.MediaTypes)mediaTypes), false, false, true));
            this.xsltExec = this.xsltComp.compile(stylesheet);
        }
        catch (FileNotFoundException ex) {
            if (log.isErrorEnabled()) {
                log.error("File not found", (Throwable)ex);
            }
            throw new IllegalStateException(ex);
        }
        catch (IOException ex) {
            if (log.isErrorEnabled()) {
                log.error("Could not load file", (Throwable)ex);
            }
            throw new IllegalStateException(ex);
        }
        catch (KeyStoreException ex) {
            if (log.isErrorEnabled()) {
                log.error("Key store error", (Throwable)ex);
            }
            throw new IllegalStateException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            if (log.isErrorEnabled()) {
                log.error("No such algorithm", (Throwable)ex);
            }
            throw new IllegalStateException(ex);
        }
        catch (CertificateException ex) {
            if (log.isErrorEnabled()) {
                log.error("Certificate error", (Throwable)ex);
            }
            throw new IllegalStateException(ex);
        }
        catch (KeyManagementException | UnrecoverableKeyException ex) {
            if (log.isErrorEnabled()) {
                log.error("Key management error", (Throwable)ex);
            }
            throw new IllegalStateException(ex);
        }
        catch (URISyntaxException ex) {
            if (log.isErrorEnabled()) {
                log.error("URI syntax error", (Throwable)ex);
            }
            throw new IllegalStateException(ex);
        }
        catch (SaxonApiException ex) {
            if (log.isErrorEnabled()) {
                log.error("System XSLT stylesheet error", (Throwable)ex);
            }
            throw new IllegalStateException(ex);
        }
    }

    @PostConstruct
    public void init() {
        this.register(MultiPartFeature.class);
        this.registerResourceClasses();
        this.registerContainerRequestFilters();
        this.registerContainerResponseFilters();
        this.registerExceptionMappers();
        this.eventBus.register((Object)this);
        this.register((Object)new ValidatingModelProvider(this.getMessageDigest()));
        this.register((Object)new ResultSetProvider());
        this.register((Object)new QueryParamProvider());
        this.register((Object)new UpdateRequestProvider());
        this.register((Object)new ModelXSLTWriter(this.getXsltExecutable(), this.getOntModelSpec(), this.getDataManager(), this.getMessageDigest()));
        Application system = this;
        this.register((Object)new /* Unavailable Anonymous Inner Class!! */);
        this.register((Object)new /* Unavailable Anonymous Inner Class!! */);
        this.register((Object)new /* Unavailable Anonymous Inner Class!! */);
        this.register((Object)new /* Unavailable Anonymous Inner Class!! */);
        this.register((Object)new /* Unavailable Anonymous Inner Class!! */);
        this.register((Object)new /* Unavailable Anonymous Inner Class!! */);
        this.register((Object)new /* Unavailable Anonymous Inner Class!! */);
        this.register((Object)new /* Unavailable Anonymous Inner Class!! */);
        this.register((Object)new /* Unavailable Anonymous Inner Class!! */);
        this.register((Object)new /* Unavailable Anonymous Inner Class!! */);
        this.register((Object)new /* Unavailable Anonymous Inner Class!! */);
        this.register((Object)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void registerResourceClasses() {
        this.register(Dispatcher.class);
    }

    protected void registerContainerRequestFilters() {
        this.register((Object)new HttpMethodOverrideFilter(new HttpMethodOverrideFilter.Source[0]));
        this.register(ApplicationFilter.class);
        this.register(OntologyFilter.class);
        this.register(ProxiedWebIDFilter.class);
        this.register(IDTokenFilter.class);
        this.register(AuthorizationFilter.class);
        this.register(ContentLengthLimitFilter.class);
        this.register((Object)new RDFPostCleanupInterceptor());
        this.register((Object)new UpdateRequestCleanupInterceptor());
        this.register((Object)new MultipartRDFPostCleanupFilter());
    }

    protected void registerContainerResponseFilters() {
        this.register((Object)new ResponseHeaderFilter());
        this.register((Object)new XsltExecutableFilter());
        if (this.isInvalidateCache()) {
            this.register((Object)new BackendInvalidationFilter());
        }
    }

    protected void registerExceptionMappers() {
        this.register(NotFoundExceptionMapper.class);
        this.register(ConfigurationExceptionMapper.class);
        this.register(OntologyExceptionMapper.class);
        this.register(ModelExceptionMapper.class);
        this.register(SPINConstraintViolationExceptionMapper.class);
        this.register(SHACLConstraintViolationExceptionMapper.class);
        this.register(DatatypeFormatExceptionMapper.class);
        this.register(ParameterExceptionMapper.class);
        this.register(QueryExecExceptionMapper.class);
        this.register(RiotExceptionMapper.class);
        this.register(RiotParseExceptionMapper.class);
        this.register(ClientErrorExceptionMapper.class);
        this.register(HttpHostConnectExceptionMapper.class);
        this.register(BadGatewayExceptionMapper.class);
        this.register(OntClassNotFoundExceptionMapper.class);
        this.register(InvalidWebIDPublicKeyExceptionMapper.class);
        this.register(InvalidWebIDURIExceptionMapper.class);
        this.register(WebIDCertificateExceptionMapper.class);
        this.register(WebIDDelegationExceptionMapper.class);
        this.register(WebIDLoadingExceptionMapper.class);
        this.register(TokenExpiredExceptionMapper.class);
        this.register(ResourceExistsExceptionMapper.class);
        this.register(QueryParseExceptionMapper.class);
        this.register(AuthenticationExceptionMapper.class);
        this.register(AuthorizationExceptionMapper.class);
        this.register(MessagingExceptionMapper.class);
    }

    public static org.apache.jena.query.Dataset getDataset(ServletContext servletContext, URI uri) throws FileNotFoundException, MalformedURLException, IOException {
        String baseURI = servletContext.getResource("/").toString();
        try (InputStream datasetStream = uri.isAbsolute() ? new FileInputStream(new java.io.File(uri)) : servletContext.getResourceAsStream(uri.toString());){
            if (datasetStream == null) {
                throw new IOException("Dataset not found at URI: " + uri.toString());
            }
            Lang lang = RDFDataMgr.determineLang((String)uri.toString(), null, null);
            if (lang == null) {
                throw new IOException("Could not determing RDF format from dataset URI: " + uri.toString());
            }
            org.apache.jena.query.Dataset dataset = DatasetFactory.create();
            if (log.isDebugEnabled()) {
                log.debug("Loading Model from dataset: {}", (Object)uri);
            }
            RDFDataMgr.read((org.apache.jena.query.Dataset)dataset, (InputStream)datasetStream, (String)baseURI, (Lang)lang);
            org.apache.jena.query.Dataset dataset2 = dataset;
            return dataset2;
        }
    }

    public final Model getModel(org.apache.jena.query.Dataset dataset, Query query) {
        if (dataset == null) {
            throw new IllegalArgumentException("Dataset cannot be null");
        }
        if (query == null) {
            throw new IllegalArgumentException("Query cannot be null");
        }
        try (QueryExecution qex = QueryExecution.create((Query)query, (org.apache.jena.query.Dataset)dataset);){
            if (query.isDescribeType()) {
                Model model = qex.execDescribe();
                return model;
            }
            if (query.isConstructType()) {
                Model model = qex.execConstruct();
                return model;
            }
            throw new IllegalStateException("Query is not DESCRIBE or CONSTRUCT");
        }
    }

    @Subscribe
    public void handleSignUp(SignUp event) {
        this.getWebIDModelCache().remove((Object)event.getSecretaryWebID());
    }

    @Subscribe
    public void handleAuthorizationCreated(AuthorizationCreated event) throws MessagingException, UnsupportedEncodingException {
        String emailSubject = this.servletConfig.getServletContext().getInitParameter(LDHC.authorizationEMailSubject.getURI());
        if (emailSubject == null) {
            throw new InternalServerErrorException((Throwable)new ConfigurationException((Property)LDHC.authorizationEMailSubject));
        }
        String emailText = this.servletConfig.getServletContext().getInitParameter(LDHC.authorizationEMailText.getURI());
        if (emailText == null) {
            throw new InternalServerErrorException((Throwable)new ConfigurationException((Property)LDHC.authorizationEMailText));
        }
        Resource owner = event.getApplication().getMaker();
        Resource auth = event.getAuthorization();
        if (auth.hasProperty((Property)ACL.agent)) {
            Object name;
            Resource agent = auth.getPropertyResourceValue((Property)ACL.agent);
            Model agentModel = event.getLinkedDataClient().getModel(agent.getURI());
            if (!agentModel.containsResource((RDFNode)agent)) {
                throw new IllegalStateException("Could not load agent's <" + agent.getURI() + "> description");
            }
            if ((agent = agentModel.getResource(agent.getURI())).hasProperty((Property)FOAF.givenName) && agent.hasProperty((Property)FOAF.familyName)) {
                String givenName = agent.getProperty((Property)FOAF.givenName).getString();
                String familyName = agent.getProperty((Property)FOAF.familyName).getString();
                name = givenName + " " + familyName;
            } else if (agent.hasProperty((Property)FOAF.name)) {
                name = agent.getProperty((Property)FOAF.name).getString();
            } else {
                throw new IllegalStateException("Agent '" + agent + "' does not have either foaf:givenName/foaf:familyName or foaf:name");
            }
            String mbox = agent.getRequiredProperty((Property)FOAF.mbox).getResource().getURI().substring("mailto:".length());
            String accessToList = auth.listProperties((Property)ACL.accessTo).toList().stream().map(stmt -> stmt.getResource().getURI()).collect(Collectors.joining("\n"));
            String accessToClassList = auth.listProperties((Property)ACL.accessToClass).toList().stream().map(stmt -> stmt.getResource().getURI()).collect(Collectors.joining("\n"));
            MessageBuilder builder = this.getMessageBuilder().subject(String.format(emailSubject, event.getApplication().getProperty(DCTerms.title).getString())).to(mbox, (String)name).textBodyPart(String.format(emailText, owner.getURI(), accessToList, accessToClassList, event.getApplication().getBaseURI()));
            if (this.getNotificationAddress() != null) {
                builder = builder.from(this.getNotificationAddress());
            }
            EMailListener.submit((Message)builder.build());
        }
    }

    public Resource matchApp(Resource type, URI absolutePath) {
        return this.matchApp(this.getContextModel(), type, absolutePath);
    }

    public Resource matchApp(Model appModel, Resource type, URI absolutePath) {
        return this.getLongestURIResource(this.getLengthMap(this.getRelativeBaseApps(appModel, type, absolutePath)));
    }

    public Resource getLongestURIResource(Map<Integer, Resource> lengthMap) {
        TreeMap<Integer, Resource> apps = new TreeMap<Integer, Resource>(lengthMap);
        if (!apps.isEmpty()) {
            return apps.lastEntry().getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<URI, Resource> getRelativeBaseApps(Model model, Resource type, URI absolutePath) {
        if (model == null) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        if (absolutePath == null) {
            throw new IllegalArgumentException("URI cannot be null");
        }
        HashMap<URI, Resource> apps = new HashMap<URI, Resource>();
        try (ResIterator it = model.listSubjectsWithProperty(RDF.type, (RDFNode)type);){
            while (it.hasNext()) {
                Resource app = (Resource)it.next();
                if (!app.hasProperty((Property)LDT.base)) {
                    throw new InternalServerErrorException((Throwable)new IllegalStateException("Application resource <" + app.getURI() + "> has no ldt:base value"));
                }
                URI base = URI.create(app.getPropertyResourceValue((Property)LDT.base).getURI());
                URI relative = base.relativize(absolutePath);
                if (relative.isAbsolute()) continue;
                apps.put(base, app);
            }
        }
        return apps;
    }

    public Resource matchDataset(Resource type, URI absolutePath) {
        return this.matchDataset(this.getContextModel(), type, absolutePath);
    }

    public Resource matchDataset(Model appModel, Resource type, URI absolutePath) {
        return this.getLongestURIResource(this.getLengthMap(this.getRelativeDatasets(appModel, type, absolutePath)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<URI, Resource> getRelativeDatasets(Model model, Resource type, URI absolutePath) {
        if (model == null) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        if (absolutePath == null) {
            throw new IllegalArgumentException("URI cannot be null");
        }
        HashMap<URI, Resource> datasets = new HashMap<URI, Resource>();
        try (ResIterator it = model.listSubjectsWithProperty(RDF.type, (RDFNode)type);){
            while (it.hasNext()) {
                Resource dataset = (Resource)it.next();
                if (!dataset.hasProperty((Property)LAPP.prefix)) {
                    throw new InternalServerErrorException((Throwable)new IllegalStateException("Dataset resource <" + dataset.getURI() + "> has no lapp:prefix value"));
                }
                URI prefix = URI.create(dataset.getPropertyResourceValue((Property)LAPP.prefix).getURI());
                URI relative = prefix.relativize(absolutePath);
                if (relative.isAbsolute() || relative.toString().equals("")) continue;
                datasets.put(prefix, dataset);
            }
        }
        return datasets;
    }

    public Map<Integer, Resource> getLengthMap(Map<URI, Resource> apps) {
        if (apps == null) {
            throw new IllegalArgumentException("Map cannot be null");
        }
        HashMap<Integer, Resource> lengthMap = new HashMap<Integer, Resource>();
        apps.entrySet().iterator().forEachRemaining(entry -> lengthMap.put(((URI)entry.getKey()).toString().length(), (Resource)entry.getValue()));
        return lengthMap;
    }

    public void submitImport(CSVImport csvImport, com.atomgraph.linkeddatahub.apps.model.Application app, Service service, Service adminService, String baseURI, LinkedDataClient ldc) {
        new ImportExecutor(this.importThreadPool).start(service, adminService, baseURI, ldc, service.getGraphStoreClient(), GraphStoreImpl.CREATE_GRAPH, csvImport);
    }

    public void submitImport(RDFImport rdfImport, com.atomgraph.linkeddatahub.apps.model.Application app, Service service, Service adminService, String baseURI, LinkedDataClient ldc) {
        new ImportExecutor(this.importThreadPool).start(service, adminService, baseURI, ldc, service.getGraphStoreClient(), rdfImport);
    }

    public static Client getClient(KeyStore keyStore, String keyStorePassword, KeyStore trustStore, Integer maxConnPerRoute, Integer maxTotalConn, ConnectionKeepAliveStrategy keepAliveStrategy) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, KeyManagementException {
        if (keyStore == null) {
            throw new IllegalArgumentException("KeyStore cannot be null");
        }
        if (keyStorePassword == null) {
            throw new IllegalArgumentException("KeyStore password string cannot be null");
        }
        if (trustStore == null) {
            throw new IllegalArgumentException("KeyStore (truststore) cannot be null");
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, keyStorePassword.toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustStore);
        SSLContext ctx = SSLContext.getInstance("SSL");
        ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)new SSLConnectionSocketFactory(ctx, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).register("http", (Object)new PlainConnectionSocketFactory()).build();
        14 conman = new /* Unavailable Anonymous Inner Class!! */;
        if (maxConnPerRoute != null) {
            conman.setDefaultMaxPerRoute(maxConnPerRoute.intValue());
        }
        if (maxTotalConn != null) {
            conman.setMaxTotal(maxTotalConn.intValue());
        }
        ClientConfig config = new ClientConfig();
        config.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
        config.register(MultiPartFeature.class);
        config.register((Object)new ModelProvider());
        config.register((Object)new DatasetProvider());
        config.register((Object)new ResultSetProvider());
        config.register((Object)new QueryProvider());
        config.register((Object)new UpdateRequestProvider());
        config.property("jersey.config.client.followRedirects", (Object)true);
        config.property("jersey.config.apache.client.connectionManager", (Object)conman);
        if (keepAliveStrategy != null) {
            config.property("jersey.config.apache.client.keepAliveStrategy", (Object)keepAliveStrategy);
        }
        return ClientBuilder.newBuilder().withConfig((Configuration)config).sslContext(ctx).hostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
    }

    public static Client getNoCertClient(KeyStore trustStore, Integer maxConnPerRoute, Integer maxTotalConn) {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(null, tmf.getTrustManagers(), null);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)new SSLConnectionSocketFactory(ctx, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).register("http", (Object)new PlainConnectionSocketFactory()).build();
            15 conman = new /* Unavailable Anonymous Inner Class!! */;
            if (maxConnPerRoute != null) {
                conman.setDefaultMaxPerRoute(maxConnPerRoute.intValue());
            }
            if (maxTotalConn != null) {
                conman.setMaxTotal(maxTotalConn.intValue());
            }
            ClientConfig config = new ClientConfig();
            config.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
            config.register(MultiPartFeature.class);
            config.register((Object)new ModelProvider());
            config.register((Object)new DatasetProvider());
            config.register((Object)new ResultSetProvider());
            config.register((Object)new QueryProvider());
            config.register((Object)new UpdateRequestProvider());
            config.property("jersey.config.client.followRedirects", (Object)true);
            config.property("jersey.config.apache.client.connectionManager", (Object)conman);
            return ClientBuilder.newBuilder().withConfig((Configuration)config).sslContext(ctx).hostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
        }
        catch (NoSuchAlgorithmException ex) {
            if (log.isErrorEnabled()) {
                log.error("No such algorithm: {}", (Throwable)ex);
            }
            throw new IllegalStateException(ex);
        }
        catch (KeyStoreException ex) {
            if (log.isErrorEnabled()) {
                log.error("Key store error: {}", (Throwable)ex);
            }
            throw new IllegalStateException(ex);
        }
        catch (KeyManagementException ex) {
            if (log.isErrorEnabled()) {
                log.error("Key management error: {}", (Throwable)ex);
            }
            throw new IllegalStateException(ex);
        }
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    protected Map<String, OntModelSpec> getEndUserOntModelSpecs() {
        return this.endUserOntModelSpecs;
    }

    public OntModelSpec getOntModelSpec(EndUserApplication app) {
        if (!this.getEndUserOntModelSpecs().containsKey(app.getURI())) {
            OntModelSpec appOntModelSpec = new OntModelSpec(OntModelSpec.OWL_MEM_RDFS_INF);
            appOntModelSpec.setDocumentManager(new OntDocumentManager());
            appOntModelSpec.getDocumentManager().setFileManager((FileManager)new DataManagerImpl(LocationMapper.get(), new HashMap(), LinkedDataClient.create((Client)this.getClient(), (com.atomgraph.core.MediaTypes)this.getMediaTypes()), true, this.isPreemptiveAuth(), this.isResolvingUncached()));
            this.getEndUserOntModelSpecs().put(app.getURI(), appOntModelSpec);
        }
        return (OntModelSpec)this.getEndUserOntModelSpecs().get(app.getURI());
    }

    public MediaTypes getMediaTypes() {
        return this.mediaTypes;
    }

    public Client getClient() {
        return this.client;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public URI getSecretaryWebIDURI() {
        return this.secretaryWebIDURI;
    }

    public Query getAuthQuery() {
        return this.authQuery.cloneQuery();
    }

    public Query getOwnerAuthQuery() {
        return this.ownerAuthQuery.cloneQuery();
    }

    public Query getWebIDQuery() {
        return this.webIDQuery.cloneQuery();
    }

    public Query getAgentQuery() {
        return this.agentQuery.cloneQuery();
    }

    public Query getUserAccountQuery() {
        return this.userAccountQuery.cloneQuery();
    }

    public Query getOntologyQuery() {
        return this.ontologyQuery.cloneQuery();
    }

    public Integer getMaxGetRequestSize() {
        return this.maxGetRequestSize;
    }

    public boolean isPreemptiveAuth() {
        return this.preemptiveAuth;
    }

    public OntModelSpec getOntModelSpec() {
        return this.ontModelSpec;
    }

    public XsltCompiler getXsltCompiler() {
        return this.xsltComp;
    }

    public XsltExecutable getXsltExecutable() {
        return this.xsltExec;
    }

    public boolean isCacheStylesheet() {
        return this.cacheStylesheet;
    }

    public boolean isResolvingUncached() {
        return this.resolvingUncached;
    }

    public URI getUploadRoot() {
        return this.uploadRoot;
    }

    protected org.apache.jena.query.Dataset getContextDataset() {
        return this.contextDataset;
    }

    public Model getContextModel() {
        return ModelFactory.createModelForGraph((Graph)new GraphReadOnly(this.getContextDataset().getDefaultModel().getGraph()));
    }

    public boolean isInvalidateCache() {
        return this.invalidateCache;
    }

    public Integer getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    public boolean isEnableLinkedDataProxy() {
        return this.enableLinkedDataProxy;
    }

    public Integer getMaxContentLength() {
        return this.maxContentLength;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public Client getImportClient() {
        return this.importClient;
    }

    public Client getNoCertClient() {
        return this.noCertClient;
    }

    public Address getNotificationAddress() {
        return this.notificationAddress;
    }

    public final MessageBuilder getMessageBuilder() {
        if (this.authenticator != null) {
            return MessageBuilder.fromPropertiesAndAuth((Properties)this.emailProperties, (Authenticator)this.authenticator);
        }
        return MessageBuilder.fromProperties((Properties)this.emailProperties);
    }

    public ExpiringMap<URI, Model> getWebIDModelCache() {
        return this.webIDmodelCache;
    }

    public ExpiringMap<String, Model> getOIDCModelCache() {
        return this.oidcModelCache;
    }

    public Map<URI, XsltExecutable> getXsltExecutableCache() {
        return this.xsltExecutableCache;
    }

    public MessageDigest getMessageDigest() {
        return this.messageDigest;
    }

    public List<Locale> getSupportedLanguages() {
        return this.supportedLanguages;
    }

    public boolean isEnableWebIDSignUp() {
        return this.enableWebIDSignUp;
    }

    public String getRefreshToken(String clientID) {
        return this.oidcRefreshTokens.getProperty(clientID);
    }

    public void storeRefreshToken(String clientID, String refreshToken) throws IOException {
        this.oidcRefreshTokens.put(clientID, refreshToken);
        try (FileOutputStream fos = new FileOutputStream(this.oidcRefreshTokensPropertiesPath);){
            this.oidcRefreshTokens.store(fos, null);
        }
    }
}

