/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.client;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.linkeddatahub.client.filter.auth.IDTokenDelegationFilter;
import com.atomgraph.linkeddatahub.client.filter.auth.WebIDDelegationFilter;
import com.atomgraph.linkeddatahub.server.security.AgentContext;
import com.atomgraph.linkeddatahub.server.security.IDTokenSecurityContext;
import com.atomgraph.linkeddatahub.server.security.WebIDSecurityContext;
import java.net.URI;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import org.apache.jena.rdf.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedDataClient
extends com.atomgraph.core.client.LinkedDataClient {
    private static final Logger log = LoggerFactory.getLogger(LinkedDataClient.class);
    private URI baseURI;
    private AgentContext agentContext;

    protected LinkedDataClient(Client client, MediaTypes mediaTypes) {
        super(client, mediaTypes);
    }

    public static LinkedDataClient create(Client client, MediaTypes mediaTypes) {
        return new LinkedDataClient(client, mediaTypes);
    }

    public LinkedDataClient delegation(URI baseURI, AgentContext agentContext) {
        this.baseURI = baseURI;
        this.agentContext = agentContext;
        return this;
    }

    protected WebTarget getWebTarget(URI uri) {
        WebTarget webTarget = super.getWebTarget(uri);
        if (this.getAgentContext() != null) {
            AgentContext agentContext = this.getAgentContext();
            if (agentContext instanceof WebIDSecurityContext) {
                WebIDSecurityContext webIDSecurityContext = (WebIDSecurityContext)agentContext;
                if (log.isDebugEnabled()) {
                    log.debug("Delegating Agent's <{}> access to secretary", (Object)webIDSecurityContext.getAgent());
                }
                webTarget.register((Object)new WebIDDelegationFilter((Resource)webIDSecurityContext.getAgent()));
            }
            if ((agentContext = this.getAgentContext()) instanceof IDTokenSecurityContext) {
                IDTokenSecurityContext iDTokenSecurityContext;
                IDTokenSecurityContext idTokenContext = iDTokenSecurityContext = (IDTokenSecurityContext)agentContext;
                webTarget.register((Object)new IDTokenDelegationFilter((Resource)idTokenContext.getAgent(), idTokenContext.getJWTToken(), this.getBaseURI().getPath(), null));
            }
        }
        return webTarget;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public AgentContext getAgentContext() {
        return this.agentContext;
    }
}

