/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.client.filter;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUriRewriteFilter
implements ClientRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(ClientUriRewriteFilter.class);
    private final URI baseURI;
    private final String scheme;
    private final String hostname;
    private final Integer port;

    public ClientUriRewriteFilter(URI baseURI, String scheme, String hostname, Integer port) {
        this.baseURI = baseURI;
        this.scheme = scheme;
        this.hostname = hostname;
        this.port = port;
    }

    public void filter(ClientRequestContext cr) throws IOException {
        if (this.getBaseURI().relativize(cr.getUri()).isAbsolute()) {
            return;
        }
        try {
            String newScheme = cr.getUri().getScheme();
            if (this.getScheme() != null) {
                newScheme = this.getScheme();
            }
            URI newUri = new URI(newScheme, cr.getUri().getUserInfo(), this.getHostname(), this.getPort(), cr.getUri().getPath(), cr.getUri().getQuery(), cr.getUri().getFragment());
            if (log.isDebugEnabled()) {
                log.debug("Rewriting client request URI from '{}' to '{}'", (Object)cr.getUri(), (Object)newUri);
            }
            cr.setUri(newUri);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getPort() {
        return this.port;
    }
}

