/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.client.filter.auth;

import java.io.IOException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Cookie;
import org.apache.jena.rdf.model.Resource;

public class IDTokenDelegationFilter
implements ClientRequestFilter {
    private final Resource agent;
    private final String jwtToken;
    private final String path;
    private final String domain;

    public IDTokenDelegationFilter(Resource agent, String jwtToken, String path, String domain) {
        this.agent = agent;
        this.jwtToken = jwtToken;
        this.path = path;
        this.domain = domain;
    }

    public void filter(ClientRequestContext cr) throws IOException {
        Cookie jwtCookie = new Cookie("LinkedDataHub.id_token", this.getJwtToken(), this.getPath(), this.getDomain());
        cr.getHeaders().add((Object)"Cookie", (Object)jwtCookie.toString());
        cr.getHeaders().add((Object)"On-Behalf-Of", (Object)this.getAgent().getURI());
    }

    public Resource getAgent() {
        return this.agent;
    }

    public String getJwtToken() {
        return this.jwtToken;
    }

    public String getPath() {
        return this.path;
    }

    public String getDomain() {
        return this.domain;
    }
}

