/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.imports;

import com.atomgraph.client.MediaTypes;
import com.atomgraph.client.vocabulary.LDT;
import com.atomgraph.core.client.GraphStoreClient;
import com.atomgraph.core.client.LinkedDataClient;
import com.atomgraph.core.model.DatasetAccessor;
import com.atomgraph.linkeddatahub.imports.QueryLoader;
import com.atomgraph.linkeddatahub.imports.stream.RDFGraphStoreOutput;
import com.atomgraph.linkeddatahub.imports.stream.StreamRDFOutputWriter;
import com.atomgraph.linkeddatahub.imports.stream.csv.CSVGraphStoreOutput;
import com.atomgraph.linkeddatahub.imports.stream.csv.CSVGraphStoreOutputWriter;
import com.atomgraph.linkeddatahub.imports.stream.csv.ClientResponseSupplier;
import com.atomgraph.linkeddatahub.model.CSVImport;
import com.atomgraph.linkeddatahub.model.Import;
import com.atomgraph.linkeddatahub.model.RDFImport;
import com.atomgraph.linkeddatahub.model.Service;
import com.atomgraph.linkeddatahub.server.util.Skolemizer;
import com.atomgraph.linkeddatahub.vocabulary.PROV;
import com.atomgraph.linkeddatahub.vocabulary.VoID;
import java.net.URI;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportExecutor {
    private static final Logger log = LoggerFactory.getLogger(ImportExecutor.class);
    public static final MediaType TEXT_CSV_TYPE = MediaType.valueOf((String)"text/csv");
    public static final MediaType VNDMS_EXCEL_TYPE = MediaType.valueOf((String)"application/vnd.ms-excel; q=0.4");
    public static final MediaType OCTET_STREAM_TYPE = MediaType.valueOf((String)"application/octet-stream; q=0.1");
    public static final MediaType[] CSV_MEDIA_TYPES = new MediaType[]{TEXT_CSV_TYPE, VNDMS_EXCEL_TYPE, OCTET_STREAM_TYPE};
    public static final MediaType[] RDF_MEDIA_TYPES = (MediaType[])Stream.concat(((List)MediaTypes.READABLE.get(Model.class)).stream(), ((List)MediaTypes.READABLE.get(Dataset.class)).stream()).collect(Collectors.toList()).toArray(MediaType[]::new);
    private final ExecutorService execService;

    public ImportExecutor(ExecutorService execService) {
        this.execService = execService;
    }

    public void start(Service service, Service adminService, String appBaseURI, LinkedDataClient ldc, GraphStoreClient graphStoreClient, Function<Model, Resource> createGraph, CSVImport csvImport) {
        if (csvImport == null) {
            throw new IllegalArgumentException("CSVImport cannot be null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Submitting new import to thread pool: {}", (Object)csvImport.toString());
        }
        Resource provImport = ModelFactory.createDefaultModel().createResource(csvImport.getURI()).addProperty((Property)PROV.startedAtTime, (RDFNode)csvImport.getModel().createTypedLiteral(Calendar.getInstance()));
        String queryBaseURI = csvImport.getFile().getURI();
        QueryLoader queryLoader = new QueryLoader(URI.create(csvImport.getQuery().getURI()), queryBaseURI, Syntax.syntaxARQ, ldc);
        ParameterizedSparqlString pss = new ParameterizedSparqlString(queryLoader.get().toString(), queryBaseURI);
        pss.setIri(LDT.base.getLocalName(), appBaseURI);
        Query query = pss.asQuery();
        ClientResponseSupplier fileSupplier = new ClientResponseSupplier(ldc, CSV_MEDIA_TYPES, URI.create(csvImport.getFile().getURI()));
        ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(fileSupplier, this.getExecutorService()).thenApplyAsync(this.getStreamRDFOutputWriter(service, adminService, graphStoreClient, queryBaseURI, query, createGraph, csvImport), (Executor)this.getExecutorService())).thenAcceptAsync(this.success(service, csvImport, provImport), (Executor)this.getExecutorService())).exceptionally(this.failure(service, (Import)csvImport, provImport));
    }

    public void start(Service service, Service adminService, String appBaseURI, LinkedDataClient ldc, GraphStoreClient graphStoreClient, RDFImport rdfImport) {
        Query query;
        if (rdfImport == null) {
            throw new IllegalArgumentException("RDFImport cannot be null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Submitting new import to thread pool: {}", (Object)rdfImport.toString());
        }
        Resource provImport = ModelFactory.createDefaultModel().createResource(rdfImport.getURI()).addProperty((Property)PROV.startedAtTime, (RDFNode)rdfImport.getModel().createTypedLiteral(Calendar.getInstance()));
        String queryBaseURI = rdfImport.getFile().getURI();
        if (rdfImport.getQuery() != null) {
            QueryLoader queryLoader = new QueryLoader(URI.create(rdfImport.getQuery().getURI()), queryBaseURI, Syntax.syntaxARQ, ldc);
            ParameterizedSparqlString pss = new ParameterizedSparqlString(queryLoader.get().toString(), queryBaseURI);
            pss.setIri(LDT.base.getLocalName(), appBaseURI);
            query = pss.asQuery();
        } else {
            query = null;
        }
        ClientResponseSupplier fileSupplier = new ClientResponseSupplier(ldc, RDF_MEDIA_TYPES, URI.create(rdfImport.getFile().getURI()));
        ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(fileSupplier, this.getExecutorService()).thenApplyAsync(this.getStreamRDFOutputWriter(service, adminService, graphStoreClient, queryBaseURI, query, rdfImport), (Executor)this.getExecutorService())).thenAcceptAsync(this.success(service, rdfImport, provImport), (Executor)this.getExecutorService())).exceptionally(this.failure(service, (Import)rdfImport, provImport));
    }

    protected Consumer<CSVGraphStoreOutput> success(Service service, CSVImport csvImport, Resource provImport) {
        return output -> {
            Resource dataset = provImport.getModel().createResource().addProperty(RDF.type, (RDFNode)VoID.Dataset).addLiteral((Property)VoID.distinctSubjects, (long)output.getCSVGraphStoreRowProcessor().getSubjectCount()).addLiteral((Property)VoID.triples, (long)output.getCSVGraphStoreRowProcessor().getTripleCount()).addProperty((Property)PROV.wasGeneratedBy, (RDFNode)provImport);
            provImport.addProperty((Property)PROV.endedAtTime, (RDFNode)provImport.getModel().createTypedLiteral(Calendar.getInstance()));
            this.appendProvGraph(provImport, service.getDatasetAccessor());
        };
    }

    protected Consumer<RDFGraphStoreOutput> success(Service service, RDFImport rdfImport, Resource provImport) {
        return output -> {
            Resource dataset = provImport.getModel().createResource().addProperty(RDF.type, (RDFNode)VoID.Dataset).addProperty((Property)PROV.wasGeneratedBy, (RDFNode)provImport);
            provImport.addProperty((Property)PROV.endedAtTime, (RDFNode)provImport.getModel().createTypedLiteral(Calendar.getInstance()));
            this.appendProvGraph(provImport, service.getDatasetAccessor());
        };
    }

    protected Function<Throwable, Void> failure(Service service, Import importInst, Resource provImport) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void appendProvGraph(Resource provImport, DatasetAccessor accessor) {
        URI graphURI = UriBuilder.fromUri((String)provImport.getURI()).fragment(null).build(new Object[0]);
        if (log.isDebugEnabled()) {
            log.debug("Appending import metadata to graph: {}", (Object)graphURI);
        }
        new Skolemizer(graphURI.toString()).apply(provImport.getModel());
        accessor.add(graphURI.toString(), provImport.getModel());
    }

    protected Function<Response, CSVGraphStoreOutput> getStreamRDFOutputWriter(Service service, Service adminService, GraphStoreClient graphStoreClient, String baseURI, Query query, Function<Model, Resource> createGraph, CSVImport imp) {
        return new CSVGraphStoreOutputWriter(service, adminService, graphStoreClient, baseURI, query, createGraph, imp.getDelimiter());
    }

    protected Function<Response, RDFGraphStoreOutput> getStreamRDFOutputWriter(Service service, Service adminService, GraphStoreClient graphStoreClient, String baseURI, Query query, RDFImport imp) {
        return new StreamRDFOutputWriter(service, adminService, graphStoreClient, baseURI, query, imp.getGraphName() != null ? imp.getGraphName().getURI() : null);
    }

    protected ExecutorService getExecutorService() {
        return this.execService;
    }
}

