/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.imports;

import com.atomgraph.core.client.LinkedDataClient;
import com.atomgraph.spinrdf.vocabulary.SP;
import java.net.URI;
import java.util.function.Supplier;
import javax.ws.rs.core.Response;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;

public class QueryLoader
implements Supplier<Query> {
    private final URI uri;
    private final String baseURI;
    private final Syntax syntax;
    private final LinkedDataClient ldc;

    public QueryLoader(URI uri, String baseURI, LinkedDataClient ldc) {
        this(uri, baseURI, Syntax.syntaxSPARQL_11, ldc);
    }

    public QueryLoader(URI uri, String baseURI, Syntax syntax, LinkedDataClient ldc) {
        this.uri = uri;
        this.baseURI = baseURI;
        this.syntax = syntax;
        this.ldc = ldc;
    }

    @Override
    public Query get() {
        try (Response cr = this.getLinkedDataClient().get(this.getURI());){
            Resource queryRes = ((Model)cr.readEntity(Model.class)).getResource(this.getURI().toString());
            Query query = QueryFactory.create((String)queryRes.getRequiredProperty(SP.text).getString(), (String)this.getBaseURI(), (Syntax)this.getSyntax());
            return query;
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public LinkedDataClient getLinkedDataClient() {
        return this.ldc;
    }
}

