/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.imports.stream;

import com.atomgraph.core.client.GraphStoreClient;
import com.atomgraph.linkeddatahub.model.Service;
import java.io.InputStream;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.glassfish.jersey.uri.UriComponent;

public class RDFGraphStoreOutput {
    private final Service service;
    private final Service adminService;
    private final GraphStoreClient graphStoreClient;
    private final String base;
    private final InputStream is;
    private final Query query;
    private final Lang lang;
    private final String graphURI;

    public RDFGraphStoreOutput(Service service, Service adminService, GraphStoreClient graphStoreClient, InputStream is, String base, Query query, Lang lang, String graphURI) {
        this.service = service;
        this.adminService = adminService;
        this.graphStoreClient = graphStoreClient;
        this.is = is;
        this.base = base;
        this.query = query;
        this.lang = lang;
        this.graphURI = graphURI;
    }

    public void write() {
        Model model = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)model, (InputStream)this.getInputStream(), (String)this.getBase(), (Lang)this.getLang());
        if (this.getQuery() != null) {
            try (QueryExecution qex = QueryExecution.create((Query)this.getQuery(), (Model)model);){
                Dataset dataset = qex.execConstructDataset();
                dataset.listNames().forEachRemaining(graphUri -> {
                    if (!dataset.getNamedModel(graphUri).isEmpty()) {
                        this.getGraphStoreClient().add(graphUri, dataset.getNamedModel(graphUri));
                    }
                    if (this.getService().getProxy() != null) {
                        this.ban(this.getService().getClient(), this.getService().getProxy(), graphUri).close();
                    }
                    if (this.getAdminService() != null && this.getAdminService().getProxy() != null) {
                        this.ban(this.getAdminService().getClient(), this.getAdminService().getProxy(), graphUri).close();
                    }
                });
            }
        } else {
            if (this.getGraphURI() == null) {
                throw new IllegalStateException("Neither RDFImport query nor graph name is specified");
            }
            this.getGraphStoreClient().add(this.getGraphURI(), model);
            if (this.getService().getProxy() != null) {
                this.ban(this.getService().getClient(), this.getService().getProxy(), this.getGraphURI()).close();
            }
            if (this.getAdminService() != null && this.getAdminService().getProxy() != null) {
                this.ban(this.getAdminService().getClient(), this.getAdminService().getProxy(), this.getGraphURI()).close();
            }
        }
    }

    public Response ban(Client client, Resource proxy, String url) {
        if (url == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        return (Response)client.target(proxy.getURI()).request().header("X-Escaped-Request-URI", (Object)UriComponent.encode((String)url, (UriComponent.Type)UriComponent.Type.UNRESERVED)).method("BAN", Response.class);
    }

    public Service getService() {
        return this.service;
    }

    public Service getAdminService() {
        return this.adminService;
    }

    public GraphStoreClient getGraphStoreClient() {
        return this.graphStoreClient;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public String getBase() {
        return this.base;
    }

    public Query getQuery() {
        return this.query;
    }

    public Lang getLang() {
        return this.lang;
    }

    public String getGraphURI() {
        return this.graphURI;
    }
}

