/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.imports.stream;

import com.atomgraph.core.MediaType;
import com.atomgraph.core.client.GraphStoreClient;
import com.atomgraph.linkeddatahub.imports.stream.RDFGraphStoreOutput;
import com.atomgraph.linkeddatahub.model.Service;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.function.Function;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.jena.query.Query;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamRDFOutputWriter
implements Function<Response, RDFGraphStoreOutput> {
    private static final Logger log = LoggerFactory.getLogger(StreamRDFOutputWriter.class);
    private final Service service;
    private final Service adminService;
    private final GraphStoreClient graphStoreClient;
    private final String baseURI;
    private final String graphURI;
    private final Query query;

    public StreamRDFOutputWriter(Service service, Service adminService, GraphStoreClient graphStoreClient, String baseURI, Query query, String graphURI) {
        this.service = service;
        this.adminService = adminService;
        this.graphStoreClient = graphStoreClient;
        this.baseURI = baseURI;
        this.query = query;
        this.graphURI = graphURI;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public RDFGraphStoreOutput apply(Response rdfInput) {
        if (rdfInput == null) {
            throw new IllegalArgumentException("Response cannot be null");
        }
        try {
            File tempFile = File.createTempFile(UUID.randomUUID().toString(), "tmp");
            try (Response response = rdfInput;
                 InputStream rdfIs = (InputStream)rdfInput.readEntity(InputStream.class);
                 FileOutputStream output = new FileOutputStream(tempFile);){
                rdfIs.transferTo(output);
            }
            try {
                RDFGraphStoreOutput rDFGraphStoreOutput;
                try (FileInputStream fis = new FileInputStream(tempFile);){
                    MediaType mediaType = new MediaType(rdfInput.getMediaType().getType(), rdfInput.getMediaType().getSubtype());
                    Lang lang = RDFLanguages.contentTypeToLang((String)mediaType.toString());
                    if (lang == null) {
                        throw new BadRequestException("Content type '" + mediaType + "' is not an RDF media type");
                    }
                    RDFGraphStoreOutput output = new RDFGraphStoreOutput(this.getService(), this.getAdminService(), this.getGraphStoreClient(), (InputStream)fis, this.getBaseURI(), this.getQuery(), lang, this.getGraphURI());
                    output.write();
                    rDFGraphStoreOutput = output;
                }
                return rDFGraphStoreOutput;
            }
            finally {
                tempFile.delete();
            }
        }
        catch (IOException ex) {
            if (log.isErrorEnabled()) {
                log.error("Error reading RDF InputStream: {}", (Throwable)ex);
            }
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public Service getService() {
        return this.service;
    }

    public Service getAdminService() {
        return this.adminService;
    }

    public GraphStoreClient getGraphStoreClient() {
        return this.graphStoreClient;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public Query getQuery() {
        return this.query;
    }

    public String getGraphURI() {
        return this.graphURI;
    }
}

