/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.imports.stream.csv;

import com.atomgraph.core.client.GraphStoreClient;
import com.atomgraph.linkeddatahub.imports.stream.csv.CSVGraphStoreRowProcessor;
import com.atomgraph.linkeddatahub.model.Service;
import com.univocity.parsers.common.processor.core.Processor;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.Reader;
import java.util.function.Function;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;

public class CSVGraphStoreOutput {
    private final String base;
    private final Reader reader;
    private final Query query;
    private final char delimiter;
    private final Integer maxCharsPerColumn;
    private final CSVGraphStoreRowProcessor processor;
    private final CsvParser parser;

    public CSVGraphStoreOutput(Service service, Service adminService, GraphStoreClient graphStoreClient, Reader reader, String base, Query query, Function<Model, Resource> createGraph, char delimiter, Integer maxCharsPerColumn) {
        this.base = base;
        this.reader = reader;
        this.query = query;
        this.delimiter = delimiter;
        this.maxCharsPerColumn = maxCharsPerColumn;
        this.processor = new CSVGraphStoreRowProcessor(service, adminService, graphStoreClient, base, query, createGraph);
        CsvParserSettings parserSettings = new CsvParserSettings();
        parserSettings.setLineSeparatorDetectionEnabled(true);
        parserSettings.setProcessor((Processor)this.processor);
        parserSettings.setHeaderExtractionEnabled(true);
        ((CsvFormat)parserSettings.getFormat()).setDelimiter(delimiter);
        if (maxCharsPerColumn != null) {
            parserSettings.setMaxCharsPerColumn(maxCharsPerColumn.intValue());
        }
        this.parser = new CsvParser(parserSettings);
    }

    public void write() {
        this.getCsvParser().parse(this.getReader());
    }

    public CsvParser getCsvParser() {
        return this.parser;
    }

    public Reader getReader() {
        return this.reader;
    }

    public String getBase() {
        return this.base;
    }

    public Query getQuery() {
        return this.query;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public Integer getMaxCharsPerColumn() {
        return this.maxCharsPerColumn;
    }

    public CSVGraphStoreRowProcessor getCSVGraphStoreRowProcessor() {
        return this.processor;
    }
}

