/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.imports.stream.csv;

import com.atomgraph.core.client.GraphStoreClient;
import com.atomgraph.linkeddatahub.model.Service;
import com.atomgraph.linkeddatahub.server.util.Skolemizer;
import com.univocity.parsers.common.ParsingContext;
import com.univocity.parsers.common.processor.RowProcessor;
import java.util.function.Function;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.glassfish.jersey.uri.UriComponent;

public class CSVGraphStoreRowProcessor
implements RowProcessor {
    private final Service service;
    private final Service adminService;
    private final GraphStoreClient graphStoreClient;
    private final String base;
    private final Query query;
    private final Function<Model, Resource> createGraph;
    private int subjectCount;
    private int tripleCount;

    public CSVGraphStoreRowProcessor(Service service, Service adminService, GraphStoreClient graphStoreClient, String base, Query query, Function<Model, Resource> createGraph) {
        this.service = service;
        this.adminService = adminService;
        this.graphStoreClient = graphStoreClient;
        this.base = base;
        this.query = query;
        this.createGraph = createGraph;
    }

    public void processStarted(ParsingContext context) {
        this.tripleCount = 0;
        this.subjectCount = 0;
    }

    public void rowProcessed(String[] row, ParsingContext context) {
        Dataset rowDataset = this.transformRow(row, context);
        if (!rowDataset.getDefaultModel().isEmpty()) {
            String graphUri2 = ((Resource)this.getCreateGraph().apply(rowDataset.getDefaultModel())).getURI();
            new Skolemizer(graphUri2).apply(rowDataset.getDefaultModel());
            this.getGraphStoreClient().add(graphUri2, rowDataset.getDefaultModel());
            if (this.getService().getProxy() != null) {
                this.ban(this.getService().getClient(), this.getService().getProxy(), graphUri2).close();
            }
            if (this.getAdminService() != null && this.getAdminService().getProxy() != null) {
                this.ban(this.getAdminService().getClient(), this.getAdminService().getProxy(), graphUri2).close();
            }
        }
        rowDataset.listNames().forEachRemaining(graphUri -> {
            if (!rowDataset.getNamedModel(graphUri).isEmpty()) {
                this.getGraphStoreClient().add(graphUri, rowDataset.getNamedModel(graphUri));
            }
            if (this.getService().getProxy() != null) {
                this.ban(this.getService().getClient(), this.getService().getProxy(), graphUri).close();
            }
            if (this.getAdminService() != null && this.getAdminService().getProxy() != null) {
                this.ban(this.getAdminService().getClient(), this.getAdminService().getProxy(), graphUri).close();
            }
        });
    }

    public Dataset transformRow(String[] row, ParsingContext context) {
        Model rowModel = ModelFactory.createDefaultModel();
        Resource subject = rowModel.createResource();
        ++this.subjectCount;
        int cellNo = 0;
        for (String cell : row) {
            if (cell != null && context.headers()[cellNo] != null) {
                String fragmentId = IRILib.encodeUriComponent((String)context.headers()[cellNo]);
                Property property = rowModel.createProperty(this.getBase(), "#" + fragmentId);
                subject.addProperty(property, cell);
                ++this.tripleCount;
            }
            ++cellNo;
        }
        try (QueryExecution qex = QueryExecution.create((Query)this.getQuery(), (Model)rowModel);){
            Dataset dataset = qex.execConstructDataset();
            return dataset;
        }
    }

    public void processEnded(ParsingContext context) {
    }

    public Response ban(Client client, Resource proxy, String url) {
        if (url == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        return (Response)client.target(proxy.getURI()).request().header("X-Escaped-Request-URI", (Object)UriComponent.encode((String)url, (UriComponent.Type)UriComponent.Type.UNRESERVED)).method("BAN", Response.class);
    }

    public Service getService() {
        return this.service;
    }

    public Service getAdminService() {
        return this.adminService;
    }

    public GraphStoreClient getGraphStoreClient() {
        return this.graphStoreClient;
    }

    public String getBase() {
        return this.base;
    }

    public Query getQuery() {
        return this.query;
    }

    public int getSubjectCount() {
        return this.subjectCount;
    }

    public int getTripleCount() {
        return this.tripleCount;
    }

    public Function<Model, Resource> getCreateGraph() {
        return this.createGraph;
    }
}

