/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.io;

import com.atomgraph.linkeddatahub.io.JsonLDReader;
import com.github.jsonldjava.core.JsonLdOptions;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.ReaderRIOTBase;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.util.FileUtils;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public class HtmlJsonLDReader
extends ReaderRIOTBase {
    private final JsonLDReader jsonLDReader;
    private final JsonLdOptions options;

    public HtmlJsonLDReader(JsonLDReader jsonLDReader) {
        this(jsonLDReader, null);
    }

    public HtmlJsonLDReader(JsonLDReader jsonLDReader, JsonLdOptions options) {
        this.jsonLDReader = jsonLDReader;
        this.options = options;
    }

    public void read(InputStream in, String baseURI, Lang lang, StreamRDF output, Context context) {
        this.read((Reader)FileUtils.asBufferedUTF8((InputStream)in), baseURI, output, context);
    }

    public void read(Reader in, String baseURI, ContentType ct, StreamRDF output, Context context) {
        this.read(in, baseURI, output, context);
    }

    public void read(Reader in, String baseURI, StreamRDF output, Context context) {
        Document html = Parser.htmlParser().parseInput(in, baseURI);
        Elements jsonLdElements = html.selectXpath("/html//script[@type = 'application/ld+json']");
        if (jsonLdElements.isEmpty()) {
            throw new RiotParseException("<script> element with type=\"application/ld+json\" not found", -1L, -1L);
        }
        context.set(JsonLDReader.JSONLD_OPTIONS, (Object)this.getJsonLdOptions());
        jsonLdElements.stream().map(element -> element.data()).forEach(jsonLd -> this.getJsonLDReader().read((Reader)new StringReader((String)jsonLd), baseURI, Lang.JSONLD.getContentType(), output, context));
    }

    public JsonLDReader getJsonLDReader() {
        return this.jsonLDReader;
    }

    public JsonLdOptions getJsonLdOptions() {
        return this.options;
    }
}

