/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.io;

import com.atomgraph.linkeddatahub.io.JsonLDReader;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.JsonLdTripleCallback;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

/*
 * Exception performing whole class analysis ignored.
 */
@Deprecated
public class JsonLDReader
implements ReaderRIOT {
    private static final String SYMBOLS_NS = "http://jena.apache.org/riot/jsonld#";
    public static final Symbol JSONLD_CONTEXT = JsonLDReader.createSymbol((String)"JSONLD_CONTEXT");
    public static final Symbol JSONLD_OPTIONS = JsonLDReader.createSymbol((String)"JSONLD_OPTIONS");
    private ErrorHandler errorHandler = ErrorHandlerFactory.getDefaultErrorHandler();
    private ParserProfile profile;
    public static String LITERAL = "literal";
    public static String BLANK_NODE = "blank node";
    public static String IRI = "IRI";
    private static final String xsdString = XSDDatatype.XSDstring.getURI();

    private static Symbol createSymbol(String localName) {
        return Symbol.create((String)("http://jena.apache.org/riot/jsonld#" + localName));
    }

    public JsonLDReader(Lang lang, ParserProfile profile, ErrorHandler errorHandler) {
        this.profile = profile;
        this.errorHandler = errorHandler;
    }

    public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context) {
        try {
            Object jsonObject = JsonUtils.fromReader((Reader)reader);
            this.readWithJsonLDCtxOptions(jsonObject, baseURI, output, context);
        }
        catch (JsonProcessingException ex) {
            JsonLocation loc = ex.getLocation();
            this.errorHandler.error(ex.getOriginalMessage(), (long)loc.getLineNr(), (long)loc.getColumnNr());
            throw new RiotException(ex.getOriginalMessage());
        }
        catch (IOException e) {
            this.errorHandler.error(e.getMessage(), -1L, -1L);
            IO.exception((IOException)e);
        }
    }

    public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context) {
        try {
            Object jsonObject = JsonUtils.fromInputStream((InputStream)in);
            this.readWithJsonLDCtxOptions(jsonObject, baseURI, output, context);
        }
        catch (JsonProcessingException ex) {
            JsonLocation loc = ex.getLocation();
            this.errorHandler.error(ex.getOriginalMessage(), (long)loc.getLineNr(), (long)loc.getColumnNr());
            throw new RiotException(ex.getOriginalMessage());
        }
        catch (IOException e) {
            this.errorHandler.error(e.getMessage(), -1L, -1L);
            IO.exception((IOException)e);
        }
    }

    private void readWithJsonLDCtxOptions(Object jsonObject, String baseURI, StreamRDF output, Context context) throws JsonParseException, IOException {
        JsonLdOptions options = JsonLDReader.getJsonLdOptions((String)baseURI, (Context)context);
        Object jsonldCtx = JsonLDReader.getJsonLdContext((Context)context);
        if (jsonldCtx != null) {
            if (jsonObject instanceof Map) {
                ((Map)jsonObject).put("@context", jsonldCtx);
            } else {
                this.errorHandler.warning("Unexpected: not a Map; unable to set JsonLD's @context", -1L, -1L);
            }
        }
        this.read$(jsonObject, options, output);
    }

    private void read$(Object jsonObject, JsonLdOptions options, StreamRDF output) {
        output.start();
        try {
            1 callback = new /* Unavailable Anonymous Inner Class!! */;
            JsonLdProcessor.toRDF((Object)jsonObject, (JsonLdTripleCallback)callback, (JsonLdOptions)options);
        }
        catch (JsonLdError e) {
            this.errorHandler.error(e.getMessage(), -1L, -1L);
            throw new RiotException((Throwable)e);
        }
        output.finish();
    }

    private static JsonLdOptions getJsonLdOptions(String baseURI, Context jenaContext) {
        JsonLdOptions opts = null;
        if (jenaContext != null) {
            opts = (JsonLdOptions)jenaContext.get(JSONLD_OPTIONS);
        }
        if (opts == null) {
            opts = JsonLDReader.defaultJsonLdOptions((String)baseURI);
        }
        return opts;
    }

    private static JsonLdOptions defaultJsonLdOptions(String baseURI) {
        JsonLdOptions opts = new JsonLdOptions(baseURI);
        opts.useNamespaces = true;
        return opts;
    }

    private static Object getJsonLdContext(Context jenaContext) throws JsonParseException, IOException {
        Object o;
        Object ctx = null;
        boolean isCtxDefined = false;
        if (jenaContext != null && jenaContext.isDefined(JSONLD_CONTEXT) && (o = jenaContext.get(JSONLD_CONTEXT)) != null) {
            if (o instanceof String) {
                String jsonString = (String)o;
                o = JsonUtils.fromString((String)jsonString);
            }
            ctx = o;
        }
        return ctx;
    }

    private Node createNode(Map<String, Object> tripleMap, String key) {
        Map x = (Map)tripleMap.get(key);
        return this.createNode(x);
    }

    private Node createNode(Map<String, Object> map) {
        String type = (String)map.get("type");
        String lex = (String)map.get("value");
        if (type.equals(IRI)) {
            return this.createURI(lex);
        }
        if (type.equals(BLANK_NODE)) {
            return this.createBlankNode(lex);
        }
        if (type.equals(LITERAL)) {
            String lang = (String)map.get("language");
            String datatype = (String)map.get("datatype");
            if (Objects.equals(xsdString, datatype)) {
                datatype = null;
            }
            if (lang == null && datatype == null) {
                return this.profile.createStringLiteral(lex, -1L, -1L);
            }
            if (lang != null) {
                return this.profile.createLangLiteral(lex, lang, -1L, -1L);
            }
            RDFDatatype dt = NodeFactory.getType((String)datatype);
            return this.profile.createTypedLiteral(lex, dt, -1L, -1L);
        }
        throw new InternalErrorException("Node is not a IRI, bNode or a literal: " + type);
    }

    private Node createBlankNode(String str) {
        if (str.startsWith("_:")) {
            str = str.substring(2);
        }
        return this.profile.createBlankNode(null, str, -1L, -1L);
    }

    private Node createURI(String str) {
        if (str.startsWith("_:")) {
            return this.createBlankNode(str);
        }
        return this.profile.createURI(str, -1L, -1L);
    }
}

