/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.listener;

import com.atomgraph.linkeddatahub.listener.EMailListener;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class EMailListener
implements ServletContextListener {
    private static final int MAX_THREADS = 10;
    private static final ExecutorService THREAD_POOL = Executors.newFixedThreadPool(10);
    private static final Logger log = LoggerFactory.getLogger(EMailListener.class);

    public void contextInitialized(ServletContextEvent sce) {
        if (log.isDebugEnabled()) {
            log.debug("{} initialized with a pool of {} threads", (Object)this.getClass().getName(), (Object)10);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (log.isDebugEnabled()) {
            log.debug("Shutting down {} thread pool", (Object)this.getClass().getName());
        }
        THREAD_POOL.shutdown();
    }

    public static void submit(Message message) {
        CompletableFuture.runAsync((Runnable)new MessageSender(message)).exceptionally(EMailListener.failure((Message)message));
    }

    public static Function<Throwable, Void> failure(Message message) {
        return t -> {
            try {
                if (log.isErrorEnabled()) {
                    log.error("Could not send Message with subject: {} to addresses: {}", (Object)message.getSubject(), (Object)message.getAllRecipients());
                    log.error("Could not send Message", t);
                }
                throw new RuntimeException((Throwable)t);
            }
            catch (MessagingException ex) {
                if (log.isErrorEnabled()) {
                    log.error("Could not send Message properties: {}", (Object)message);
                    log.error("Could not send Message", (Throwable)ex);
                }
                throw new RuntimeException(ex);
            }
        };
    }
}

