/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.model.auth.impl;

import com.atomgraph.linkeddatahub.model.auth.Authorization;
import com.atomgraph.linkeddatahub.vocabulary.ACL;
import java.net.URI;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationImpl
extends ResourceImpl
implements Authorization {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationImpl.class);
    public static Implementation factory = new /* Unavailable Anonymous Inner Class!! */;

    public AuthorizationImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    public Set<Resource> getModes() {
        try (StmtIterator it = this.listProperties((Property)ACL.mode);){
            Set<Resource> set = it.toList().stream().map(stmt -> stmt.getResource()).collect(Collectors.toSet());
            return set;
        }
    }

    public Set<URI> getModeURIs() {
        return this.getModes().stream().map(resource -> URI.create(resource.getURI())).collect(Collectors.toSet());
    }
}

