/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.model.impl;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.core.client.GraphStoreClient;
import com.atomgraph.core.client.QuadStoreClient;
import com.atomgraph.core.client.SPARQLClient;
import com.atomgraph.core.model.DatasetAccessor;
import com.atomgraph.core.model.DatasetQuadAccessor;
import com.atomgraph.core.model.EndpointAccessor;
import com.atomgraph.core.model.impl.remote.DatasetAccessorImpl;
import com.atomgraph.core.model.impl.remote.DatasetQuadAccessorImpl;
import com.atomgraph.core.model.impl.remote.EndpointAccessorImpl;
import com.atomgraph.core.vocabulary.A;
import com.atomgraph.core.vocabulary.SD;
import com.atomgraph.linkeddatahub.model.Service;
import com.atomgraph.linkeddatahub.vocabulary.LAPP;
import java.net.URI;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.UriBuilder;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceImpl
extends ResourceImpl
implements Service {
    private static final Logger log = LoggerFactory.getLogger(ServiceImpl.class);
    private final Client client;
    private final MediaTypes mediaTypes;
    private final Integer maxGetRequestSize;

    public ServiceImpl(Node n, EnhGraph g, Client client, MediaTypes mediaTypes, Integer maxGetRequestSize) {
        super(n, g);
        this.client = client;
        this.mediaTypes = mediaTypes;
        this.maxGetRequestSize = maxGetRequestSize;
    }

    public Resource getSPARQLEndpoint() {
        return this.getPropertyResourceValue((Property)SD.endpoint);
    }

    public Resource getGraphStore() {
        return this.getPropertyResourceValue((Property)A.graphStore);
    }

    public Resource getQuadStore() {
        return this.getPropertyResourceValue((Property)A.quadStore);
    }

    public Resource getProxy() {
        return this.getPropertyResourceValue((Property)LAPP.proxy);
    }

    public String getAuthUser() {
        Statement authUser = this.getProperty((Property)A.authUser);
        if (authUser != null) {
            return authUser.getString();
        }
        return null;
    }

    public String getAuthPwd() {
        Statement authPwd = this.getProperty((Property)A.authPwd);
        if (authPwd != null) {
            return authPwd.getString();
        }
        return null;
    }

    public SPARQLClient getSPARQLClient() {
        return this.getSPARQLClient(this.getClient().target(this.getProxiedURI(URI.create(this.getSPARQLEndpoint().getURI()))));
    }

    public SPARQLClient getSPARQLClient(WebTarget webTarget) {
        SPARQLClient sparqlClient = this.getMaxGetRequestSize() != null ? SPARQLClient.create((MediaTypes)this.getMediaTypes(), (WebTarget)webTarget, (int)this.getMaxGetRequestSize()) : SPARQLClient.create((MediaTypes)this.getMediaTypes(), (WebTarget)webTarget);
        if (this.getAuthUser() != null && this.getAuthPwd() != null) {
            HttpAuthenticationFeature authFeature = HttpAuthenticationFeature.basicBuilder().credentials(this.getAuthUser(), this.getAuthPwd()).build();
            sparqlClient.getEndpoint().register((Object)authFeature);
        }
        return sparqlClient;
    }

    public EndpointAccessor getEndpointAccessor() {
        return new EndpointAccessorImpl(this.getSPARQLClient());
    }

    public GraphStoreClient getGraphStoreClient() {
        return this.getGraphStoreClient(this.getClient().target(this.getProxiedURI(URI.create(this.getGraphStore().getURI()))));
    }

    public GraphStoreClient getGraphStoreClient(WebTarget webTarget) {
        GraphStoreClient graphStoreClient = GraphStoreClient.create((WebTarget)webTarget);
        if (this.getAuthUser() != null && this.getAuthPwd() != null) {
            HttpAuthenticationFeature authFeature = HttpAuthenticationFeature.basicBuilder().credentials(this.getAuthUser(), this.getAuthPwd()).build();
            graphStoreClient.getEndpoint().register((Object)authFeature);
        }
        return graphStoreClient;
    }

    public DatasetAccessor getDatasetAccessor() {
        return new DatasetAccessorImpl(this.getGraphStoreClient());
    }

    public QuadStoreClient getQuadStoreClient() {
        if (this.getQuadStore() != null) {
            return this.getQuadStoreClient(this.getClient().target(this.getProxiedURI(URI.create(this.getQuadStore().getURI()))));
        }
        return null;
    }

    public QuadStoreClient getQuadStoreClient(WebTarget webTarget) {
        QuadStoreClient quadStoreClient = QuadStoreClient.create((WebTarget)webTarget);
        if (this.getAuthUser() != null && this.getAuthPwd() != null) {
            HttpAuthenticationFeature authFeature = HttpAuthenticationFeature.basicBuilder().credentials(this.getAuthUser(), this.getAuthPwd()).build();
            quadStoreClient.getEndpoint().register((Object)authFeature);
        }
        return quadStoreClient;
    }

    public DatasetQuadAccessor getDatasetQuadAccessor() {
        return new DatasetQuadAccessorImpl(this.getQuadStoreClient());
    }

    protected URI getProxiedURI(URI uri) {
        if (this.getProxy() != null) {
            URI proxyURI = URI.create(this.getProxy().getURI());
            return UriBuilder.fromUri((URI)uri).scheme(proxyURI.getScheme()).host(proxyURI.getHost()).port(proxyURI.getPort()).build(new Object[0]);
        }
        return uri;
    }

    public Client getClient() {
        return this.client;
    }

    public MediaTypes getMediaTypes() {
        return this.mediaTypes;
    }

    public Integer getMaxGetRequestSize() {
        return this.maxGetRequestSize;
    }
}

