/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.model.impl;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.core.vocabulary.SD;
import com.atomgraph.linkeddatahub.model.impl.ServiceImpl;
import javax.ws.rs.client.Client;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.vocabulary.RDF;

public class ServiceImplementation
extends Implementation {
    private final Client client;
    private final MediaTypes mediaTypes;
    private final Integer maxGetRequestSize;

    public ServiceImplementation(Client client, MediaTypes mediaTypes, Integer maxGetRequestSize) {
        this.client = client;
        this.mediaTypes = mediaTypes;
        this.maxGetRequestSize = maxGetRequestSize;
    }

    public EnhNode wrap(Node node, EnhGraph enhGraph) {
        if (this.canWrap(node, enhGraph)) {
            return new ServiceImpl(node, enhGraph, this.getClient(), this.getMediaTypes(), this.getMaxGetRequestSize());
        }
        throw new ConversionException("Cannot convert node " + node.toString() + " to Service: it does not have rdf:type sd:Service or equivalent");
    }

    public boolean canWrap(Node node, EnhGraph eg) {
        if (eg == null) {
            throw new IllegalArgumentException("EnhGraph cannot be null");
        }
        return eg.asGraph().contains(node, RDF.type.asNode(), SD.Service.asNode());
    }

    public Client getClient() {
        return this.client;
    }

    public MediaTypes getMediaTypes() {
        return this.mediaTypes;
    }

    public Integer getMaxGetRequestSize() {
        return this.maxGetRequestSize;
    }
}

