/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.resource;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.core.vocabulary.SD;
import com.atomgraph.linkeddatahub.Application;
import com.atomgraph.linkeddatahub.MediaType;
import com.atomgraph.linkeddatahub.client.LinkedDataClient;
import com.atomgraph.linkeddatahub.model.Service;
import com.atomgraph.linkeddatahub.server.io.ValidatingModelProvider;
import com.atomgraph.linkeddatahub.server.model.impl.GraphStoreImpl;
import com.atomgraph.linkeddatahub.server.security.AgentContext;
import com.atomgraph.linkeddatahub.vocabulary.NFO;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.QueryParam;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.DCTerms;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Add
extends GraphStoreImpl {
    private static final Logger log = LoggerFactory.getLogger(Add.class);

    @Inject
    public Add(@Context Request request, @Context UriInfo uriInfo, MediaTypes mediaTypes, com.atomgraph.linkeddatahub.apps.model.Application application, Optional<Ontology> ontology, Optional<Service> service, @Context SecurityContext securityContext, Optional<AgentContext> agentContext, @Context Providers providers, Application system) {
        super(request, uriInfo, mediaTypes, application, ontology, service, securityContext, agentContext, providers, system);
    }

    @GET
    public Response get(@QueryParam(value="default") @DefaultValue(value="false") Boolean defaultGraph, @QueryParam(value="graph") URI graphUri) {
        return super.get(Boolean.valueOf(false), this.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    public Response post(Model model, @QueryParam(value="default") @DefaultValue(value="false") Boolean defaultGraph, @QueryParam(value="graph") URI graphUri) {
        try (ResIterator it = model.listSubjectsWithProperty(DCTerms.source);){
            if (!it.hasNext()) {
                throw new BadRequestException("Argument resource not provided");
            }
            Resource arg = (Resource)it.next();
            Resource source = arg.getPropertyResourceValue(DCTerms.source);
            if (source == null) {
                throw new BadRequestException("RDF source URI (dct:source) not provided");
            }
            Resource graph = arg.getPropertyResourceValue((Property)SD.name);
            if (graph == null || !graph.isURIResource()) {
                throw new BadRequestException("Graph URI (sd:name) not provided");
            }
            LinkedDataClient ldc = LinkedDataClient.create((Client)this.getSystem().getClient(), (MediaTypes)this.getMediaTypes());
            Model importModel = ldc.getModel(source.getURI());
            Response response = this.forwardPost(Entity.entity((Object)importModel, (javax.ws.rs.core.MediaType)com.atomgraph.client.MediaType.APPLICATION_NTRIPLES_TYPE), graph.getURI());
            return response;
        }
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public Response postMultipart(FormDataMultiPart multiPart, @QueryParam(value="default") @DefaultValue(value="false") Boolean defaultGraph, @QueryParam(value="graph") URI graphUri) {
        if (log.isDebugEnabled()) {
            log.debug("MultiPart fields: {} body parts: {}", (Object)multiPart.getFields(), (Object)multiPart.getBodyParts());
        }
        try {
            Model model = this.parseModel(multiPart);
            MessageBodyReader reader = this.getProviders().getMessageBodyReader(Model.class, null, null, (javax.ws.rs.core.MediaType)com.atomgraph.core.MediaType.APPLICATION_NTRIPLES_TYPE);
            if (reader instanceof ValidatingModelProvider) {
                ValidatingModelProvider validatingModelProvider = (ValidatingModelProvider)reader;
                model = validatingModelProvider.processRead(model);
            }
            if (log.isDebugEnabled()) {
                log.debug("POSTed Model size: {}", (Object)model.size());
            }
            return this.postFileBodyPart(model, this.getFileNameBodyPartMap(multiPart));
        }
        catch (URISyntaxException ex) {
            if (log.isErrorEnabled()) {
                log.error("URI '{}' has syntax error in request with media type: {}", (Object)ex.getInput(), (Object)multiPart.getMediaType());
            }
            throw new BadRequestException((Throwable)ex);
        }
        catch (RuntimeIOException ex) {
            if (log.isErrorEnabled()) {
                log.error("Could not read uploaded file as media type: {}", (Object)multiPart.getMediaType());
            }
            throw new BadRequestException((Throwable)ex);
        }
    }

    public Response postFileBodyPart(Model model, Map<String, FormDataBodyPart> fileNameBodyPartMap) {
        if (model == null) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        if (fileNameBodyPartMap == null) {
            throw new IllegalArgumentException("Map<String, FormDataBodyPart> cannot be null");
        }
        try (ResIterator resIt = model.listResourcesWithProperty((Property)NFO.fileName);){
            Response response;
            block17: {
                if (!resIt.hasNext()) {
                    throw new BadRequestException("File body part not found in the multipart request");
                }
                Resource file = (Resource)resIt.next();
                String fileName = file.getProperty((Property)NFO.fileName).getString();
                FormDataBodyPart bodyPart = fileNameBodyPartMap.get(fileName);
                Resource graph = file.getPropertyResourceValue((Property)SD.name);
                if (graph == null || !graph.isURIResource()) {
                    throw new BadRequestException("Graph URI (sd:name) not provided");
                }
                if (!file.hasProperty(DCTerms.format)) {
                    throw new BadRequestException("RDF format (dct:format) not provided");
                }
                javax.ws.rs.core.MediaType mediaType = MediaType.valueOf((Resource)file.getPropertyResourceValue(DCTerms.format));
                bodyPart.setMediaType(mediaType);
                InputStream is = (InputStream)bodyPart.getValueAs(InputStream.class);
                try {
                    response = this.forwardPost(Entity.entity((Object)this.getStreamingOutput(is), (javax.ws.rs.core.MediaType)mediaType), graph.getURI());
                    if (is == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new BadRequestException((Throwable)ex);
                    }
                }
                is.close();
            }
            return response;
        }
    }

    protected Response forwardPost(Entity entity, String graphURI) {
        LinkedDataClient ldc = LinkedDataClient.create((Client)this.getSystem().getClient(), (MediaTypes)this.getSystem().getMediaTypes()).delegation(this.getUriInfo().getBaseUri(), (AgentContext)this.getAgentContext().orElse(null));
        try (Response response = ldc.post(URI.create(graphURI), ldc.getReadableMediaTypes(Model.class), entity);){
            Response response2 = Response.status((int)response.getStatus()).entity(response.readEntity(Model.class)).build();
            return response2;
        }
    }

    public StreamingOutput getStreamingOutput(InputStream is) {
        return os -> is.transferTo(os);
    }

    public URI getURI() {
        return this.getUriInfo().getAbsolutePath();
    }
}

