/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.resource;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.linkeddatahub.Application;
import com.atomgraph.linkeddatahub.apps.model.EndUserApplication;
import com.atomgraph.linkeddatahub.client.LinkedDataClient;
import com.atomgraph.linkeddatahub.model.CSVImport;
import com.atomgraph.linkeddatahub.model.Import;
import com.atomgraph.linkeddatahub.model.RDFImport;
import com.atomgraph.linkeddatahub.model.Service;
import com.atomgraph.linkeddatahub.resource.graph.Item;
import com.atomgraph.linkeddatahub.server.model.impl.GraphStoreImpl;
import com.atomgraph.linkeddatahub.server.security.AgentContext;
import java.net.URI;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.rdf.model.InfModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.vocabulary.FOAF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Importer
extends GraphStoreImpl {
    private static final Logger log = LoggerFactory.getLogger(Importer.class);

    @Inject
    public Importer(@Context Request request, @Context UriInfo uriInfo, MediaTypes mediaTypes, com.atomgraph.linkeddatahub.apps.model.Application application, Optional<Ontology> ontology, Optional<Service> service, @Context SecurityContext securityContext, Optional<AgentContext> agentContext, @Context Providers providers, Application system, @Context ServletConfig servletConfig) {
        super(request, uriInfo, mediaTypes, application, ontology, service, securityContext, agentContext, providers, system);
        if (log.isDebugEnabled()) {
            log.debug("Constructing {}", this.getClass());
        }
    }

    @Path(value="{path: .*}")
    public Object getSubResource() {
        return Item.class;
    }

    @GET
    public Response get(@QueryParam(value="default") @DefaultValue(value="false") Boolean defaultGraph, @QueryParam(value="graph") URI graphUri) {
        return super.get(Boolean.valueOf(false), this.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    public Response post(Model model, @QueryParam(value="default") @DefaultValue(value="false") Boolean defaultGraph, @QueryParam(value="graph") URI graphUri) {
        Response constructor;
        block11: {
            constructor = super.post(model, defaultGraph, graphUri);
            if (constructor.getStatus() == Response.Status.CREATED.getStatusCode()) {
                URI importGraphUri = constructor.getLocation();
                InfModel infModel = ModelFactory.createRDFSModel((Model)this.getOntology().getOntModel(), (Model)model);
                Resource doc = infModel.createResource(importGraphUri.toString());
                try (NodeIterator it = infModel.listObjectsOfProperty(doc, FOAF.primaryTopic);){
                    if (it.hasNext()) {
                        Resource topic = it.next().asResource();
                        if (topic != null && topic.canAs(Import.class)) {
                            Service adminService = this.getApplication().canAs(EndUserApplication.class) ? ((EndUserApplication)this.getApplication().as(EndUserApplication.class)).getAdminApplication().getService() : null;
                            LinkedDataClient ldc = LinkedDataClient.create((Client)this.getSystem().getClient(), (MediaTypes)this.getSystem().getMediaTypes()).delegation(this.getUriInfo().getBaseUri(), (AgentContext)this.getAgentContext().orElse(null));
                            if (topic.canAs(CSVImport.class)) {
                                this.getSystem().submitImport((CSVImport)topic.as(CSVImport.class), this.getApplication(), this.getApplication().getService(), adminService, this.getUriInfo().getBaseUri().toString(), (com.atomgraph.core.client.LinkedDataClient)ldc);
                            }
                            if (topic.canAs(RDFImport.class)) {
                                this.getSystem().submitImport((RDFImport)topic.as(RDFImport.class), this.getApplication(), this.getApplication().getService(), adminService, this.getUriInfo().getBaseUri().toString(), (com.atomgraph.core.client.LinkedDataClient)ldc);
                            }
                        } else if (log.isErrorEnabled()) {
                            log.error("Topic '{}' cannot be cast to Import", (Object)topic);
                        }
                        break block11;
                    }
                    if (log.isErrorEnabled()) {
                        log.error("Import resource for document <{}> not found in graph", (Object)doc);
                    }
                    throw new BadRequestException("Import resource for document <" + doc + "> not found in graph");
                }
            }
        }
        return constructor;
    }

    public URI getURI() {
        return this.getUriInfo().getAbsolutePath();
    }
}

