/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.resource;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.linkeddatahub.Application;
import com.atomgraph.linkeddatahub.apps.model.EndUserApplication;
import com.atomgraph.linkeddatahub.model.Service;
import com.atomgraph.linkeddatahub.server.model.impl.SPARQLEndpointImpl;
import com.atomgraph.linkeddatahub.server.util.OntologyModelGetter;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.resultset.ResultSetMem;
import org.apache.jena.sparql.vocabulary.ResultSetGraphVocab;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Namespace
extends SPARQLEndpointImpl {
    private static final Logger log = LoggerFactory.getLogger(Namespace.class);
    private final URI uri;
    private final com.atomgraph.linkeddatahub.apps.model.Application application;
    private final Ontology ontology;
    private final SecurityContext securityContext;
    private final Application system;

    @Inject
    public Namespace(@Context Request request, @Context UriInfo uriInfo, com.atomgraph.linkeddatahub.apps.model.Application application, Optional<Service> service, Optional<Ontology> ontology, MediaTypes mediaTypes, @Context SecurityContext securityContext, Application system) {
        super(request, service, mediaTypes);
        this.uri = uriInfo.getAbsolutePath();
        this.application = application;
        this.ontology = ontology.get();
        this.securityContext = securityContext;
        this.system = system;
    }

    @GET
    public Response get(@QueryParam(value="query") Query query, @QueryParam(value="default-graph-uri") List<URI> defaultGraphUris, @QueryParam(value="named-graph-uri") List<URI> namedGraphUris) {
        return this.getResponseBuilder(query, defaultGraphUris, namedGraphUris).build();
    }

    public Response.ResponseBuilder getResponseBuilder(Query query, List<URI> defaultGraphUris, List<URI> namedGraphUris) {
        if (query == null) {
            if (this.getApplication().canAs(EndUserApplication.class)) {
                String ontologyURI = this.getURI().toString() + "#";
                if (log.isDebugEnabled()) {
                    log.debug("Returning namespace ontology from OntDocumentManager: {}", (Object)ontologyURI);
                }
                OntologyModelGetter modelGetter = new OntologyModelGetter((EndUserApplication)this.getApplication().as(EndUserApplication.class), this.getSystem().getOntModelSpec(), this.getSystem().getOntologyQuery(), this.getSystem().getClient(), (MediaTypes)this.getSystem().getMediaTypes());
                return this.getResponseBuilder(modelGetter.getModel(ontologyURI));
            }
            throw new BadRequestException("SPARQL query string not provided");
        }
        if (query.isSelectType()) {
            if (log.isDebugEnabled()) {
                log.debug("Loading ResultSet using SELECT/ASK query: {}", (Object)query);
            }
            return this.getResponseBuilder((ResultSetRewindable)new ResultSetMem(QueryExecution.create((Query)query, (Model)this.getOntology().getOntModel()).execSelect()));
        }
        if (query.isAskType()) {
            Model model = ModelFactory.createDefaultModel();
            model.createResource().addProperty(RDF.type, (RDFNode)ResultSetGraphVocab.ResultSet).addLiteral(ResultSetGraphVocab.p_boolean, QueryExecution.create((Query)query, (Model)this.getOntology().getOntModel()).execAsk());
            if (log.isDebugEnabled()) {
                log.debug("Loading ResultSet using SELECT/ASK query: {}", (Object)query);
            }
            return this.getResponseBuilder(ResultSetFactory.copyResults((ResultSet)ResultSetFactory.makeResults((Model)model)));
        }
        if (query.isDescribeType()) {
            if (log.isDebugEnabled()) {
                log.debug("Loading Model using CONSTRUCT/DESCRIBE query: {}", (Object)query);
            }
            return this.getResponseBuilder(QueryExecution.create((Query)query, (Model)this.getOntology().getOntModel()).execDescribe());
        }
        if (query.isConstructType()) {
            if (log.isDebugEnabled()) {
                log.debug("Loading Model using CONSTRUCT/DESCRIBE query: {}", (Object)query);
            }
            return this.getResponseBuilder(QueryExecution.create((Query)query, (Model)this.getOntology().getOntModel()).execConstruct());
        }
        if (log.isWarnEnabled()) {
            log.warn("SPARQL endpoint received unknown type of query: {}", (Object)query);
        }
        throw new BadRequestException("Unknown query type");
    }

    public URI getURI() {
        return this.uri;
    }

    public com.atomgraph.linkeddatahub.apps.model.Application getApplication() {
        return this.application;
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public Application getSystem() {
        return this.system;
    }
}

