/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.resource.admin;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.linkeddatahub.Application;
import com.atomgraph.linkeddatahub.apps.model.AdminApplication;
import com.atomgraph.linkeddatahub.apps.model.EndUserApplication;
import com.atomgraph.linkeddatahub.server.filter.request.OntologyFilter;
import com.atomgraph.linkeddatahub.server.util.OntologyModelGetter;
import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.core.Response;
import org.apache.jena.ontology.OntDocumentManager;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.ModelGetter;
import org.apache.jena.rdf.model.Resource;
import org.glassfish.jersey.uri.UriComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clear {
    private static final Logger log = LoggerFactory.getLogger(Clear.class);
    private final com.atomgraph.linkeddatahub.apps.model.Application application;
    private final Application system;

    @Inject
    public Clear(com.atomgraph.linkeddatahub.apps.model.Application application, Application system) {
        this.application = application;
        this.system = system;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response post(@FormParam(value="uri") String ontologyURI, @HeaderParam(value="Referer") URI referer) {
        if (ontologyURI == null) {
            throw new BadRequestException("Ontology URI not specified");
        }
        EndUserApplication app = ((AdminApplication)this.getApplication().as(AdminApplication.class)).getEndUserApplication();
        OntModelSpec ontModelSpec = new OntModelSpec(this.getSystem().getOntModelSpec(app));
        if (ontModelSpec.getDocumentManager().getFileManager().hasCachedModel(ontologyURI)) {
            if (log.isDebugEnabled()) {
                log.debug("Clearing ontology with URI '{}' from memory", (Object)ontologyURI);
            }
            ontModelSpec.getDocumentManager().getFileManager().removeCacheModel(ontologyURI);
            if (this.getApplication().getService().getProxy() != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Purge ontology with URI '{}' from proxy cache", (Object)ontologyURI);
                }
                this.ban(this.getApplication().getService().getProxy(), ontologyURI);
            }
            OntologyModelGetter modelGetter = new OntologyModelGetter(app, ontModelSpec, this.getSystem().getOntologyQuery(), this.getSystem().getNoCertClient(), (MediaTypes)this.getSystem().getMediaTypes());
            ontModelSpec.setImportModelGetter((ModelGetter)modelGetter);
            if (log.isDebugEnabled()) {
                log.debug("Started loading ontology with URI '{}' from the admin dataset", (Object)ontologyURI);
            }
            Model baseModel = modelGetter.getModel(ontologyURI);
            OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)ontModelSpec, (Model)baseModel);
            OntModel materializedModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
            materializedModel.add((Model)ontModel);
            ontModel.getDocumentManager().addModel(ontologyURI, (Model)materializedModel, true);
            ontModel.listImportedOntologyURIs(true).forEach(importURI -> OntologyFilter.addDocumentModel((OntDocumentManager)ontModel.getDocumentManager(), (String)importURI));
            if (log.isDebugEnabled()) {
                log.debug("Finished loading ontology with URI '{}' from the admin dataset", (Object)ontologyURI);
            }
        }
        if (referer != null) {
            return Response.seeOther((URI)referer).build();
        }
        return Response.ok().build();
    }

    public Response ban(Resource proxy, String url) {
        if (url == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        return (Response)this.getSystem().getClient().target(proxy.getURI()).request().header("X-Escaped-Request-URI", (Object)UriComponent.encode((String)url, (UriComponent.Type)UriComponent.Type.UNRESERVED)).method("BAN", Response.class);
    }

    public com.atomgraph.linkeddatahub.apps.model.Application getApplication() {
        return this.application;
    }

    public Application getSystem() {
        return this.system;
    }
}

