/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.resource.admin;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.core.exception.ConfigurationException;
import com.atomgraph.linkeddatahub.Application;
import com.atomgraph.linkeddatahub.client.LinkedDataClient;
import com.atomgraph.linkeddatahub.listener.EMailListener;
import com.atomgraph.linkeddatahub.model.Service;
import com.atomgraph.linkeddatahub.model.auth.Agent;
import com.atomgraph.linkeddatahub.server.model.impl.GraphStoreImpl;
import com.atomgraph.linkeddatahub.server.security.AgentContext;
import com.atomgraph.linkeddatahub.server.util.MessageBuilder;
import com.atomgraph.linkeddatahub.server.util.Skolemizer;
import com.atomgraph.linkeddatahub.vocabulary.FOAF;
import com.atomgraph.linkeddatahub.vocabulary.LACL;
import com.atomgraph.linkeddatahub.vocabulary.LDHC;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Inject;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.servlet.ServletConfig;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.QueryParam;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestAccess
extends GraphStoreImpl {
    private static final Logger log = LoggerFactory.getLogger(RequestAccess.class);
    private final String emailSubject;
    private final String emailText;
    private final UriBuilder authRequestContainerUriBuilder;

    @Inject
    public RequestAccess(@Context Request request, @Context UriInfo uriInfo, MediaTypes mediaTypes, com.atomgraph.linkeddatahub.apps.model.Application application, Optional<Ontology> ontology, Optional<Service> service, @Context SecurityContext securityContext, Optional<AgentContext> agentContext, @Context Providers providers, Application system, @Context ServletConfig servletConfig) {
        super(request, uriInfo, mediaTypes, application, ontology, service, securityContext, agentContext, providers, system);
        if (log.isDebugEnabled()) {
            log.debug("Constructing {}", this.getClass());
        }
        if (securityContext == null || !(securityContext.getUserPrincipal() instanceof Agent)) {
            throw new IllegalStateException("Agent is not authenticated");
        }
        this.authRequestContainerUriBuilder = uriInfo.getBaseUriBuilder().path("acl/authorization-requests/");
        this.emailSubject = servletConfig.getServletContext().getInitParameter(LDHC.requestAccessEMailSubject.getURI());
        if (this.emailSubject == null) {
            throw new InternalServerErrorException((Throwable)new ConfigurationException((Property)LDHC.requestAccessEMailSubject));
        }
        this.emailText = servletConfig.getServletContext().getInitParameter(LDHC.requestAccessEMailText.getURI());
        if (this.emailText == null) {
            throw new InternalServerErrorException((Throwable)new ConfigurationException((Property)LDHC.requestAccessEMailText));
        }
    }

    @GET
    public Response get(@QueryParam(value="default") @DefaultValue(value="false") Boolean defaultGraph, @QueryParam(value="graph") URI graphUri) {
        return super.get(Boolean.valueOf(false), this.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    public Response post(Model requestModel, @QueryParam(value="default") @DefaultValue(value="false") Boolean defaultGraph, @QueryParam(value="graph") URI graphUri) {
        graphUri = this.getAuthRequestContainerUriBuilder().path(UUID.randomUUID().toString() + "/").build(new Object[0]);
        new Skolemizer(graphUri.toString()).apply(requestModel);
        try (ResIterator it = requestModel.listResourcesWithProperty(RDF.type, (RDFNode)LACL.AuthorizationRequest);){
            block8: {
                Resource accessRequest = (Resource)it.next();
                Resource requestAgent = accessRequest.getPropertyResourceValue((Property)LACL.requestAgent);
                if (!requestAgent.equals((Object)((AgentContext)this.getAgentContext().get()).getAgent())) {
                    throw new IllegalStateException("Agent requesting access must be authenticated");
                }
                Resource owner = this.getApplication().getMaker();
                if (owner == null) {
                    throw new IllegalStateException("Application <" + this.getApplication().getURI() + "> does not have a maker (foaf:maker)");
                }
                String ownerURI = owner.getURI();
                accessRequest.addLiteral(DCTerms.created, (Object)GregorianCalendar.getInstance());
                LinkedDataClient ldc = LinkedDataClient.create((Client)this.getSystem().getClient(), (MediaTypes)this.getSystem().getMediaTypes()).delegation(this.getUriInfo().getBaseUri(), (AgentContext)this.getAgentContext().orElse(null));
                Model agentModel = ldc.getModel(ownerURI);
                owner = agentModel.getResource(ownerURI);
                if (!agentModel.containsResource((RDFNode)owner)) {
                    throw new IllegalStateException("Could not load agent's <" + ownerURI + "> description from admin service");
                }
                super.post(requestModel, Boolean.valueOf(false), graphUri);
                try {
                    this.sendEmail(owner, accessRequest);
                }
                catch (UnsupportedEncodingException | MessagingException ex) {
                    if (!log.isErrorEnabled()) break block8;
                    log.error("Could not send access request email to Agent: {}", (Object)((AgentContext)this.getAgentContext().get()).getAgent().getURI());
                }
            }
            Response response = Response.ok().entity((Object)requestModel).build();
            return response;
        }
    }

    public void sendEmail(Resource owner, Resource accessRequest) throws MessagingException, UnsupportedEncodingException {
        Object name;
        if (owner.hasProperty((Property)FOAF.givenName) && owner.hasProperty((Property)FOAF.familyName)) {
            String givenName = owner.getProperty((Property)FOAF.givenName).getString();
            String familyName = owner.getProperty((Property)FOAF.familyName).getString();
            name = givenName + " " + familyName;
        } else if (owner.hasProperty((Property)FOAF.name)) {
            name = owner.getProperty((Property)FOAF.name).getString();
        } else {
            throw new IllegalStateException("Owner Agent '" + owner + "' does not have either foaf:givenName/foaf:familyName or foaf:name");
        }
        String mbox = owner.getRequiredProperty((Property)FOAF.mbox).getResource().getURI().substring("mailto:".length());
        Resource requestAgent = accessRequest.getPropertyResourceValue((Property)LACL.requestAgent);
        Resource accessTo = accessRequest.getPropertyResourceValue((Property)LACL.requestAccessTo);
        MessageBuilder builder = this.getSystem().getMessageBuilder().subject(String.format(this.getEmailSubject(), this.getApplication().getProperty(DCTerms.title).getString())).to(mbox, (String)name).textBodyPart(String.format(this.getEmailText(), requestAgent.getURI(), accessTo.getURI(), accessRequest.getURI()));
        if (this.getSystem().getNotificationAddress() != null) {
            builder = builder.from(this.getSystem().getNotificationAddress());
        }
        EMailListener.submit((Message)builder.build());
    }

    protected Service getAgentService() {
        return this.getApplication().getService();
    }

    public URI getURI() {
        return this.getUriInfo().getAbsolutePath();
    }

    public String getEmailSubject() {
        return this.emailSubject;
    }

    public String getEmailText() {
        return this.emailText;
    }

    public UriBuilder getAuthRequestContainerUriBuilder() {
        return this.authRequestContainerUriBuilder.clone();
    }
}

