/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.resource.admin;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.core.exception.ConfigurationException;
import com.atomgraph.linkeddatahub.Application;
import com.atomgraph.linkeddatahub.apps.model.AdminApplication;
import com.atomgraph.linkeddatahub.apps.model.EndUserApplication;
import com.atomgraph.linkeddatahub.listener.EMailListener;
import com.atomgraph.linkeddatahub.model.Service;
import com.atomgraph.linkeddatahub.server.model.impl.GraphStoreImpl;
import com.atomgraph.linkeddatahub.server.security.AgentContext;
import com.atomgraph.linkeddatahub.server.util.MessageBuilder;
import com.atomgraph.linkeddatahub.server.util.Skolemizer;
import com.atomgraph.linkeddatahub.server.util.WebIDCertGen;
import com.atomgraph.linkeddatahub.vocabulary.ACL;
import com.atomgraph.linkeddatahub.vocabulary.Cert;
import com.atomgraph.linkeddatahub.vocabulary.FOAF;
import com.atomgraph.linkeddatahub.vocabulary.LACL;
import com.atomgraph.linkeddatahub.vocabulary.LDHC;
import com.atomgraph.processor.vocabulary.DH;
import com.atomgraph.processor.vocabulary.SIOC;
import com.atomgraph.server.exception.SPINConstraintViolationException;
import com.atomgraph.server.exception.SkolemizationException;
import com.atomgraph.spinrdf.constraints.ConstraintViolation;
import com.atomgraph.spinrdf.constraints.ObjectPropertyPath;
import com.google.common.base.CharMatcher;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPublicKey;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Inject;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.servlet.ServletConfig;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUp
extends GraphStoreImpl {
    private static final Logger log = LoggerFactory.getLogger(SignUp.class);
    public static final String STORE_TYPE = "PKCS12";
    public static final String KEY_ALIAS = "linkeddatahub-client";
    public static final int MIN_PASSWORD_LENGTH = 6;
    public static final MediaType PKCS12_MEDIA_TYPE = MediaType.valueOf((String)"application/x-pkcs12");
    public static final String COUNTRY_DATASET_PATH = "/static/com/atomgraph/linkeddatahub/xsl/bootstrap/2.3.2/countries.rdf";
    public static final String AGENT_PATH = "acl/agents/";
    public static final String PUBLIC_KEY_PATH = "acl/public-keys/";
    public static final String AUTHORIZATION_PATH = "acl/authorizations/";
    private final Model countryModel;
    private final String emailSubject;
    private final String emailText;
    private final int validityDays;
    private final boolean download;

    @Inject
    public SignUp(@Context Request request, @Context UriInfo uriInfo, MediaTypes mediaTypes, com.atomgraph.linkeddatahub.apps.model.Application application, Optional<Ontology> ontology, Optional<Service> service, @Context SecurityContext securityContext, Optional<AgentContext> agentContext, @Context Providers providers, Application system, @Context ServletConfig servletConfig) {
        super(request, uriInfo, mediaTypes, application, ontology, service, securityContext, agentContext, providers, system);
        if (log.isDebugEnabled()) {
            log.debug("Constructing {}", this.getClass());
        }
        if (!application.canAs(AdminApplication.class)) {
            throw new IllegalStateException("Application cannot be cast to lapp:AdminApplication");
        }
        try (InputStream countries = servletConfig.getServletContext().getResourceAsStream(COUNTRY_DATASET_PATH);){
            this.countryModel = ModelFactory.createDefaultModel();
            RDFDataMgr.read((Model)this.countryModel, (InputStream)countries, null, (Lang)Lang.RDFXML);
        }
        catch (IOException ex) {
            throw new InternalServerErrorException((Throwable)ex);
        }
        this.emailSubject = servletConfig.getServletContext().getInitParameter(LDHC.signUpEMailSubject.getURI());
        if (this.emailSubject == null) {
            throw new InternalServerErrorException((Throwable)new ConfigurationException((Property)LDHC.signUpEMailSubject));
        }
        this.emailText = servletConfig.getServletContext().getInitParameter(LDHC.webIDSignUpEMailText.getURI());
        if (this.emailText == null) {
            throw new InternalServerErrorException((Throwable)new ConfigurationException((Property)LDHC.webIDSignUpEMailText));
        }
        if (servletConfig.getServletContext().getInitParameter(LDHC.signUpCertValidity.getURI()) == null) {
            throw new InternalServerErrorException((Throwable)new ConfigurationException((Property)LDHC.signUpCertValidity));
        }
        this.validityDays = Integer.parseInt(servletConfig.getServletContext().getInitParameter(LDHC.signUpCertValidity.getURI()));
        this.download = uriInfo.getQueryParameters().containsKey((Object)"download");
    }

    @GET
    public Response get(@QueryParam(value="default") @DefaultValue(value="false") Boolean defaultGraph, @QueryParam(value="graph") URI graphUri) {
        return super.get(Boolean.valueOf(false), this.getURI());
    }

    @POST
    public Response post(Model agentModel, @QueryParam(value="default") @DefaultValue(value="false") Boolean defaultGraph, @QueryParam(value="graph") URI graphUri) {
        URI agentGraphUri = this.getUriInfo().getBaseUriBuilder().path(AGENT_PATH).path("{slug}/").build(new Object[]{UUID.randomUUID().toString()});
        new Skolemizer(agentGraphUri.toString()).apply(agentModel);
        try (ResIterator it = agentModel.listResourcesWithProperty(RDF.type, (RDFNode)FOAF.Person);){
            Model publicKeyModel;
            ByteArrayInputStream bis;
            byte[] keyStoreBytes;
            String keyStoreFileName;
            Resource agent;
            block24: {
                Response response;
                Resource org;
                boolean agentExists;
                agent = (Resource)it.next();
                String password = this.validateAndRemovePassword(agent);
                Resource mbox = agent.getRequiredProperty((Property)FOAF.mbox).getResource();
                ParameterizedSparqlString pss = new ParameterizedSparqlString(this.getAgentQuery().toString());
                pss.setParam(FOAF.mbox.getLocalName(), (RDFNode)mbox);
                boolean bl = agentExists = !this.getAgentService().getSPARQLClient().loadModel(pss.asQuery()).isEmpty();
                if (agentExists) {
                    throw this.createSPINConstraintViolationException(agent, (Property)FOAF.mbox, "Agent with this mailbox already exists");
                }
                String givenName = agent.getRequiredProperty((Property)FOAF.givenName).getString();
                String familyName = agent.getRequiredProperty((Property)FOAF.familyName).getString();
                String fullName = givenName + " " + familyName;
                String orgName = null;
                if (agent.hasProperty((Property)FOAF.member) && (org = agent.getPropertyResourceValue((Property)FOAF.member)).hasProperty((Property)FOAF.name)) {
                    orgName = org.getProperty((Property)FOAF.name).getString();
                }
                Resource country = agent.getRequiredProperty((Property)FOAF.based_near).getResource();
                String countryName = this.getCountryModel().createResource(country.getURI()).getRequiredProperty(DCTerms.title).getString();
                agent = this.appendItem(agentModel, agentGraphUri, agentModel.createResource(this.getUriInfo().getBaseUri().resolve(AGENT_PATH).toString()), agent);
                String uuid = UUID.randomUUID().toString();
                keyStoreFileName = uuid + ".p12";
                Path keyStorePath = Paths.get(System.getProperty("java.io.tmpdir") + File.separator + keyStoreFileName, new String[0]);
                if (!agent.isURIResource()) {
                    throw new IllegalStateException("Agent is not a URI resource");
                }
                new WebIDCertGen("RSA", STORE_TYPE).generate(keyStorePath, password, password, KEY_ALIAS, fullName, null, orgName, null, null, countryName, agent.getURI(), this.getValidityDays());
                KeyStore keyStore = KeyStore.getInstance(STORE_TYPE);
                keyStoreBytes = Files.readAllBytes(keyStorePath);
                bis = new ByteArrayInputStream(keyStoreBytes);
                try {
                    keyStore.load(bis, password.toCharArray());
                    Certificate cert = keyStore.getCertificate(KEY_ALIAS);
                    if (!(cert.getPublicKey() instanceof RSAPublicKey)) {
                        throw new IllegalStateException("Certificate PublicKey is not an RSAPublicKey");
                    }
                    RSAPublicKey certPublicKey = (RSAPublicKey)cert.getPublicKey();
                    URI publicKeyGraphUri = this.getUriInfo().getBaseUriBuilder().path(PUBLIC_KEY_PATH).path("{slug}/").build(new Object[]{UUID.randomUUID().toString()});
                    publicKeyModel = ModelFactory.createDefaultModel();
                    this.createPublicKey(publicKeyModel, publicKeyGraphUri, publicKeyModel.createResource(this.getUriInfo().getBaseUri().resolve(PUBLIC_KEY_PATH).toString()), certPublicKey);
                    new Skolemizer(publicKeyGraphUri.toString()).apply(publicKeyModel);
                    Response publicKeyResponse = super.post(publicKeyModel, Boolean.valueOf(false), publicKeyGraphUri);
                    if (publicKeyResponse.getStatus() != Response.Status.CREATED.getStatusCode()) {
                        if (log.isErrorEnabled()) {
                            log.error("Cannot create PublicKey");
                        }
                        throw new InternalServerErrorException("Cannot create PublicKey");
                    }
                    Resource publicKey = publicKeyModel.createResource(publicKeyGraphUri.toString()).getPropertyResourceValue((Property)FOAF.primaryTopic);
                    agent.addProperty((Property)Cert.key, (RDFNode)publicKey);
                    agentModel.add(agentModel.createResource(this.getSystem().getSecretaryWebIDURI().toString()), (Property)ACL.delegates, (RDFNode)agent);
                    Response agentResponse = super.post(agentModel, Boolean.valueOf(false), agentGraphUri);
                    if (agentResponse.getStatus() != Response.Status.CREATED.getStatusCode()) {
                        if (log.isErrorEnabled()) {
                            log.error("Cannot create Agent");
                        }
                        throw new InternalServerErrorException("Cannot create Agent");
                    }
                    URI authGraphUri = this.getUriInfo().getBaseUriBuilder().path(AUTHORIZATION_PATH).path("{slug}/").build(new Object[]{UUID.randomUUID().toString()});
                    Model authModel = ModelFactory.createDefaultModel();
                    this.createAuthorization(authModel, authGraphUri, authModel.createResource(this.getUriInfo().getBaseUri().resolve(AUTHORIZATION_PATH).toString()), agentGraphUri, publicKeyGraphUri);
                    new Skolemizer(authGraphUri.toString()).apply(authModel);
                    Response authResponse = super.post(authModel, Boolean.valueOf(false), authGraphUri);
                    if (authResponse.getStatus() != Response.Status.CREATED.getStatusCode()) {
                        if (log.isErrorEnabled()) {
                            log.error("Cannot create Authorization");
                        }
                        throw new InternalServerErrorException("Cannot create Authorization");
                    }
                    this.getSystem().getEventBus().post((Object)new com.atomgraph.linkeddatahub.server.event.SignUp(this.getSystem().getSecretaryWebIDURI()));
                    if (!this.download) break block24;
                    response = Response.ok((Object)keyStoreBytes).type(PKCS12_MEDIA_TYPE).header("Content-Disposition", (Object)"attachment; filename=cert.p12").build();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((InputStream)bis).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (SPINConstraintViolationException ex) {
                        throw ex;
                    }
                    catch (IllegalArgumentException ex) {
                        throw new SkolemizationException(ex, agentModel);
                    }
                    catch (Exception ex) {
                        throw new MappableException((Throwable)ex);
                    }
                }
                ((InputStream)bis).close();
                return response;
            }
            LocalDate certExpires = LocalDate.now().plusDays(this.getValidityDays());
            this.sendEmail(agent, certExpires, keyStoreBytes, keyStoreFileName);
            Response response = Response.ok().entity((Object)agentModel.add(publicKeyModel)).build();
            ((InputStream)bis).close();
            return response;
        }
    }

    public String validateAndRemovePassword(Resource agent) throws SPINConstraintViolationException {
        Statement certStmt = agent.getProperty((Property)Cert.key);
        if (certStmt == null) {
            throw this.createSPINConstraintViolationException(agent, (Property)Cert.key, "cert:key is missing");
        }
        if (certStmt.getResource().listProperties((Property)LACL.password).toList().size() > 1) {
            throw this.createSPINConstraintViolationException(certStmt.getResource(), (Property)LACL.password, "Certificate passwords do not match");
        }
        Statement passwordStmt = certStmt.getResource().getProperty((Property)LACL.password);
        if (passwordStmt == null) {
            throw this.createSPINConstraintViolationException(certStmt.getResource(), (Property)LACL.password, "Certificate password is missing");
        }
        String password = passwordStmt.getString();
        if (password.length() < 6) {
            throw this.createSPINConstraintViolationException(certStmt.getResource(), (Property)LACL.password, "Certificate password must be at least 6 characters long");
        }
        if (!CharMatcher.ascii().matchesAllOf((CharSequence)password)) {
            throw this.createSPINConstraintViolationException(certStmt.getResource(), (Property)LACL.password, "Certificate password must only contain ASCII characters");
        }
        passwordStmt.remove();
        certStmt.remove();
        return password;
    }

    public SPINConstraintViolationException createSPINConstraintViolationException(Resource resource, Property property, String message) {
        ArrayList<ConstraintViolation> cvs = new ArrayList<ConstraintViolation>();
        ArrayList<ObjectPropertyPath> paths = new ArrayList<ObjectPropertyPath>();
        paths.add(new ObjectPropertyPath(resource, property));
        cvs.add(new ConstraintViolation(resource, paths, null, message, null));
        return new SPINConstraintViolationException(cvs, resource.getModel());
    }

    public Resource appendItem(Model model, URI graphURI, Resource container, Resource agent) {
        Resource item = model.createResource(graphURI.toString()).addProperty(RDF.type, (RDFNode)DH.Item).addProperty((Property)SIOC.HAS_CONTAINER, (RDFNode)container).addLiteral((Property)DH.slug, (Object)UUID.randomUUID().toString());
        item.addProperty((Property)FOAF.primaryTopic, (RDFNode)agent);
        return agent;
    }

    public Resource createPublicKey(Model model, URI graphURI, Resource container, RSAPublicKey publicKey) {
        Resource item = model.createResource(graphURI.toString()).addProperty(RDF.type, (RDFNode)DH.Item).addProperty((Property)SIOC.HAS_CONTAINER, (RDFNode)container).addLiteral((Property)DH.slug, (Object)UUID.randomUUID().toString());
        Resource publicKeyRes = model.createResource().addProperty(RDF.type, (RDFNode)Cert.PublicKey).addLiteral((Property)Cert.exponent, (Object)publicKey.getPublicExponent()).addLiteral((Property)Cert.modulus, ResourceFactory.createTypedLiteral((String)publicKey.getModulus().toString(16), (RDFDatatype)XSDDatatype.XSDhexBinary));
        item.addProperty((Property)FOAF.primaryTopic, (RDFNode)publicKeyRes);
        return publicKeyRes;
    }

    public Resource createAuthorization(Model model, URI graphURI, Resource container, URI agentGraphURI, URI publicKeyGraphURI) {
        Resource item = model.createResource(graphURI.toString()).addProperty(RDF.type, (RDFNode)DH.Item).addProperty((Property)SIOC.HAS_CONTAINER, (RDFNode)container).addLiteral((Property)DH.slug, (Object)UUID.randomUUID().toString());
        Resource auth = model.createResource().addProperty(RDF.type, (RDFNode)ACL.Authorization).addLiteral((Property)DH.slug, (Object)UUID.randomUUID().toString()).addProperty((Property)ACL.accessTo, (RDFNode)ResourceFactory.createResource((String)agentGraphURI.toString())).addProperty((Property)ACL.accessTo, (RDFNode)ResourceFactory.createResource((String)publicKeyGraphURI.toString())).addProperty((Property)ACL.mode, (RDFNode)ACL.Read).addProperty((Property)ACL.agentClass, (RDFNode)FOAF.Agent).addProperty((Property)ACL.agentClass, (RDFNode)ACL.AuthenticatedAgent);
        item.addProperty((Property)FOAF.primaryTopic, (RDFNode)auth);
        return auth;
    }

    public void sendEmail(Resource agent, LocalDate certExpires, byte[] keyStoreBytes, String keyStoreFileName) throws MessagingException, UnsupportedEncodingException {
        String givenName = agent.getRequiredProperty((Property)FOAF.givenName).getString();
        String familyName = agent.getRequiredProperty((Property)FOAF.familyName).getString();
        String fullName = givenName + " " + familyName;
        String mbox = agent.getRequiredProperty((Property)FOAF.mbox).getResource().getURI().substring("mailto:".length());
        MessageBuilder builder = this.getSystem().getMessageBuilder().subject(String.format(this.getEmailSubject(), this.getEndUserApplication().getProperty(DCTerms.title).getString(), fullName)).to(mbox, fullName).textBodyPart(String.format(this.getEmailText(), this.getEndUserApplication().getProperty(DCTerms.title).getString(), this.getEndUserApplication().getBase(), agent.getURI(), certExpires.format(DateTimeFormatter.ISO_LOCAL_DATE))).byteArrayBodyPart(keyStoreBytes, PKCS12_MEDIA_TYPE.toString(), keyStoreFileName);
        if (this.getSystem().getNotificationAddress() != null) {
            builder = builder.from(this.getSystem().getNotificationAddress());
        }
        EMailListener.submit((Message)builder.build());
    }

    public EndUserApplication getEndUserApplication() {
        if (this.getApplication().canAs(EndUserApplication.class)) {
            return (EndUserApplication)this.getApplication().as(EndUserApplication.class);
        }
        return ((AdminApplication)this.getApplication().as(AdminApplication.class)).getEndUserApplication();
    }

    public Service getAgentService() {
        return this.getApplication().getService();
    }

    public URI getURI() {
        return this.getUriInfo().getAbsolutePath();
    }

    public int getValidityDays() {
        return this.validityDays;
    }

    public Model getCountryModel() {
        return this.countryModel;
    }

    public String getEmailSubject() {
        return this.emailSubject;
    }

    public String getEmailText() {
        return this.emailText;
    }

    public Query getAgentQuery() {
        return this.getSystem().getAgentQuery();
    }
}

