/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.resource.admin.oauth2;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.core.exception.ConfigurationException;
import com.atomgraph.linkeddatahub.Application;
import com.atomgraph.linkeddatahub.apps.model.AdminApplication;
import com.atomgraph.linkeddatahub.apps.model.EndUserApplication;
import com.atomgraph.linkeddatahub.listener.EMailListener;
import com.atomgraph.linkeddatahub.model.Service;
import com.atomgraph.linkeddatahub.server.event.SignUp;
import com.atomgraph.linkeddatahub.server.model.impl.GraphStoreImpl;
import com.atomgraph.linkeddatahub.server.security.AgentContext;
import com.atomgraph.linkeddatahub.server.util.MessageBuilder;
import com.atomgraph.linkeddatahub.server.util.Skolemizer;
import com.atomgraph.linkeddatahub.vocabulary.ACL;
import com.atomgraph.linkeddatahub.vocabulary.FOAF;
import com.atomgraph.linkeddatahub.vocabulary.Google;
import com.atomgraph.linkeddatahub.vocabulary.LACL;
import com.atomgraph.linkeddatahub.vocabulary.LDHC;
import com.atomgraph.processor.vocabulary.DH;
import com.atomgraph.processor.vocabulary.SIOC;
import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Base64;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.json.JsonObject;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.servlet.ServletConfig;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;
import org.glassfish.jersey.uri.UriComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="oauth2/login")
public class Login
extends GraphStoreImpl {
    private static final Logger log = LoggerFactory.getLogger(Login.class);
    public static final String TOKEN_ENDPOINT = "https://oauth2.googleapis.com/token";
    public static final String USER_INFO_ENDPOINT = "https://openidconnect.googleapis.com/v1/userinfo";
    public static final String ACCOUNT_PATH = "acl/users/";
    private final HttpHeaders httpHeaders;
    private final String emailSubject;
    private final String emailText;
    private final String clientID;
    private final String clientSecret;

    @Inject
    public Login(@Context Request request, @Context UriInfo uriInfo, MediaTypes mediaTypes, @Context HttpHeaders httpHeaders, com.atomgraph.linkeddatahub.apps.model.Application application, Optional<Ontology> ontology, Optional<Service> service, @Context SecurityContext securityContext, Optional<AgentContext> agentContext, @Context Providers providers, Application system, @Context ServletConfig servletConfig) {
        super(request, uriInfo, mediaTypes, application, ontology, service, securityContext, agentContext, providers, system);
        this.httpHeaders = httpHeaders;
        this.emailSubject = servletConfig.getServletContext().getInitParameter(LDHC.signUpEMailSubject.getURI());
        if (this.emailSubject == null) {
            throw new InternalServerErrorException((Throwable)new ConfigurationException((Property)LDHC.signUpEMailSubject));
        }
        this.emailText = servletConfig.getServletContext().getInitParameter(LDHC.oAuthSignUpEMailText.getURI());
        if (this.emailText == null) {
            throw new InternalServerErrorException((Throwable)new ConfigurationException((Property)LDHC.oAuthSignUpEMailText));
        }
        this.clientID = (String)system.getProperty(Google.clientID.getURI());
        this.clientSecret = (String)system.getProperty(Google.clientSecret.getURI());
    }

    @GET
    public Response get(@QueryParam(value="default") @DefaultValue(value="false") Boolean defaultGraph, @QueryParam(value="graph") URI graphUri) {
        Cookie stateCookie;
        if (this.getClientID() == null) {
            throw new ConfigurationException((Property)Google.clientID);
        }
        if (this.getClientSecret() == null) {
            throw new ConfigurationException((Property)Google.clientSecret);
        }
        String error = (String)this.getUriInfo().getQueryParameters().getFirst((Object)"error");
        if (error != null) {
            if (log.isErrorEnabled()) {
                log.error("OAuth callback error: {}", (Object)error);
            }
            throw new InternalServerErrorException(error);
        }
        String code = (String)this.getUriInfo().getQueryParameters().getFirst((Object)"code");
        String state = (String)this.getUriInfo().getQueryParameters().getFirst((Object)"state");
        if (!state.equals((stateCookie = (Cookie)this.getHttpHeaders().getCookies().get("LinkedDataHub.state")).getValue())) {
            throw new BadRequestException("OAuth 'state' parameter failed to validate");
        }
        Form form = new Form().param("grant_type", "authorization_code").param("client_id", this.getClientID()).param("redirect_uri", this.getUriInfo().getAbsolutePath().toString()).param("client_secret", this.getClientSecret()).param("code", code);
        try (Response cr = this.getSystem().getClient().target(TOKEN_ENDPOINT).request().post(Entity.form((Form)form));){
            boolean accountExists;
            JsonObject response = (JsonObject)cr.readEntity(JsonObject.class);
            if (response.containsKey((Object)"error")) {
                if (log.isErrorEnabled()) {
                    log.error("OAuth error: '{}'", (Object)response.getString("error"));
                }
                throw new InternalServerErrorException(response.getString("error"));
            }
            String idToken = response.getString("id_token");
            DecodedJWT jwt = JWT.decode((String)idToken);
            if (response.containsKey((Object)"refresh_token")) {
                String refreshToken = response.getString("refresh_token");
                try {
                    this.getSystem().storeRefreshToken(jwt.getSubject(), refreshToken);
                }
                catch (IOException ex) {
                    if (log.isErrorEnabled()) {
                        log.error("Error storing OAuth refresh token", (Throwable)ex);
                    }
                    throw new InternalServerErrorException((Throwable)ex);
                }
            }
            ParameterizedSparqlString accountPss = new ParameterizedSparqlString(this.getUserAccountQuery().toString());
            accountPss.setLiteral(SIOC.ID.getLocalName(), jwt.getSubject());
            accountPss.setLiteral(LACL.issuer.getLocalName(), jwt.getIssuer());
            boolean bl = accountExists = !this.getAgentService().getSPARQLClient().loadModel(accountPss.asQuery()).isEmpty();
            if (!accountExists) {
                boolean agentExists;
                String email = jwt.getClaim("email").asString();
                Resource mbox = ResourceFactory.createResource((String)("mailto:" + email));
                ParameterizedSparqlString agentPss = new ParameterizedSparqlString(this.getAgentQuery().toString());
                agentPss.setParam(FOAF.mbox.getLocalName(), (RDFNode)mbox);
                Model agentModel = this.getAgentService().getSPARQLClient().loadModel(agentPss.asQuery());
                if (agentModel.isEmpty()) {
                    agentExists = false;
                    URI agentGraphUri = this.getUriInfo().getBaseUriBuilder().path("acl/agents/").path("{slug}/").build(new Object[]{UUID.randomUUID().toString()});
                    this.createAgent(agentModel, agentGraphUri, agentModel.createResource(this.getUriInfo().getBaseUri().resolve("acl/agents/").toString()), jwt.getClaim("given_name").asString(), jwt.getClaim("family_name").asString(), email, jwt.getClaim("picture") != null ? jwt.getClaim("picture").asString() : null);
                    new Skolemizer(agentGraphUri.toString()).apply(agentModel);
                } else {
                    agentExists = true;
                }
                try (ResIterator it = agentModel.listResourcesWithProperty((Property)FOAF.mbox);){
                    Resource agent = (Resource)it.next();
                    Model accountModel = ModelFactory.createDefaultModel();
                    URI userAccountGraphUri = this.getUriInfo().getBaseUriBuilder().path(ACCOUNT_PATH).path("{slug}/").build(new Object[]{UUID.randomUUID().toString()});
                    Resource userAccount = this.createUserAccount(accountModel, userAccountGraphUri, accountModel.createResource(this.getUriInfo().getBaseUri().resolve(ACCOUNT_PATH).toString()), jwt.getSubject(), jwt.getIssuer(), jwt.getClaim("name").asString(), email);
                    userAccount.addProperty((Property)SIOC.ACCOUNT_OF, (RDFNode)agent);
                    new Skolemizer(userAccountGraphUri.toString()).apply(accountModel);
                    Response userAccountResponse = super.post(accountModel, Boolean.valueOf(false), userAccountGraphUri);
                    if (userAccountResponse.getStatus() != Response.Status.CREATED.getStatusCode()) {
                        if (log.isErrorEnabled()) {
                            log.error("Cannot create UserAccount");
                        }
                        throw new InternalServerErrorException("Cannot create UserAccount");
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Created UserAccount for user ID: {}", (Object)jwt.getSubject());
                    }
                    userAccount = accountModel.createResource(userAccountGraphUri.toString()).getPropertyResourceValue((Property)FOAF.primaryTopic);
                    agent.addProperty((Property)FOAF.account, (RDFNode)userAccount);
                    agentModel.add(agentModel.createResource(this.getSystem().getSecretaryWebIDURI().toString()), (Property)ACL.delegates, (RDFNode)agent);
                    URI agentUri = URI.create(agent.getURI());
                    URI agentGraphUri = new URI(agentUri.getScheme(), agentUri.getSchemeSpecificPart(), null).normalize();
                    Response agentResponse = super.post(agentModel, Boolean.valueOf(false), agentGraphUri);
                    if (!agentExists && agentResponse.getStatus() != Response.Status.CREATED.getStatusCode() || agentExists && agentResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                        if (log.isErrorEnabled()) {
                            log.error("Cannot create Agent or append metadata to it");
                        }
                        throw new InternalServerErrorException("Cannot create Agent or append metadata to it");
                    }
                    Model authModel = ModelFactory.createDefaultModel();
                    URI authGraphUri = this.getUriInfo().getBaseUriBuilder().path("acl/authorizations/").path("{slug}/").build(new Object[]{UUID.randomUUID().toString()});
                    this.createAuthorization(authModel, authGraphUri, accountModel.createResource(this.getUriInfo().getBaseUri().resolve("acl/authorizations/").toString()), agentGraphUri, userAccountGraphUri);
                    new Skolemizer(authGraphUri.toString()).apply(authModel);
                    Response authResponse = super.post(authModel, Boolean.valueOf(false), authGraphUri);
                    if (authResponse.getStatus() != Response.Status.CREATED.getStatusCode()) {
                        if (log.isErrorEnabled()) {
                            log.error("Cannot create Authorization");
                        }
                        throw new InternalServerErrorException("Cannot create Authorization");
                    }
                    if (this.getApplication().getService().getProxy() != null) {
                        this.ban(this.getApplication().getService().getProxy(), jwt.getSubject());
                    }
                    this.getSystem().getEventBus().post((Object)new SignUp(this.getSystem().getSecretaryWebIDURI()));
                    if (log.isDebugEnabled()) {
                        log.debug("Created Agent for user ID: {}", (Object)jwt.getSubject());
                    }
                    this.sendEmail(agent);
                }
            }
            String path = ((AdminApplication)this.getApplication().as(AdminApplication.class)).getEndUserApplication().getBaseURI().getPath();
            NewCookie jwtCookie = new NewCookie("LinkedDataHub.id_token", idToken, path, null, 1, null, -1, false);
            URI originalReferer = URI.create(new String(Base64.getDecoder().decode(stateCookie.getValue())).split(Pattern.quote(";"))[1]);
            Response response2 = Response.seeOther((URI)originalReferer).cookie(new NewCookie[]{jwtCookie}).build();
            return response2;
        }
    }

    public boolean verify(DecodedJWT jwt) {
        return true;
    }

    public Resource createAgent(Model model, URI graphURI, Resource container, String givenName, String familyName, String email, String imgUrl) {
        Resource item = model.createResource(graphURI.toString()).addProperty(RDF.type, (RDFNode)DH.Item).addProperty((Property)SIOC.HAS_CONTAINER, (RDFNode)container).addLiteral((Property)DH.slug, (Object)UUID.randomUUID().toString());
        Resource agent = model.createResource().addProperty(RDF.type, (RDFNode)FOAF.Agent).addLiteral((Property)FOAF.givenName, (Object)givenName).addLiteral((Property)FOAF.familyName, (Object)familyName).addProperty((Property)FOAF.mbox, (RDFNode)model.createResource("mailto:" + email));
        if (imgUrl != null) {
            agent.addProperty((Property)FOAF.img, (RDFNode)model.createResource(imgUrl));
        }
        item.addProperty((Property)FOAF.primaryTopic, (RDFNode)agent);
        return agent;
    }

    public Resource createUserAccount(Model model, URI graphURI, Resource container, String id, String issuer, String name, String email) {
        Resource item = model.createResource(graphURI.toString()).addProperty(RDF.type, (RDFNode)DH.Item).addProperty((Property)SIOC.HAS_CONTAINER, (RDFNode)container).addLiteral((Property)DH.slug, (Object)UUID.randomUUID().toString());
        Resource account = model.createResource().addLiteral(DCTerms.created, (Object)GregorianCalendar.getInstance()).addProperty(RDF.type, (RDFNode)SIOC.USER_ACCOUNT).addLiteral((Property)SIOC.ID, (Object)id).addLiteral((Property)LACL.issuer, (Object)issuer).addLiteral((Property)SIOC.NAME, (Object)name).addProperty((Property)SIOC.EMAIL, (RDFNode)model.createResource("mailto:" + email));
        item.addProperty((Property)FOAF.primaryTopic, (RDFNode)account);
        return account;
    }

    public Resource createAuthorization(Model model, URI graphURI, Resource container, URI agentGraphURI, URI userAccountGraphURI) {
        Resource item = model.createResource(graphURI.toString()).addProperty(RDF.type, (RDFNode)DH.Item).addProperty((Property)SIOC.HAS_CONTAINER, (RDFNode)container).addLiteral((Property)DH.slug, (Object)UUID.randomUUID().toString());
        Resource auth = model.createResource().addProperty(RDF.type, (RDFNode)ACL.Authorization).addLiteral((Property)DH.slug, (Object)UUID.randomUUID().toString()).addProperty((Property)ACL.accessTo, (RDFNode)ResourceFactory.createResource((String)agentGraphURI.toString())).addProperty((Property)ACL.mode, (RDFNode)ACL.Read).addProperty((Property)ACL.agentClass, (RDFNode)FOAF.Agent).addProperty((Property)ACL.agentClass, (RDFNode)ACL.AuthenticatedAgent);
        item.addProperty((Property)FOAF.primaryTopic, (RDFNode)auth);
        return auth;
    }

    public void sendEmail(Resource agent) throws MessagingException, UnsupportedEncodingException {
        Object fullName;
        if (agent.hasProperty((Property)FOAF.givenName) && agent.hasProperty((Property)FOAF.familyName)) {
            String givenName = agent.getRequiredProperty((Property)FOAF.givenName).getString();
            String familyName = agent.getRequiredProperty((Property)FOAF.familyName).getString();
            fullName = givenName + " " + familyName;
        } else {
            fullName = agent.getProperty((Property)FOAF.name).getString();
        }
        String mbox = agent.getRequiredProperty((Property)FOAF.mbox).getResource().getURI().substring("mailto:".length());
        MessageBuilder builder = this.getSystem().getMessageBuilder().subject(String.format(this.getEmailSubject(), this.getEndUserApplication().getProperty(DCTerms.title).getString(), fullName)).to(mbox, (String)fullName).textBodyPart(String.format(this.getEmailText(), this.getEndUserApplication().getProperty(DCTerms.title).getString(), this.getEndUserApplication().getBase(), agent.getURI()));
        if (this.getSystem().getNotificationAddress() != null) {
            builder = builder.from(this.getSystem().getNotificationAddress());
        }
        EMailListener.submit((Message)builder.build());
    }

    public Response ban(Resource proxy, String url) {
        if (url == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        return (Response)this.getSystem().getClient().target(proxy.getURI()).request().header("X-Escaped-Request-URI", (Object)UriComponent.encode((String)url, (UriComponent.Type)UriComponent.Type.UNRESERVED)).method("BAN", Response.class);
    }

    public EndUserApplication getEndUserApplication() {
        if (this.getApplication().canAs(EndUserApplication.class)) {
            return (EndUserApplication)this.getApplication().as(EndUserApplication.class);
        }
        return ((AdminApplication)this.getApplication().as(AdminApplication.class)).getEndUserApplication();
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public Service getAgentService() {
        return this.getApplication().getService();
    }

    public String getEmailSubject() {
        return this.emailSubject;
    }

    public String getEmailText() {
        return this.emailText;
    }

    public Query getUserAccountQuery() {
        return this.getSystem().getUserAccountQuery();
    }

    public Query getAgentQuery() {
        return this.getSystem().getAgentQuery();
    }

    private String getClientID() {
        return this.clientID;
    }

    private String getClientSecret() {
        return this.clientSecret;
    }
}

