/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.resource.admin.oauth2.google;

import com.atomgraph.core.exception.ConfigurationException;
import com.atomgraph.linkeddatahub.Application;
import com.atomgraph.linkeddatahub.apps.model.AdminApplication;
import com.atomgraph.linkeddatahub.apps.model.EndUserApplication;
import com.atomgraph.linkeddatahub.model.Service;
import com.atomgraph.linkeddatahub.resource.admin.oauth2.Login;
import com.atomgraph.linkeddatahub.vocabulary.Google;
import java.math.BigInteger;
import java.net.URI;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.rdf.model.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="oauth2/authorize/google")
public class Authorize {
    private static final Logger log = LoggerFactory.getLogger(Authorize.class);
    public static final String ENDPOINT_URI = "https://accounts.google.com/o/oauth2/v2/auth";
    public static final String SCOPE = "openid email profile";
    public static final String COOKIE_NAME = "LinkedDataHub.state";
    public static final String REFERER_PARAM_NAME = "referer";
    private final UriInfo uriInfo;
    private final com.atomgraph.linkeddatahub.apps.model.Application application;
    private final Ontology ontology;
    private final String clientID;

    @Inject
    public Authorize(@Context UriInfo uriInfo, Optional<Service> service, com.atomgraph.linkeddatahub.apps.model.Application application, Optional<Ontology> ontology, Application system) {
        this.uriInfo = uriInfo;
        this.application = application;
        this.ontology = ontology.get();
        if (log.isDebugEnabled()) {
            log.debug("Constructing {}", this.getClass());
        }
        this.clientID = (String)system.getProperty(Google.clientID.getURI());
    }

    @GET
    public Response get() {
        if (this.getClientID() == null) {
            throw new ConfigurationException((Property)Google.clientID);
        }
        String originUri = this.getUriInfo().getQueryParameters().containsKey((Object)REFERER_PARAM_NAME) ? (String)this.getUriInfo().getQueryParameters().getFirst((Object)REFERER_PARAM_NAME) : this.getEndUserApplication().getBase().getURI();
        URI redirectUri = this.getUriInfo().getBaseUriBuilder().path(Login.class).build(new Object[0]);
        String state = new BigInteger(130, new SecureRandom()).toString(32);
        String stateValue = Base64.getEncoder().encodeToString((state + ";" + originUri).getBytes());
        NewCookie stateCookie = new NewCookie(COOKIE_NAME, stateValue, this.getEndUserApplication().getBaseURI().getPath(), null, 1, null, -1, false);
        UriBuilder authUriBuilder = UriBuilder.fromUri((String)ENDPOINT_URI).queryParam("response_type", new Object[]{"code"}).queryParam("access_type", new Object[]{"offline"}).queryParam("client_id", new Object[]{this.getClientID()}).queryParam("redirect_uri", new Object[]{redirectUri}).queryParam("scope", new Object[]{SCOPE}).queryParam("state", new Object[]{stateValue}).queryParam("nonce", new Object[]{UUID.randomUUID().toString()});
        return Response.seeOther((URI)authUriBuilder.build(new Object[0])).cookie(new NewCookie[]{stateCookie}).build();
    }

    public EndUserApplication getEndUserApplication() {
        if (this.getApplication().canAs(EndUserApplication.class)) {
            return (EndUserApplication)this.getApplication().as(EndUserApplication.class);
        }
        return ((AdminApplication)this.getApplication().as(AdminApplication.class)).getEndUserApplication();
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public com.atomgraph.linkeddatahub.apps.model.Application getApplication() {
        return this.application;
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    private String getClientID() {
        return this.clientID;
    }
}

