/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.resource.upload;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.linkeddatahub.Application;
import com.atomgraph.linkeddatahub.MediaType;
import com.atomgraph.linkeddatahub.model.Service;
import com.atomgraph.linkeddatahub.server.model.impl.GraphStoreImpl;
import com.atomgraph.linkeddatahub.server.security.AgentContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.Providers;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.DCTerms;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Item
extends GraphStoreImpl {
    private static final Logger log = LoggerFactory.getLogger(Item.class);
    private final Resource resource;

    @Inject
    public Item(@Context Request request, @Context UriInfo uriInfo, MediaTypes mediaTypes, com.atomgraph.linkeddatahub.apps.model.Application application, Optional<Ontology> ontology, Optional<Service> service, @Context SecurityContext securityContext, Optional<AgentContext> agentContext, @Context Providers providers, Application system) {
        super(request, uriInfo, mediaTypes, application, ontology, service, securityContext, agentContext, providers, system);
        this.resource = ModelFactory.createDefaultModel().createResource(uriInfo.getAbsolutePath().toString());
        if (log.isDebugEnabled()) {
            log.debug("Constructing {}", this.getClass());
        }
    }

    @PostConstruct
    public void init() {
        this.getResource().getModel().add(this.describe());
    }

    @GET
    public Response get(@QueryParam(value="default") @DefaultValue(value="false") Boolean defaultGraph, @QueryParam(value="graph") URI graphUri) {
        return this.getResponseBuilder(this.getResource().getModel(), graphUri).build();
    }

    public Response.ResponseBuilder getResponseBuilder(Model model, URI graphUri) {
        List variants = com.atomgraph.core.model.impl.Response.getVariantListBuilder((List)this.getWritableMediaTypes(Model.class), Collections.emptyList(), (List)this.getEncodings()).add().build();
        Variant variant = this.getRequest().selectVariant(variants);
        if (variant == null) {
            if (log.isTraceEnabled()) {
                log.trace("Requested Variant {} is not on the list of acceptable Response Variants: {}", (Object)variant, (Object)variants);
            }
            throw new NotAcceptableException();
        }
        if (this.getMediaType().isCompatible(variant.getMediaType())) {
            URI fileURI = this.getSystem().getUploadRoot().resolve(this.getUriInfo().getPath());
            File file = new File(fileURI);
            if (!file.exists()) {
                throw new NotFoundException((Throwable)new FileNotFoundException("File '" + this.getUriInfo().getPath() + "' not found"));
            }
            return super.getResponseBuilder(model, graphUri).entity((Object)file).type(variant.getMediaType());
        }
        return super.getResponseBuilder(model, graphUri);
    }

    public javax.ws.rs.core.MediaType getMediaType() {
        Resource format = this.getResource().getPropertyResourceValue(DCTerms.format);
        if (format == null) {
            if (log.isErrorEnabled()) {
                log.error("File '{}' does not have a media type", (Object)this.getResource());
            }
            throw new IllegalStateException("File does not have a media type (dct:format)");
        }
        return MediaType.valueOf((Resource)format);
    }

    public List<javax.ws.rs.core.MediaType> getWritableMediaTypes(Class clazz) {
        ArrayList<javax.ws.rs.core.MediaType> list = new ArrayList<javax.ws.rs.core.MediaType>();
        list.add(this.getMediaType());
        return list;
    }

    public Model describe() {
        return this.getService().getSPARQLClient().loadModel(QueryFactory.create((String)("DESCRIBE <" + this.getURI() + ">")));
    }

    public URI getURI() {
        return this.getUriInfo().getAbsolutePath();
    }

    public Resource getResource() {
        return this.resource;
    }
}

