/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.exception;

import com.atomgraph.linkeddatahub.server.io.CollectingErrorHandler;
import com.atomgraph.linkeddatahub.vocabulary.LDH;
import com.atomgraph.server.exception.ModelException;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class RDFSyntaxException
extends ModelException {
    private final List<CollectingErrorHandler.Violation> violations;

    public RDFSyntaxException(List<CollectingErrorHandler.Violation> violations, Model model) {
        super(model);
        this.violations = violations;
        for (CollectingErrorHandler.Violation violation : violations) {
            Resource violationRes = model.createResource().addProperty(RDF.type, (RDFNode)LDH.URISyntaxViolation).addLiteral(RDFS.label, (Object)violation.getMessage());
            if (!violation.getMessage().startsWith("Bad IRI: <") || !violation.getMessage().contains("Code: 57")) continue;
            String value = violation.getMessage().substring(violation.getMessage().lastIndexOf("<") + 1, violation.getMessage().lastIndexOf(">"));
            violationRes.addLiteral((Property)LDH.violationValue, (Object)value);
        }
    }

    public List<CollectingErrorHandler.Violation> getViolations() {
        return this.violations;
    }
}

