/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.exception.auth;

import com.atomgraph.linkeddatahub.model.auth.Agent;
import java.net.URI;
import org.apache.jena.rdf.model.Resource;

public class AuthorizationException
extends RuntimeException {
    private final URI absolutePath;
    private final Resource mode;
    private final Resource agent;

    public AuthorizationException(String message, URI absolutePath, Resource mode, Agent agent) {
        super(message);
        if (absolutePath == null) {
            throw new IllegalArgumentException("Request URI cannot be null");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Request mode Resource cannot be null");
        }
        this.absolutePath = absolutePath;
        this.mode = mode;
        this.agent = agent;
    }

    public AuthorizationException(String message, URI absolutePath, Resource mode) {
        this(message, absolutePath, mode, null);
    }

    public URI getAbsolutePath() {
        return this.absolutePath;
    }

    public Resource getMode() {
        return this.mode;
    }

    public Resource getAgent() {
        return this.agent;
    }
}

