/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.exception.auth.webid;

import java.security.interfaces.RSAPublicKey;
import javax.ws.rs.NotAuthorizedException;

public class InvalidWebIDPublicKeyException
extends NotAuthorizedException {
    private final RSAPublicKey publicKey;
    private final String webID;

    public InvalidWebIDPublicKeyException(RSAPublicKey publicKey, String webID) {
        super((Object)("Client certificate public key did not match public key of WebID '" + webID + "'"), new Object[0]);
        this.publicKey = publicKey;
        this.webID = webID;
    }

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    public String getWebID() {
        return this.webID;
    }
}

