/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.filter.request;

import com.atomgraph.client.vocabulary.AC;
import com.atomgraph.linkeddatahub.Application;
import com.atomgraph.linkeddatahub.apps.model.AdminApplication;
import com.atomgraph.linkeddatahub.apps.model.Dataset;
import com.atomgraph.linkeddatahub.apps.model.EndUserApplication;
import com.atomgraph.linkeddatahub.vocabulary.LAPP;
import com.atomgraph.linkeddatahub.writer.Mode;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import org.apache.jena.rdf.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreMatching
@Priority(value=700)
public class ApplicationFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(ApplicationFilter.class);
    @Inject
    Application system;

    public void filter(ContainerRequestContext request) throws IOException {
        Resource appResource = this.getSystem().matchApp((Resource)LAPP.Application, request.getUriInfo().getAbsolutePath());
        if (appResource == null) {
            throw new IllegalStateException("Request URI '" + request.getUriInfo().getAbsolutePath() + "' has not matched any lapp:Application");
        }
        if (!(appResource.canAs(com.atomgraph.linkeddatahub.apps.model.Application.class) || appResource.canAs(EndUserApplication.class) || appResource.canAs(AdminApplication.class))) {
            throw new IllegalStateException("Resource <" + appResource + "> cannot be cast to lapp:Application");
        }
        com.atomgraph.linkeddatahub.apps.model.Application app = (com.atomgraph.linkeddatahub.apps.model.Application)appResource.as(com.atomgraph.linkeddatahub.apps.model.Application.class);
        request.setProperty(LAPP.Application.getURI(), (Object)app);
        request.setRequestUri(app.getBaseURI(), request.getUriInfo().getRequestUri());
        if (request.getUriInfo().getQueryParameters().containsKey((Object)AC.accept.getLocalName())) {
            request.getHeaders().putSingle((Object)"Accept", (Object)((String)request.getUriInfo().getQueryParameters().getFirst((Object)AC.accept.getLocalName())));
        }
        if (request.getUriInfo().getQueryParameters().containsKey((Object)AC.mode.getLocalName())) {
            List modeUris = (List)request.getUriInfo().getQueryParameters().get((Object)AC.mode.getLocalName());
            List modes = modeUris.stream().map(Mode::new).collect(Collectors.toList());
            request.setProperty(AC.mode.getURI(), modes);
        } else {
            request.setProperty(AC.mode.getURI(), Collections.emptyList());
        }
        Resource datasetResource = this.getSystem().matchDataset((Resource)LAPP.Dataset, request.getUriInfo().getAbsolutePath());
        if (datasetResource != null) {
            if (!datasetResource.canAs(Dataset.class)) {
                throw new IllegalStateException("Resource <" + datasetResource + "> cannot be cast to lapp:Dataset");
            }
            Dataset dataset = (Dataset)datasetResource.as(Dataset.class);
            if (log.isDebugEnabled()) {
                log.debug("Request URI <{}> has matched a lapp:Dataset <{}>", (Object)request.getUriInfo().getRequestUri(), (Object)dataset.getURI());
            }
            request.setProperty(LAPP.Dataset.getURI(), Optional.of(dataset));
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Request URI <{}> has not matched any lapp:Dataset", (Object)request.getUriInfo().getRequestUri());
            }
            request.setProperty(LAPP.Dataset.getURI(), Optional.empty());
        }
    }

    public Application getSystem() {
        return this.system;
    }
}

