/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.filter.request;

import com.atomgraph.core.client.SPARQLClient;
import com.atomgraph.linkeddatahub.Application;
import com.atomgraph.linkeddatahub.apps.model.Dataset;
import com.atomgraph.linkeddatahub.apps.model.EndUserApplication;
import com.atomgraph.linkeddatahub.client.SesameProtocolClient;
import com.atomgraph.linkeddatahub.model.Service;
import com.atomgraph.linkeddatahub.server.security.AgentContext;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthenticationFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationFilter.class);
    public static final String ON_BEHALF_OF = "On-Behalf-Of";
    @Inject
    Application system;
    @Inject
    Provider<com.atomgraph.linkeddatahub.apps.model.Application> app;
    @Inject
    Provider<Optional<Dataset>> dataset;

    public abstract String getScheme();

    public abstract void login(com.atomgraph.linkeddatahub.apps.model.Application var1, ContainerRequestContext var2);

    public abstract void logout(com.atomgraph.linkeddatahub.apps.model.Application var1, ContainerRequestContext var2);

    @Nullable
    public abstract SecurityContext authenticate(ContainerRequestContext var1);

    public void filter(ContainerRequestContext request) throws IOException {
        if (request == null) {
            throw new IllegalArgumentException("ContainerRequestContext cannot be null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Authenticating request URI: {}", (Object)request.getUriInfo().getRequestUri());
        }
        if (request.getSecurityContext().getUserPrincipal() != null) {
            return;
        }
        if (this.getDataset().isPresent()) {
            return;
        }
        SecurityContext securityContext = this.authenticate(request);
        if (securityContext == null) {
            return;
        }
        request.setSecurityContext(securityContext);
        request.setProperty(AgentContext.class.getCanonicalName(), (Object)securityContext);
    }

    protected Service getAgentService() {
        return this.getApplication().canAs(EndUserApplication.class) ? ((EndUserApplication)this.getApplication().as(EndUserApplication.class)).getAdminApplication().getService() : this.getApplication().getService();
    }

    protected Model loadModel(ParameterizedSparqlString pss, QuerySolutionMap qsm, Service service) {
        Response cr;
        if (pss == null) {
            throw new IllegalArgumentException("ParameterizedSparqlString cannot be null");
        }
        if (qsm == null) {
            throw new IllegalArgumentException("QuerySolutionMap cannot be null");
        }
        if (service == null) {
            throw new IllegalArgumentException("Service cannot be null");
        }
        SPARQLClient sPARQLClient = service.getSPARQLClient();
        if (sPARQLClient instanceof SesameProtocolClient) {
            SesameProtocolClient sesameProtocolClient = (SesameProtocolClient)sPARQLClient;
            cr = sesameProtocolClient.query(pss.asQuery(), Model.class, qsm);
            try {
                Model model = (Model)cr.readEntity(Model.class);
                return model;
            }
            finally {
                if (cr != null) {
                    cr.close();
                }
            }
        }
        pss.setParams(qsm);
        cr = service.getSPARQLClient().query(pss.asQuery(), Model.class);
        try {
            Model model = (Model)cr.readEntity(Model.class);
            return model;
        }
        finally {
            if (cr != null) {
                cr.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource getResourceByPropertyValue(Model model, Property property, RDFNode value) {
        if (model == null) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        if (property == null) {
            throw new IllegalArgumentException("Property cannot be null");
        }
        try (ResIterator it = model.listSubjectsWithProperty(property, value);){
            if (it.hasNext()) {
                Resource resource = (Resource)it.next();
                return resource;
            }
        }
        return null;
    }

    public com.atomgraph.linkeddatahub.apps.model.Application getApplication() {
        return (com.atomgraph.linkeddatahub.apps.model.Application)this.app.get();
    }

    public Optional<Dataset> getDataset() {
        return (Optional)this.dataset.get();
    }

    public Application getSystem() {
        return this.system;
    }
}

