/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.filter.request;

import com.atomgraph.client.vocabulary.AC;
import com.atomgraph.core.client.SPARQLClient;
import com.atomgraph.core.vocabulary.SD;
import com.atomgraph.linkeddatahub.Application;
import com.atomgraph.linkeddatahub.apps.model.Dataset;
import com.atomgraph.linkeddatahub.apps.model.EndUserApplication;
import com.atomgraph.linkeddatahub.client.SesameProtocolClient;
import com.atomgraph.linkeddatahub.model.Service;
import com.atomgraph.linkeddatahub.model.auth.Agent;
import com.atomgraph.linkeddatahub.server.exception.auth.AuthorizationException;
import com.atomgraph.linkeddatahub.server.security.AuthorizationContext;
import com.atomgraph.linkeddatahub.vocabulary.ACL;
import com.atomgraph.processor.vocabulary.LDT;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Response;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreMatching
@Priority(value=5100)
public class AuthorizationFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationFilter.class);
    public static final Map<String, Resource> ACCESS_MODES;
    @Inject
    Application system;
    @Inject
    Provider<com.atomgraph.linkeddatahub.apps.model.Application> app;
    @Inject
    Provider<Optional<Dataset>> dataset;
    private ParameterizedSparqlString authQuery;
    private ParameterizedSparqlString ownerAuthQuery;

    @PostConstruct
    public void init() {
        this.authQuery = new ParameterizedSparqlString(this.getSystem().getAuthQuery().toString());
        this.ownerAuthQuery = new ParameterizedSparqlString(this.getSystem().getOwnerAuthQuery().toString());
    }

    public void filter(ContainerRequestContext request) throws IOException {
        if (request == null) {
            throw new IllegalArgumentException("ContainerRequestContext cannot be null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Authorizing request URI: {}", (Object)request.getUriInfo().getRequestUri());
        }
        if (request.getMethod().equals("GET") && request.getUriInfo().getQueryParameters().containsKey((Object)AC.uri.getLocalName())) {
            String proxiedURI = (String)request.getUriInfo().getQueryParameters().getFirst((Object)AC.uri.getLocalName());
            if (this.getSystem().getDataManager().isMapped(proxiedURI)) {
                return;
            }
        }
        Resource accessMode = (Resource)ACCESS_MODES.get(request.getMethod());
        if (log.isDebugEnabled()) {
            log.debug("Request method: {} ACL access mode: {}", (Object)request.getMethod(), (Object)accessMode);
        }
        if (accessMode == null) {
            if (log.isWarnEnabled()) {
                log.warn("Skipping authentication/authorization, request method not recognized: {}", (Object)request.getMethod());
            }
            return;
        }
        if (this.getApplication().isReadOnly()) {
            if (request.getMethod().equals("GET") || request.getMethod().equals("HEAD")) {
                if (log.isTraceEnabled()) {
                    log.trace("App is read-only, skipping authorization for request URI: {}", (Object)request.getUriInfo().getAbsolutePath());
                }
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace("Write access not authorized (app is read-only) for request URI: {}", (Object)request.getUriInfo().getAbsolutePath());
            }
            throw new AuthorizationException("Write access not authorized (app is read-only)", request.getUriInfo().getAbsolutePath(), accessMode);
        }
        if (this.getDataset().isPresent()) {
            return;
        }
        Agent agent = request.getSecurityContext().getUserPrincipal() instanceof Agent ? (Agent)request.getSecurityContext().getUserPrincipal() : null;
        Resource authorization = this.authorize(request, (Resource)agent, accessMode);
        if (authorization == null) {
            if (log.isTraceEnabled()) {
                log.trace("Access not authorized for request URI: {} and access mode: {}", (Object)request.getUriInfo().getAbsolutePath(), (Object)accessMode);
            }
            throw new AuthorizationException("Access not authorized for request URI", request.getUriInfo().getAbsolutePath(), accessMode);
        }
        request.setProperty(AuthorizationContext.class.getCanonicalName(), (Object)new AuthorizationContext(authorization.getModel()));
    }

    public QuerySolutionMap getAuthorizationParams(Resource absolutePath, Resource agent, Resource accessMode) {
        QuerySolutionMap qsm = new QuerySolutionMap();
        qsm.add("this", (RDFNode)absolutePath);
        qsm.add("Mode", (RDFNode)accessMode);
        qsm.add(LDT.Ontology.getLocalName(), (RDFNode)this.getApplication().getOntology());
        qsm.add(LDT.base.getLocalName(), (RDFNode)this.getApplication().getBase());
        if (agent != null) {
            qsm.add("AuthenticatedAgentClass", (RDFNode)ACL.AuthenticatedAgent);
            qsm.add("agent", (RDFNode)agent);
        } else {
            qsm.add("AuthenticatedAgentClass", (RDFNode)RDFS.Resource);
            qsm.add("agent", (RDFNode)RDFS.Resource);
        }
        return qsm;
    }

    public Resource authorize(ContainerRequestContext request, Resource agent, Resource accessMode) {
        return this.authorize(this.getAuthorizationParams(ResourceFactory.createResource((String)request.getUriInfo().getAbsolutePath().toString()), agent, accessMode));
    }

    public Resource authorize(QuerySolutionMap qsm) {
        Model authModel = this.loadAuth(qsm);
        Resource authorization = this.getResourceByPropertyValue(authModel, (Property)ACL.mode, null);
        if (authorization == null) {
            authorization = this.getResourceByPropertyValue(authModel, ResourceFactory.createProperty((String)"https://w3id.org/atomgraph/linkeddatahub/admin/acl#accessProperty"), null);
        }
        return authorization;
    }

    protected Model loadAuth(QuerySolutionMap qsm) {
        ParameterizedSparqlString pss;
        if (qsm == null) {
            throw new IllegalArgumentException("QuerySolutionMap cannot be null");
        }
        ParameterizedSparqlString parameterizedSparqlString = pss = this.getApplication().canAs(EndUserApplication.class) ? this.getAuthQuery() : this.getOwnerAuthQuery();
        if (this.getApplication().canAs(EndUserApplication.class)) {
            pss.setIri(SD.endpoint.getLocalName(), this.getApplication().getService().getSPARQLEndpoint().toString());
        }
        return this.loadModel(this.getAdminService(), pss, qsm);
    }

    protected Model loadModel(Service service, ParameterizedSparqlString pss, QuerySolutionMap qsm) {
        Response cr;
        if (service == null) {
            throw new IllegalArgumentException("Service cannot be null");
        }
        if (pss == null) {
            throw new IllegalArgumentException("ParameterizedSparqlString cannot be null");
        }
        if (qsm == null) {
            throw new IllegalArgumentException("QuerySolutionMap cannot be null");
        }
        SPARQLClient sPARQLClient = service.getSPARQLClient();
        if (sPARQLClient instanceof SesameProtocolClient) {
            SesameProtocolClient sesameProtocolClient = (SesameProtocolClient)sPARQLClient;
            cr = sesameProtocolClient.query(pss.asQuery(), Model.class, qsm);
            try {
                Model model = (Model)cr.readEntity(Model.class);
                return model;
            }
            finally {
                if (cr != null) {
                    cr.close();
                }
            }
        }
        pss.setParams(qsm);
        cr = service.getSPARQLClient().query(pss.asQuery(), Model.class);
        try {
            Model model = (Model)cr.readEntity(Model.class);
            return model;
        }
        finally {
            if (cr != null) {
                cr.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource getResourceByPropertyValue(Model model, Property property, RDFNode value) {
        if (model == null) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        if (property == null) {
            throw new IllegalArgumentException("Property cannot be null");
        }
        try (ResIterator it = model.listSubjectsWithProperty(property, value);){
            if (it.hasNext()) {
                Resource resource = (Resource)it.next();
                return resource;
            }
        }
        return null;
    }

    protected Service getAdminService() {
        return this.getApplication().canAs(EndUserApplication.class) ? ((EndUserApplication)this.getApplication().as(EndUserApplication.class)).getAdminApplication().getService() : this.getApplication().getService();
    }

    public com.atomgraph.linkeddatahub.apps.model.Application getApplication() {
        return (com.atomgraph.linkeddatahub.apps.model.Application)this.app.get();
    }

    public Optional<Dataset> getDataset() {
        return (Optional)this.dataset.get();
    }

    public Application getSystem() {
        return this.system;
    }

    public ParameterizedSparqlString getAuthQuery() {
        return this.authQuery.copy();
    }

    public ParameterizedSparqlString getOwnerAuthQuery() {
        return this.ownerAuthQuery.copy();
    }

    static {
        HashMap<String, OntClass> accessModes = new HashMap<String, OntClass>();
        accessModes.put("GET", ACL.Read);
        accessModes.put("HEAD", ACL.Read);
        accessModes.put("POST", ACL.Append);
        accessModes.put("PUT", ACL.Write);
        accessModes.put("DELETE", ACL.Write);
        accessModes.put("PATCH", ACL.Write);
        ACCESS_MODES = Collections.unmodifiableMap(accessModes);
    }
}

