/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.filter.request;

import com.atomgraph.linkeddatahub.Application;
import com.atomgraph.linkeddatahub.server.exception.PayloadTooLargeException;
import com.atomgraph.linkeddatahub.server.util.stream.RejectTooLargeInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreMatching
@Priority(value=100)
public class ContentLengthLimitFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(ContentLengthLimitFilter.class);
    @Inject
    Application system;

    public void filter(ContainerRequestContext crc) throws IOException {
        if (this.getSystem().getMaxContentLength() == null) {
            return;
        }
        if (!crc.getMethod().equals("POST") && !crc.getMethod().equals("PUT")) {
            return;
        }
        String contentLengthString = (String)crc.getHeaders().getFirst((Object)"Content-Length");
        if (contentLengthString == null) {
            crc.setEntityStream((InputStream)new RejectTooLargeInputStream(crc.getEntityStream(), (long)this.getSystem().getMaxContentLength().intValue()));
            return;
        }
        int contentLength = Integer.valueOf(contentLengthString);
        if (contentLength > this.getSystem().getMaxContentLength()) {
            if (log.isDebugEnabled()) {
                log.debug("POST or PUT request rejected due to Content-Length: {} which is larger than the configured limit {}", (Object)contentLength, (Object)this.getSystem().getMaxContentLength());
            }
            throw new PayloadTooLargeException((long)this.getSystem().getMaxContentLength().intValue(), (long)contentLength);
        }
        crc.setEntityStream((InputStream)new RejectTooLargeInputStream(crc.getEntityStream(), (long)this.getSystem().getMaxContentLength().intValue()));
    }

    public Application getSystem() {
        return this.system;
    }
}

