/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.filter.request;

import com.atomgraph.core.MediaType;
import com.atomgraph.linkeddatahub.server.interceptor.RDFPostCleanupInterceptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import nu.xom.ParsingException;
import org.apache.jena.vocabulary.RDF;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.server.ContainerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=4000)
public class MultipartRDFPostCleanupFilter
extends RDFPostCleanupInterceptor
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(MultipartRDFPostCleanupFilter.class);
    @Context
    Providers providers;

    public void filter(ContainerRequestContext context) throws IOException {
        if (context.getMediaType() != null && context.getMediaType().isCompatible(MediaType.MULTIPART_FORM_DATA_TYPE)) {
            try {
                ContainerRequest request = (ContainerRequest)context;
                FormDataMultiPart multiPart = (FormDataMultiPart)request.readEntity(FormDataMultiPart.class);
                this.fixRDFPostMultiPart(multiPart, StandardCharsets.UTF_8);
                MultivaluedHashMap headers = new MultivaluedHashMap();
                request.getHeaders().entrySet().stream().forEach(arg_0 -> MultipartRDFPostCleanupFilter.lambda$filter$1((MultivaluedMap)headers, arg_0));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                MessageBodyWriter writer = this.getProviders().getMessageBodyWriter(FormDataMultiPart.class, null, null, request.getMediaType());
                writer.writeTo((Object)multiPart, FormDataMultiPart.class, null, null, request.getMediaType(), (MultivaluedMap)headers, (OutputStream)baos);
                request.setEntityStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
            }
            catch (ParsingException ex) {
                throw new IOException(ex);
            }
        }
    }

    public FormDataMultiPart fixRDFPostMultiPart(FormDataMultiPart multiPart, Charset charset) throws IOException, ParsingException {
        String charsetName = charset.name();
        for (int i = 0; i < multiPart.getBodyParts().size(); ++i) {
            String xml;
            FormDataBodyPart bodyPart = (FormDataBodyPart)multiPart.getBodyParts().get(i);
            if (bodyPart.getContentDisposition().getFileName() != null && !bodyPart.getContentDisposition().getFileName().isEmpty()) {
                if (!log.isDebugEnabled()) continue;
                log.debug("FormDataBodyPart name: {} value: {}", (Object)bodyPart.getName(), (Object)bodyPart.getContentDisposition().getFileName());
                continue;
            }
            if (!bodyPart.isSimple() || bodyPart.getValue().isEmpty()) continue;
            if (log.isDebugEnabled()) {
                log.debug("FormDataBodyPart name: {} value: {}", (Object)bodyPart.getName(), (Object)bodyPart.getValue());
            }
            if (i >= 1 && i + 1 < multiPart.getBodyParts().size() && ((FormDataBodyPart)multiPart.getBodyParts().get(i - 1)).getName().equals("pu") && ((FormDataBodyPart)multiPart.getBodyParts().get(i - 1)).getValue() != null && ((FormDataBodyPart)multiPart.getBodyParts().get(i - 1)).getValue().equals(RDF.value.getURI()) && bodyPart.getName().equals("ol") && bodyPart.getValue() != null && ((FormDataBodyPart)multiPart.getBodyParts().get(i + 1)).getName().equals("lt") && ((FormDataBodyPart)multiPart.getBodyParts().get(i + 1)).getValue() != null && ((FormDataBodyPart)multiPart.getBodyParts().get(i + 1)).getValue().equals(RDF.xmlLiteral.getURI())) {
                xml = bodyPart.getValue();
                bodyPart.setValue(this.canonicalizeXML(this.wrapXHTML(xml), charsetName));
            }
            if (i < 2 || !((FormDataBodyPart)multiPart.getBodyParts().get(i - 2)).getName().equals("pu") || ((FormDataBodyPart)multiPart.getBodyParts().get(i - 2)).getValue() == null || !((FormDataBodyPart)multiPart.getBodyParts().get(i - 2)).getValue().equals(RDF.value.getURI()) || !((FormDataBodyPart)multiPart.getBodyParts().get(i - 1)).getName().equals("lt") || ((FormDataBodyPart)multiPart.getBodyParts().get(i - 1)).getValue() == null || !((FormDataBodyPart)multiPart.getBodyParts().get(i - 1)).getValue().equals(RDF.xmlLiteral.getURI()) || !bodyPart.getName().equals("ol") || bodyPart.getValue() == null) continue;
            xml = bodyPart.getValue();
            bodyPart.setValue(this.canonicalizeXML(this.wrapXHTML(xml), charsetName));
        }
        return multiPart;
    }

    public Providers getProviders() {
        return this.providers;
    }

    private static /* synthetic */ void lambda$filter$1(MultivaluedMap headers, Map.Entry entry) {
        ((List)entry.getValue()).forEach(value -> headers.add((Object)((String)entry.getKey()), value));
    }
}

