/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.filter.request;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.linkeddatahub.Application;
import com.atomgraph.linkeddatahub.apps.model.EndUserApplication;
import com.atomgraph.linkeddatahub.server.util.OntologyModelGetter;
import com.atomgraph.linkeddatahub.vocabulary.LAPP;
import com.atomgraph.processor.exception.OntologyException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import org.apache.jena.ontology.OntDocumentManager;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.ModelGetter;
import org.apache.jena.util.FileManager;
import org.apache.jena.vocabulary.OWL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@PreMatching
@Priority(value=800)
public class OntologyFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(OntologyFilter.class);
    @Inject
    Application system;

    public void filter(ContainerRequestContext crc) throws IOException {
        crc.setProperty(OWL.Ontology.getURI(), (Object)this.getOntology(crc));
    }

    public Optional<Ontology> getOntology(ContainerRequestContext crc) {
        com.atomgraph.linkeddatahub.apps.model.Application app = this.getApplication(crc);
        try {
            return Optional.ofNullable(this.getOntology(app));
        }
        catch (OntologyException ex) {
            return Optional.empty();
        }
    }

    public Ontology getOntology(com.atomgraph.linkeddatahub.apps.model.Application app) {
        if (app.getOntology() == null) {
            return null;
        }
        return this.getOntology(app, app.getOntology().getURI());
    }

    public Ontology getOntology(com.atomgraph.linkeddatahub.apps.model.Application app, String uri) {
        OntModelSpec ontModelSpec;
        if (app == null) {
            throw new IllegalArgumentException("Application string cannot be null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Ontology URI string cannot be null");
        }
        if (app.canAs(EndUserApplication.class)) {
            ontModelSpec = new OntModelSpec(this.getSystem().getOntModelSpec((EndUserApplication)app.as(EndUserApplication.class)));
            if (!ontModelSpec.getDocumentManager().getFileManager().hasCachedModel(uri)) {
                OntologyModelGetter modelGetter = new OntologyModelGetter((EndUserApplication)app.as(EndUserApplication.class), ontModelSpec, this.getSystem().getOntologyQuery(), this.getSystem().getNoCertClient(), (MediaTypes)this.getSystem().getMediaTypes());
                ontModelSpec.setImportModelGetter((ModelGetter)modelGetter);
                if (log.isDebugEnabled()) {
                    log.debug("Started loading ontology with URI '{}' from the admin dataset", (Object)uri);
                }
                Model baseModel = modelGetter.getModel(uri);
                OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)ontModelSpec, (Model)baseModel);
                OntModel materializedModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
                materializedModel.add((Model)ontModel);
                ontModel.getDocumentManager().addModel(uri, (Model)materializedModel, true);
                ontModel.listImportedOntologyURIs(true).forEach(importURI -> OntologyFilter.addDocumentModel((OntDocumentManager)ontModel.getDocumentManager(), (String)importURI));
                if (log.isDebugEnabled()) {
                    log.debug("Finished loading ontology with URI '{}' from the admin dataset", (Object)uri);
                }
            }
        } else {
            ontModelSpec = new OntModelSpec(this.getSystem().getOntModelSpec());
            FileManager fileManager = ontModelSpec.getDocumentManager().getFileManager();
            if (!fileManager.hasCachedModel(uri)) {
                try {
                    URI ontologyURI = URI.create(uri);
                    URI ontDocURI = new URI(ontologyURI.getScheme(), ontologyURI.getSchemeSpecificPart(), null).normalize();
                    Model baseModel = fileManager.loadModel(uri, ontDocURI.toString(), null);
                    OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)ontModelSpec, (Model)baseModel);
                    ontModel.getDocumentManager().addModel(uri, (Model)ontModel, true);
                }
                catch (URISyntaxException ex) {
                    if (log.isErrorEnabled()) {
                        log.error("Ontology URI syntax error: {}", (Object)ex.getInput());
                    }
                    throw new InternalServerErrorException((Throwable)ex);
                }
            }
        }
        return ontModelSpec.getDocumentManager().getOntology(uri, ontModelSpec).getOntology(uri);
    }

    public static void addDocumentModel(OntDocumentManager odm, String importURI) {
        try {
            URI ontologyURI = URI.create(importURI);
            URI docURI = new URI(ontologyURI.getScheme(), ontologyURI.getSchemeSpecificPart(), null).normalize();
            String mappedURI = odm.getFileManager().mapURI(docURI.toString());
            if (!odm.getFileManager().hasCachedModel(docURI.toString()) && mappedURI.equals(docURI.toString())) {
                Model importModel = odm.getModel(importURI);
                if (importModel == null) {
                    throw new IllegalArgumentException("Import model is not cached");
                }
                odm.addModel(docURI.toString(), importModel, true);
            }
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public com.atomgraph.linkeddatahub.apps.model.Application getApplication(ContainerRequestContext crc) {
        return (com.atomgraph.linkeddatahub.apps.model.Application)crc.getProperty(LAPP.Application.getURI());
    }

    public Application getSystem() {
        return this.system;
    }
}

