/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.filter.request.auth;

import com.atomgraph.linkeddatahub.apps.model.AdminApplication;
import com.atomgraph.linkeddatahub.apps.model.Application;
import com.atomgraph.linkeddatahub.apps.model.EndUserApplication;
import com.atomgraph.linkeddatahub.model.auth.Agent;
import com.atomgraph.linkeddatahub.server.filter.request.AuthenticationFilter;
import com.atomgraph.linkeddatahub.server.security.IDTokenSecurityContext;
import com.atomgraph.linkeddatahub.vocabulary.FOAF;
import com.atomgraph.linkeddatahub.vocabulary.Google;
import com.atomgraph.linkeddatahub.vocabulary.LACL;
import com.atomgraph.processor.vocabulary.SIOC;
import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.json.JsonObject;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreMatching
@Priority(value=5010)
public class IDTokenFilter
extends AuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(IDTokenFilter.class);
    public static final String AUTH_SCHEME = "JWT";
    public static final String COOKIE_NAME = "LinkedDataHub.id_token";
    private String clientID;
    private String clientSecret;
    private ParameterizedSparqlString userAccountQuery;

    @PostConstruct
    public void init() {
        this.userAccountQuery = new ParameterizedSparqlString(this.getSystem().getUserAccountQuery().toString());
        this.clientID = (String)this.getSystem().getProperty(Google.clientID.getURI());
        this.clientSecret = (String)this.getSystem().getProperty(Google.clientSecret.getURI());
    }

    public String getScheme() {
        return AUTH_SCHEME;
    }

    public void filter(ContainerRequestContext request) throws IOException {
        if (request.getSecurityContext().getUserPrincipal() != null) {
            return;
        }
        if (!this.getApplication().canAs(EndUserApplication.class) && !this.getApplication().canAs(AdminApplication.class)) {
            return;
        }
        if (request.getUriInfo().getAbsolutePath().equals(this.getLoginURL())) {
            return;
        }
        if (request.getUriInfo().getAbsolutePath().equals(this.getAuthorizeGoogleURL())) {
            return;
        }
        super.filter(request);
    }

    public SecurityContext authenticate(ContainerRequestContext request) {
        Model agentModel;
        ParameterizedSparqlString pss = this.getUserAccountQuery();
        String jwtString = this.getJWTToken(request);
        if (jwtString == null) {
            return null;
        }
        DecodedJWT jwt = JWT.decode((String)jwtString);
        if (jwt.getExpiresAt().before(new Date())) {
            String refreshToken = this.getSystem().getRefreshToken(jwt.getSubject());
            if (refreshToken != null) {
                if (log.isDebugEnabled()) {
                    log.debug("ID token for subject '{}' has expired at {}, refreshing it", (Object)jwt.getSubject(), (Object)jwt.getExpiresAt());
                }
                jwt = this.refreshIDToken(refreshToken);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("ID token for subject '{}' has expired at {}, refresh token not found", (Object)jwt.getSubject(), (Object)jwt.getExpiresAt());
                }
                throw new TokenExpiredException("ID token for subject '" + jwt.getSubject() + "' has expired at " + jwt.getExpiresAt());
            }
        }
        if (!this.verify(jwt)) {
            return null;
        }
        String cacheKey = jwt.getIssuer() + jwt.getSubject();
        Literal userId = ResourceFactory.createStringLiteral((String)jwt.getSubject());
        if (this.getSystem().getOIDCModelCache().containsKey((Object)cacheKey)) {
            agentModel = (Model)this.getSystem().getOIDCModelCache().get((Object)cacheKey);
        } else {
            QuerySolutionMap qsm = new QuerySolutionMap();
            qsm.add(SIOC.ID.getLocalName(), (RDFNode)userId);
            qsm.add(LACL.issuer.getLocalName(), (RDFNode)ResourceFactory.createStringLiteral((String)jwt.getIssuer()));
            agentModel = this.loadModel(pss, qsm, this.getAgentService());
        }
        Resource account = this.getResourceByPropertyValue(agentModel, (Property)SIOC.ID, (RDFNode)userId);
        if (account == null) {
            return null;
        }
        Resource agent = account.getRequiredProperty((Property)SIOC.ACCOUNT_OF).getResource();
        if (agent == null) {
            throw new IllegalStateException("UserAccount is not attached to an agent (sioc:account_of property is missing)");
        }
        long expiration = ChronoUnit.SECONDS.between(Instant.now(), jwt.getExpiresAt().toInstant());
        this.getSystem().getOIDCModelCache().put((Object)cacheKey, (Object)agentModel, expiration, TimeUnit.SECONDS);
        return new IDTokenSecurityContext(this.getScheme(), (Agent)agent.addProperty(RDF.type, (RDFNode)FOAF.Agent).as(Agent.class), jwtString);
    }

    protected String getJWTToken(ContainerRequestContext request) {
        if (request == null) {
            throw new IllegalArgumentException("ContainerRequest cannot be null");
        }
        Cookie jwtCookie = (Cookie)request.getCookies().get(COOKIE_NAME);
        if (jwtCookie != null) {
            return jwtCookie.getValue();
        }
        return null;
    }

    protected boolean verify(DecodedJWT idToken) {
        try (Response cr = this.getSystem().getNoCertClient().target("https://oauth2.googleapis.com/tokeninfo").queryParam("id_token", new Object[]{idToken.getToken()}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();){
            if (!cr.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                if (log.isDebugEnabled()) {
                    log.debug("Could not verify JWT token for subject '{}'", (Object)idToken.getSubject());
                }
                boolean bl = false;
                return bl;
            }
            JsonObject verifiedIdToken = (JsonObject)cr.readEntity(JsonObject.class);
            if (idToken.getIssuer().equals(verifiedIdToken.getString("iss")) && idToken.getSubject().equals(verifiedIdToken.getString("sub")) && idToken.getKeyId().equals(verifiedIdToken.getString("kid"))) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public void login(Application app, ContainerRequestContext request) {
        Response response = Response.seeOther((URI)this.getAuthorizeGoogleURL()).build();
        throw new WebApplicationException(response);
    }

    public void logout(Application app, ContainerRequestContext request) {
        Cookie cookie = (Cookie)request.getCookies().get(COOKIE_NAME);
        if (cookie != null) {
            NewCookie deleteCookie = new NewCookie(cookie.getName(), null, app.getBase().getURI(), null, 1, null, -1, new Date(0L), true, true);
            Response response = Response.seeOther((URI)request.getUriInfo().getAbsolutePath()).cookie(new NewCookie[]{deleteCookie}).build();
            throw new NotAuthorizedException(response);
        }
    }

    public DecodedJWT refreshIDToken(String refreshToken) {
        Form form = new Form().param("grant_type", "refresh_token").param("client_id", this.getClientID()).param("client_secret", this.getClientSecret()).param("refresh_token", refreshToken);
        try (Response cr = this.getSystem().getClient().target("https://oauth2.googleapis.com/token").request().post(Entity.form((Form)form));){
            JsonObject response = (JsonObject)cr.readEntity(JsonObject.class);
            if (response.containsKey((Object)"error")) {
                if (log.isErrorEnabled()) {
                    log.error("OAuth error: '{}'", (Object)response.getString("error"));
                }
                throw new InternalServerErrorException(response.getString("error"));
            }
            String idToken = response.getString("id_token");
            DecodedJWT decodedJWT = JWT.decode((String)idToken);
            return decodedJWT;
        }
    }

    public URI getLoginURL() {
        return this.getAdminApplication().getBaseURI().resolve("oauth2/login");
    }

    public URI getAuthorizeGoogleURL() {
        return this.getAdminApplication().getBaseURI().resolve("oauth2/authorize/google");
    }

    public AdminApplication getAdminApplication() {
        if (this.getApplication().canAs(EndUserApplication.class)) {
            return ((EndUserApplication)this.getApplication().as(EndUserApplication.class)).getAdminApplication();
        }
        return (AdminApplication)this.getApplication().as(AdminApplication.class);
    }

    public ParameterizedSparqlString getUserAccountQuery() {
        return this.userAccountQuery.copy();
    }

    private String getClientID() {
        return this.clientID;
    }

    private String getClientSecret() {
        return this.clientSecret;
    }
}

