/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.filter.request.auth;

import com.atomgraph.linkeddatahub.server.filter.request.auth.WebIDFilter;
import java.io.ByteArrayInputStream;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import javax.annotation.Priority;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.PreMatching;

@PreMatching
@Priority(value=5000)
public class ProxiedWebIDFilter
extends WebIDFilter {
    private static final String CLIENT_CERT_HEADER_NAME = "Client-Cert";
    private final CertificateFactory certFactory;

    public ProxiedWebIDFilter() {
        try {
            this.certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException ex) {
            throw new InternalServerErrorException((Throwable)ex);
        }
    }

    public X509Certificate getWebIDCertificate(ContainerRequestContext request) throws URISyntaxException, CertificateException, CertificateParsingException {
        if (request.getHeaderString(CLIENT_CERT_HEADER_NAME) != null) {
            String pemString = URLDecoder.decode(request.getHeaderString(CLIENT_CERT_HEADER_NAME), StandardCharsets.UTF_8);
            return (X509Certificate)this.getCertificateFactory().generateCertificate(new ByteArrayInputStream(pemString.getBytes()));
        }
        return null;
    }

    public CertificateFactory getCertificateFactory() {
        return this.certFactory;
    }
}

