/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.filter.request.auth;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.linkeddatahub.apps.model.Application;
import com.atomgraph.linkeddatahub.model.auth.Agent;
import com.atomgraph.linkeddatahub.server.exception.auth.webid.InvalidWebIDPublicKeyException;
import com.atomgraph.linkeddatahub.server.exception.auth.webid.WebIDDelegationException;
import com.atomgraph.linkeddatahub.server.exception.auth.webid.WebIDLoadingException;
import com.atomgraph.linkeddatahub.server.filter.request.AuthenticationFilter;
import com.atomgraph.linkeddatahub.server.security.WebIDSecurityContext;
import com.atomgraph.linkeddatahub.vocabulary.ACL;
import com.atomgraph.linkeddatahub.vocabulary.Cert;
import com.atomgraph.linkeddatahub.vocabulary.FOAF;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@PreMatching
@Priority(value=5000)
public class WebIDFilter
extends AuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(WebIDFilter.class);
    public static final int SAN_URI_NAME = 6;
    private final MediaTypes mediaTypes = new MediaTypes();
    private final MediaType[] acceptedTypes;
    @Context
    HttpServletRequest httpServletRequest;
    private ParameterizedSparqlString webIDQuery;

    public WebIDFilter() {
        ArrayList acceptedTypeList = new ArrayList();
        acceptedTypeList.addAll(this.mediaTypes.getReadable(Model.class));
        this.acceptedTypes = (MediaType[])acceptedTypeList.toArray(MediaType[]::new);
    }

    @PostConstruct
    public void init() {
        this.webIDQuery = new ParameterizedSparqlString(this.getSystem().getWebIDQuery().toString());
    }

    public String getScheme() {
        return "CLIENT_CERT";
    }

    public SecurityContext authenticate(ContainerRequestContext request) {
        try {
            Resource agent;
            X509Certificate webIDCert = this.getWebIDCertificate(request);
            if (log.isTraceEnabled()) {
                log.trace("Client WebID certificate: {}", (Object)webIDCert);
            }
            if (webIDCert == null) {
                return null;
            }
            webIDCert.checkValidity();
            RSAPublicKey publicKey = (RSAPublicKey)webIDCert.getPublicKey();
            URI webID = WebIDFilter.getWebIDURI((X509Certificate)webIDCert);
            if (webID == null) {
                if (log.isTraceEnabled()) {
                    log.trace("WebID not found in the client certificate, skipping WebID filter");
                }
                return null;
            }
            if (log.isTraceEnabled()) {
                log.trace("Client WebID: {}", (Object)webID);
            }
            if ((agent = this.authenticate(this.loadWebID(webID), webID, publicKey)) == null) {
                if (log.isErrorEnabled()) {
                    log.error("Client certificate public key did not match WebID public key: {}", (Object)webID);
                }
                throw new InvalidWebIDPublicKeyException(publicKey, webID.toString());
            }
            this.getSystem().getWebIDModelCache().put((Object)webID, (Object)agent.getModel());
            String onBehalfOf = request.getHeaderString("On-Behalf-Of");
            if (onBehalfOf != null) {
                URI principalWebID = new URI(onBehalfOf);
                Model principalWebIDModel = this.loadWebID(principalWebID);
                Resource principal = principalWebIDModel.createResource(onBehalfOf);
                if (agent.equals((Object)principal) || principal.getModel().contains(agent, (Property)ACL.delegates, (RDFNode)principal)) {
                    agent = principal;
                    this.getSystem().getWebIDModelCache().put((Object)principalWebID, (Object)principal.getModel());
                } else {
                    throw new WebIDDelegationException(agent, principal);
                }
            }
            return new WebIDSecurityContext(this.getScheme(), (Agent)agent.addProperty(RDF.type, (RDFNode)FOAF.Agent).as(Agent.class));
        }
        catch (CertificateException ex) {
            if (log.isErrorEnabled()) {
                log.error("WebID certificate error (could not parse, expired or not yet valid)", (Throwable)ex);
            }
            return null;
        }
        catch (URISyntaxException ex) {
            if (log.isErrorEnabled()) {
                log.error("Could not parse WebID URI: {}", (Object)ex.getInput(), (Object)ex);
            }
            return null;
        }
        catch (ProcessingException ex) {
            if (log.isErrorEnabled()) {
                log.error("Could not load WebID URI", (Throwable)ex);
            }
            return null;
        }
    }

    public X509Certificate getWebIDCertificate(ContainerRequestContext request) throws URISyntaxException, CertificateException, CertificateParsingException {
        X509Certificate[] certs;
        for (X509Certificate cert : certs = (X509Certificate[])this.getHttpServletRequest().getAttribute("javax.servlet.request.X509Certificate")) {
            if (WebIDFilter.getWebIDURI((X509Certificate)cert) == null) continue;
            return cert;
        }
        return null;
    }

    public static URI getWebIDURI(X509Certificate cert) throws URISyntaxException, CertificateParsingException {
        List[] sans;
        if (cert.getSubjectAlternativeNames() != null && (sans = (List[])cert.getSubjectAlternativeNames().toArray(List[]::new)).length > 0 && cert.getPublicKey() instanceof RSAPublicKey) {
            for (List san : sans) {
                Object type = san.get(0);
                if (!Integer.valueOf(type.toString()).equals(6)) continue;
                Object value = san.get(1);
                return new URI(value.toString());
            }
        }
        return null;
    }

    public Resource authenticate(Model webIDModel, URI webID, RSAPublicKey publicKey) {
        ParameterizedSparqlString pss = this.getWebIDQuery();
        pss.setLiteral("exp", ResourceFactory.createTypedLiteral((Object)publicKey.getPublicExponent()));
        pss.setLiteral("mod", ResourceFactory.createTypedLiteral((String)publicKey.getModulus().toString(16), (RDFDatatype)XSDDatatype.XSDhexBinary));
        try (QueryExecution qex = QueryExecution.create((Query)pss.asQuery(), (Model)webIDModel);){
            Resource agent;
            ResultSet resultSet = qex.execSelect();
            if (resultSet.hasNext() && (agent = resultSet.next().getResource("webid")) != null && agent.isURIResource() && agent.getURI().equals(webID.toString())) {
                Resource resource = agent;
                return resource;
            }
        }
        return null;
    }

    public Model loadWebID(URI webID) {
        if (this.getSystem().getWebIDModelCache().containsKey((Object)webID)) {
            return (Model)this.getSystem().getWebIDModelCache().get((Object)webID);
        }
        Model model = this.loadWebIDFromURI(webID);
        return model;
    }

    public Model loadWebIDFromURI(URI webID) {
        Model model;
        block20: {
            Model model2 = ModelFactory.createDefaultModel();
            URI webIDDoc = new URI(webID.getScheme(), webID.getSchemeSpecificPart(), null).normalize();
            Response cr1 = this.getClient().target(webIDDoc).request(this.getAcceptableMediaTypes()).get();
            try {
                if (!cr1.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                    if (log.isErrorEnabled()) {
                        log.error("Could not load WebID Agent: {}", (Object)webID.toString());
                    }
                    throw new WebIDLoadingException(webID, cr1);
                }
                cr1.getHeaders().putSingle((Object)"X-Request-URI", (Object)webIDDoc.toString());
                model2.add((Model)cr1.readEntity(Model.class));
                Resource certKeyRes = model2.createResource(webID.toString()).getPropertyResourceValue((Property)Cert.key);
                if (certKeyRes != null && certKeyRes.isURIResource()) {
                    URI certKey = URI.create(certKeyRes.getURI());
                    URI certKeyDoc = new URI(certKey.getScheme(), certKey.getSchemeSpecificPart(), null).normalize();
                    try (Response cr2 = this.getClient().target(certKeyDoc).request(this.getAcceptableMediaTypes()).get();){
                        if (!cr2.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                            if (log.isErrorEnabled()) {
                                log.error("Could not load WebID Key: {}", (Object)certKey.toString());
                            }
                            throw new WebIDLoadingException(webID, cr2);
                        }
                        cr2.getHeaders().putSingle((Object)"X-Request-URI", (Object)certKey.toString());
                        model2.add((Model)cr2.readEntity(Model.class));
                    }
                }
                model = model2;
                if (cr1 == null) break block20;
            }
            catch (Throwable throwable) {
                try {
                    if (cr1 != null) {
                        try {
                            cr1.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (URISyntaxException uRISyntaxException) {
                    return null;
                }
            }
            cr1.close();
        }
        return model;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public ParameterizedSparqlString getWebIDQuery() {
        return this.webIDQuery.copy();
    }

    public Client getClient() {
        return this.getSystem().getNoCertClient();
    }

    public MediaType[] getAcceptableMediaTypes() {
        return this.acceptedTypes;
    }

    public void login(Application app, ContainerRequestContext request) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void logout(Application app, ContainerRequestContext request) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

