/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.filter.response;

import com.atomgraph.client.vocabulary.AC;
import com.atomgraph.linkeddatahub.Application;
import com.atomgraph.linkeddatahub.apps.model.AdminApplication;
import com.atomgraph.linkeddatahub.apps.model.EndUserApplication;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.client.Client;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Response;
import org.apache.jena.rdf.model.Resource;
import org.glassfish.jersey.uri.UriComponent;

@Priority(value=5400)
public class BackendInvalidationFilter
implements ContainerResponseFilter {
    public static final String HEADER_NAME = "X-Escaped-Request-URI";
    @Inject
    Application system;
    @Inject
    Provider<com.atomgraph.linkeddatahub.apps.model.Application> app;

    public void filter(ContainerRequestContext req, ContainerResponseContext resp) throws IOException {
        if (this.getAdminApplication().getService().getProxy() == null) {
            return;
        }
        if (req.getMethod().equals("POST") && resp.getHeaderString("Location") != null) {
            URI location = (URI)((List)resp.getHeaders().get((Object)"Location")).get(0);
            URI parentURI = location.resolve("..").normalize();
            this.ban(this.getApplication().getService().getProxy(), location.toString()).close();
            this.ban(this.getAdminApplication().getService().getProxy(), location.toString()).close();
            this.ban(this.getApplication().getService().getProxy(), parentURI.toString()).close();
            this.ban(this.getApplication().getService().getProxy(), this.getApplication().getBaseURI().relativize(parentURI).toString()).close();
            if (req.getUriInfo().getQueryParameters().containsKey((Object)AC.forClass.getLocalName())) {
                String forClass = (String)req.getUriInfo().getQueryParameters().getFirst((Object)AC.forClass.getLocalName());
                this.ban(this.getApplication().getService().getProxy(), forClass).close();
            }
        }
        if (req.getMethod().equals("POST") || req.getMethod().equals("PUT") || req.getMethod().equals("DELETE") || req.getMethod().equals("PATCH")) {
            if (!this.getAdminApplication().getBaseURI().relativize(req.getUriInfo().getAbsolutePath()).isAbsolute()) {
                this.ban(this.getAdminApplication().getService().getProxy(), this.getAdminApplication().getBaseURI().toString()).close();
                this.ban(this.getAdminApplication().getService().getProxy(), "foaf:Agent").close();
                this.ban(this.getAdminApplication().getService().getProxy(), "acl:AuthenticatedAgent").close();
            }
            if (req.getUriInfo().getAbsolutePath().toString().endsWith("/")) {
                this.ban(this.getApplication().getService().getProxy(), req.getUriInfo().getAbsolutePath().toString()).close();
                this.ban(this.getAdminApplication().getService().getProxy(), req.getUriInfo().getAbsolutePath().toString()).close();
                if (!req.getUriInfo().getAbsolutePath().equals(this.getApplication().getBaseURI())) {
                    URI parentURI = req.getUriInfo().getAbsolutePath().resolve("..").normalize();
                    this.ban(this.getApplication().getService().getProxy(), parentURI.toString()).close();
                    this.ban(this.getApplication().getService().getProxy(), this.getApplication().getBaseURI().relativize(parentURI).toString()).close();
                }
            }
        }
    }

    public Response ban(Resource proxy, String url) {
        if (proxy == null) {
            throw new IllegalArgumentException("Proxy resource cannot be null");
        }
        if (url == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        return (Response)this.getClient().target(proxy.getURI()).request().header(HEADER_NAME, (Object)UriComponent.encode((String)url, (UriComponent.Type)UriComponent.Type.UNRESERVED)).method("BAN", Response.class);
    }

    public AdminApplication getAdminApplication() {
        if (this.getApplication().canAs(EndUserApplication.class)) {
            return ((EndUserApplication)this.getApplication().as(EndUserApplication.class)).getAdminApplication();
        }
        return (AdminApplication)this.getApplication().as(AdminApplication.class);
    }

    public com.atomgraph.linkeddatahub.apps.model.Application getApplication() {
        return (com.atomgraph.linkeddatahub.apps.model.Application)this.app.get();
    }

    public Application getSystem() {
        return this.system;
    }

    public Client getClient() {
        return this.getSystem().getClient();
    }
}

