/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.filter.response;

import com.atomgraph.core.vocabulary.SD;
import com.atomgraph.linkeddatahub.model.Service;
import com.atomgraph.linkeddatahub.model.auth.Agent;
import com.atomgraph.linkeddatahub.vocabulary.PROV;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=5100)
public class ProvenanceFilter
implements ContainerResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(ProvenanceFilter.class);
    @Inject
    Provider<Optional<Service>> service;

    public void filter(ContainerRequestContext request, ContainerResponseContext response) throws IOException {
        if (this.getService().isPresent() && (request.getMethod().equals("POST") || request.getMethod().equals("PUT") || request.getMethod().equals("PATCH") || request.getMethod().equals("DELETE"))) {
            String graphUri = request.getUriInfo().getAbsolutePath().toString();
            String graphGraphUri = "urn:uuid:" + UUID.randomUUID().toString();
            Model model = ModelFactory.createDefaultModel();
            Resource graph = model.createResource().addProperty(RDF.type, (RDFNode)SD.NamedGraph).addProperty((Property)SD.name, (RDFNode)model.createResource(graphUri)).addLiteral((Property)PROV.generatedAtTime, (Object)GregorianCalendar.getInstance());
            if (request.getSecurityContext().getUserPrincipal() instanceof Agent) {
                Agent agent = (Agent)request.getSecurityContext().getUserPrincipal();
                graph.addProperty((Property)PROV.wasAttributedTo, (RDFNode)agent);
            }
            if (log.isDebugEnabled()) {
                log.debug("PUTting {} triples of provenance metadata", (Object)graph.getModel().size());
            }
            ((Service)this.getService().get()).getDatasetAccessor().putModel(graphGraphUri, model);
        }
    }

    public Optional<Service> getService() {
        return (Optional)this.service.get();
    }
}

