/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.filter.response;

import com.atomgraph.client.vocabulary.AC;
import com.atomgraph.client.vocabulary.LDT;
import com.atomgraph.core.util.Link;
import com.atomgraph.core.vocabulary.SD;
import com.atomgraph.linkeddatahub.apps.model.Application;
import com.atomgraph.linkeddatahub.apps.model.Dataset;
import com.atomgraph.linkeddatahub.model.auth.Agent;
import com.atomgraph.linkeddatahub.server.security.AuthorizationContext;
import com.atomgraph.linkeddatahub.vocabulary.ACL;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=5300)
public class ResponseHeaderFilter
implements ContainerResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(ResponseHeaderFilter.class);
    @Inject
    Provider<Application> app;
    @Inject
    Provider<Optional<Dataset>> dataset;
    @Inject
    Provider<Optional<AuthorizationContext>> authorizationContext;

    public void filter(ContainerRequestContext request, ContainerResponseContext response) throws IOException {
        List linkValues;
        if (request.getSecurityContext().getUserPrincipal() instanceof Agent) {
            Agent agent = (Agent)request.getSecurityContext().getUserPrincipal();
            response.getHeaders().add((Object)"Link", (Object)new Link(URI.create(agent.getURI()), ACL.agent.getURI(), null));
        }
        if (this.getAuthorizationContext().isPresent()) {
            ((AuthorizationContext)this.getAuthorizationContext().get()).getModeURIs().forEach(mode -> response.getHeaders().add((Object)"Link", (Object)new Link(mode, ACL.mode.getURI(), null)));
        }
        if (this.getLinksByRel(linkValues = (List)response.getHeaders().get((Object)"Link"), LDT.base.getURI()).isEmpty()) {
            response.getHeaders().add((Object)"Link", (Object)new Link(this.getApplication().getBaseURI(), LDT.base.getURI(), null));
            response.getHeaders().add((Object)"Link", (Object)new Link(request.getUriInfo().getBaseUriBuilder().path("sparql").build(new Object[0]), SD.endpoint.getURI(), null));
            if (this.getApplication().getOntology() != null) {
                response.getHeaders().add((Object)"Link", (Object)new Link(URI.create(this.getApplication().getOntology().getURI()), LDT.ontology.getURI(), null));
            }
            if (this.getApplication().getStylesheet() != null) {
                response.getHeaders().add((Object)"Link", (Object)new Link(URI.create(this.getApplication().getStylesheet().getURI()), AC.stylesheet.getURI(), null));
            }
        } else if (this.getLinksByRel(linkValues, SD.endpoint.getURI()).isEmpty() && this.getDataset().isPresent() && ((Dataset)this.getDataset().get()).getService() != null) {
            response.getHeaders().add((Object)"Link", (Object)new Link(URI.create(((Dataset)this.getDataset().get()).getService().getSPARQLEndpoint().getURI()), SD.endpoint.getURI(), null));
        }
        if (response.getHeaders().get((Object)"Link") != null) {
            String linkValue = ((List)response.getHeaders().get((Object)"Link")).toString();
            response.getHeaders().putSingle((Object)"Link", (Object)linkValue.substring(1, linkValue.length() - 1));
        }
    }

    protected List<Link> getLinksByRel(List<Object> linkValues, String rel) {
        ArrayList<Link> relLinks = new ArrayList<Link>();
        if (linkValues != null) {
            linkValues.forEach(linkValue -> {
                try {
                    Link link = Link.valueOf((String)linkValue.toString());
                    if (link.getRel().equals(rel)) {
                        relLinks.add(link);
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            });
        }
        return relLinks;
    }

    public Application getApplication() {
        return (Application)this.app.get();
    }

    public Optional<Dataset> getDataset() {
        return (Optional)this.dataset.get();
    }

    public Optional<AuthorizationContext> getAuthorizationContext() {
        return (Optional)this.authorizationContext.get();
    }
}

